/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.layout.linkage.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.widget.NestedScrollView;
import com.xuexiang.xui.widget.layout.linkage.ChildLinkageEvent;
import com.xuexiang.xui.widget.layout.linkage.ILinkageScroll;
import com.xuexiang.xui.widget.layout.linkage.LinkageScrollHandler;

public class LinkageScrollView
extends NestedScrollView
implements ILinkageScroll {
    private ChildLinkageEvent mLinkageChildrenEvent;

    public LinkageScrollView(Context context) {
        this(context, null);
    }

    public LinkageScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LinkageScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.setVerticalScrollBarEnabled(false);
        if (!this.canScrollVertically(-1) && this.mLinkageChildrenEvent != null) {
            this.mLinkageChildrenEvent.onContentScrollToTop((View)this);
        }
        if (!this.canScrollVertically(1) && this.mLinkageChildrenEvent != null) {
            this.mLinkageChildrenEvent.onContentScrollToBottom((View)this);
        }
        if (this.mLinkageChildrenEvent != null) {
            this.mLinkageChildrenEvent.onContentScroll((View)this);
        }
    }

    @Override
    public void setChildLinkageEvent(ChildLinkageEvent event) {
        this.mLinkageChildrenEvent = event;
        if (this.mLinkageChildrenEvent != null) {
            this.mLinkageChildrenEvent.onContentScroll((View)this);
        }
    }

    @Override
    public LinkageScrollHandler provideScrollHandler() {
        return new LinkageScrollHandler(){

            @Override
            public void flingContent(View target, int velocityY) {
                LinkageScrollView.this.fling(velocityY);
            }

            @Override
            public void scrollContentToTop() {
                LinkageScrollView.this.scrollTo(0, 0);
            }

            @Override
            public void scrollContentToBottom() {
                LinkageScrollView.this.scrollTo(0, this.getVerticalScrollRange());
            }

            @Override
            public void stopContentScroll(View target) {
                LinkageScrollView.this.fling(0);
            }

            @Override
            public boolean canScrollVertically(int direction) {
                return LinkageScrollView.this.canScrollVertically(direction);
            }

            @Override
            public boolean isScrollable() {
                return true;
            }

            @Override
            @SuppressLint(value={"RestrictedApi"})
            public int getVerticalScrollExtent() {
                return LinkageScrollView.this.computeVerticalScrollExtent();
            }

            @Override
            @SuppressLint(value={"RestrictedApi"})
            public int getVerticalScrollOffset() {
                return LinkageScrollView.this.computeVerticalScrollOffset();
            }

            @Override
            @SuppressLint(value={"RestrictedApi"})
            public int getVerticalScrollRange() {
                return LinkageScrollView.this.computeVerticalScrollRange();
            }
        };
    }
}

