/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.layout.linkage.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.xuexiang.xui.widget.layout.linkage.ChildLinkageEvent;
import com.xuexiang.xui.widget.layout.linkage.ILinkageScroll;
import com.xuexiang.xui.widget.layout.linkage.LinkageScrollHandler;

public class LinkageRecyclerView
extends RecyclerView
implements ILinkageScroll {
    private ChildLinkageEvent mLinkageEvent;

    public LinkageRecyclerView(@NonNull Context context) {
        this(context, null);
    }

    public LinkageRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public LinkageRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
            }

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (!LinkageRecyclerView.this.canScrollVertically(-1) && LinkageRecyclerView.this.mLinkageEvent != null) {
                    LinkageRecyclerView.this.mLinkageEvent.onContentScrollToTop((View)LinkageRecyclerView.this);
                }
                if (!LinkageRecyclerView.this.canScrollVertically(1) && LinkageRecyclerView.this.mLinkageEvent != null) {
                    LinkageRecyclerView.this.mLinkageEvent.onContentScrollToBottom((View)LinkageRecyclerView.this);
                }
                if (LinkageRecyclerView.this.mLinkageEvent != null) {
                    LinkageRecyclerView.this.mLinkageEvent.onContentScroll((View)LinkageRecyclerView.this);
                }
            }
        });
    }

    @Override
    public void setChildLinkageEvent(ChildLinkageEvent event) {
        this.mLinkageEvent = event;
    }

    @Override
    public LinkageScrollHandler provideScrollHandler() {
        return new LinkageScrollHandler(){

            @Override
            public void flingContent(View target, int velocityY) {
                LinkageRecyclerView.this.fling(0, velocityY);
            }

            @Override
            public void scrollContentToTop() {
                LinkageRecyclerView.this.scrollToPosition(0);
            }

            @Override
            public void scrollContentToBottom() {
                RecyclerView.Adapter adapter = LinkageRecyclerView.this.getAdapter();
                if (adapter != null && adapter.getItemCount() > 0) {
                    LinkageRecyclerView.this.scrollToPosition(adapter.getItemCount() - 1);
                }
            }

            @Override
            public void stopContentScroll(View target) {
                LinkageRecyclerView.this.stopScroll();
            }

            @Override
            public boolean canScrollVertically(int direction) {
                return LinkageRecyclerView.this.canScrollVertically(direction);
            }

            @Override
            public boolean isScrollable() {
                return true;
            }

            @Override
            public int getVerticalScrollExtent() {
                return LinkageRecyclerView.this.computeVerticalScrollExtent();
            }

            @Override
            public int getVerticalScrollOffset() {
                return LinkageRecyclerView.this.computeVerticalScrollOffset();
            }

            @Override
            public int getVerticalScrollRange() {
                return LinkageRecyclerView.this.computeVerticalScrollRange();
            }
        };
    }
}

