/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.layout.linkage;

import android.graphics.PointF;
import androidx.annotation.NonNull;
import com.xuexiang.xui.logs.UILog;

public class PosIndicator {
    private static int SCROLL_ORIENTATION_NONE = -1;
    private static int SCROLL_ORIENTATION_VERTICAL = 0;
    private static int SCROLL_ORIENTATION_HORIZONTAL = 1;
    public static final String TAG = "PosIndicator";
    private int mStartPos = 0;
    public int mEndPos = 0;
    private PointF mLastMovePoint = new PointF();
    private PointF mDownPoint = new PointF();
    private PointF mReleasePoint = new PointF();
    private int mCurrentPos;
    private int mLastPos;
    private int mPressedPos;
    private float mOffsetX;
    private float mOffsetY;
    private float mDistanceToDownX;
    private float mDistanceToDownY;
    private boolean mIsUnderTouch;
    private boolean mConfigurationHasChanged;
    private float mSaveCurrentPosRatio;
    private int mTouchAction = -1;
    private int mTouchSlop;
    private boolean mIsDragging;
    private int mScrollOrientation = SCROLL_ORIENTATION_NONE;

    public void initStartAndEndPos(int startPos, int endPos) {
        this.mStartPos = startPos;
        this.mEndPos = endPos;
    }

    public void onDown(float x, float y) {
        this.mIsUnderTouch = true;
        this.mPressedPos = this.mCurrentPos;
        this.mLastMovePoint.set(x, y);
        this.mDownPoint.set(x, y);
        this.mTouchAction = 0;
    }

    public void onMove(float x, float y) {
        float offsetX = x - this.mLastMovePoint.x;
        float offsetY = y - this.mLastMovePoint.y;
        if (!this.mIsDragging && Math.abs(offsetY) > (float)this.mTouchSlop) {
            this.mIsDragging = true;
            offsetY = offsetY < 0.0f ? (offsetY += (float)this.mTouchSlop) : (offsetY -= (float)this.mTouchSlop);
            this.mScrollOrientation = SCROLL_ORIENTATION_VERTICAL;
        }
        if (!this.mIsDragging && Math.abs(offsetX) > (float)this.mTouchSlop) {
            this.mIsDragging = true;
            offsetX = offsetX < 0.0f ? (offsetX += (float)this.mTouchSlop) : (offsetX -= (float)this.mTouchSlop);
            this.mScrollOrientation = SCROLL_ORIENTATION_HORIZONTAL;
        }
        if (this.mIsDragging) {
            this.setOffset(offsetX, offsetY);
            this.setDistanceToDown(x, y);
            this.mLastMovePoint.set(x, y);
            this.mTouchAction = 2;
        }
    }

    public boolean isScrollVertical() {
        return this.mScrollOrientation == SCROLL_ORIENTATION_VERTICAL;
    }

    public boolean isScrollHorizontal() {
        return this.mScrollOrientation == SCROLL_ORIENTATION_HORIZONTAL;
    }

    public boolean isMoveUp() {
        return this.getOffsetY() < 0.0f;
    }

    public boolean isMoveDown() {
        return this.getOffsetY() > 0.0f;
    }

    public boolean isDragging() {
        return this.mIsDragging;
    }

    public void onRelease(float x, float y) {
        this.mIsUnderTouch = false;
        this.mIsDragging = false;
        this.mReleasePoint.set(x, y);
        this.mTouchAction = 1;
        this.mScrollOrientation = SCROLL_ORIENTATION_NONE;
    }

    public void onPointerDown(float x, float y) {
        this.mLastMovePoint.set(x, y);
    }

    public void onPointerUp(float x, float y) {
        this.mLastMovePoint.set(x, y);
    }

    public PointF getFingerDownPoint() {
        return this.mDownPoint;
    }

    public PointF getFingerMovePoint() {
        return this.mLastMovePoint;
    }

    public PointF getFingerReleasePoint() {
        return this.mReleasePoint;
    }

    public int getTouchAction() {
        return this.mTouchAction;
    }

    public void setTouchSlop(int touchSlop) {
        this.mTouchSlop = touchSlop;
    }

    public int getTouchSlop() {
        return this.mTouchSlop;
    }

    private void setDistanceToDown(float x, float y) {
        this.mDistanceToDownX = x - this.mDownPoint.x;
        this.mDistanceToDownY = y - this.mDownPoint.y;
    }

    public boolean isUnderTouch() {
        return this.mIsUnderTouch;
    }

    public boolean hasMovedAfterPressedDown() {
        return this.mCurrentPos != this.mPressedPos;
    }

    private void setOffset(float x, float y) {
        this.mOffsetX = x;
        this.mOffsetY = y;
    }

    public float getOffsetX() {
        return this.mOffsetX;
    }

    public float getOffsetY() {
        return this.mOffsetY;
    }

    public float getDistanceToDownX() {
        return this.mDistanceToDownX;
    }

    public float getDistanceToDownY() {
        return this.mDistanceToDownY;
    }

    public boolean isInStartPos() {
        return this.mCurrentPos == this.mStartPos;
    }

    public boolean isInEndPos() {
        return this.mCurrentPos == this.mEndPos;
    }

    public boolean hasLeftStartPos() {
        return this.mCurrentPos > this.mStartPos;
    }

    public boolean hasJustLeftStartPos() {
        return this.mLastPos == this.mStartPos && this.hasLeftStartPos();
    }

    public boolean hasJustBackStartPos() {
        return this.mLastPos != this.mStartPos && this.isInStartPos();
    }

    public boolean hasLeftEndPos() {
        return this.mCurrentPos < this.mEndPos;
    }

    public boolean hasJustLeftEndPos() {
        return this.mLastPos == this.mEndPos && this.hasLeftEndPos();
    }

    public boolean hasJustBackEndPos() {
        return this.mLastPos != this.mEndPos && this.isInEndPos();
    }

    public int checkPosBoundary(int to) {
        to = Math.max(to, this.mStartPos);
        to = Math.min(to, this.mEndPos);
        return to;
    }

    public void setCurrentPos(int currentPos) {
        this.mLastPos = this.mCurrentPos;
        this.mCurrentPos = currentPos;
    }

    public int getCurrentPos() {
        return this.mCurrentPos;
    }

    public int getLastPos() {
        return this.mLastPos;
    }

    public boolean willOverStartPos() {
        int to = (int)((float)this.mCurrentPos - this.mOffsetY);
        return to < this.mStartPos;
    }

    public boolean willOverEndPos() {
        int to = (int)((float)this.mCurrentPos - this.mOffsetY);
        return to > this.mEndPos;
    }

    public int getStartPos() {
        return this.mStartPos;
    }

    public int getEndPos() {
        return this.mEndPos;
    }

    public int getPosDistanceFromStart() {
        return this.mCurrentPos - this.mStartPos;
    }

    public int getPosOffset() {
        return this.mCurrentPos - this.mLastPos;
    }

    public void savePosOnConfigurationChanged() {
        this.mSaveCurrentPosRatio = (float)(this.mCurrentPos - this.mStartPos) * 1.0f / (float)(this.mEndPos - this.mStartPos);
        this.mSaveCurrentPosRatio = (float)Math.round(this.mSaveCurrentPosRatio * 10.0f) * 1.0f / 10.0f;
        UILog.dTag(TAG, "savePosOnConfigurationChanged, mSaveCurrentPosRation: " + this.mSaveCurrentPosRatio);
    }

    private void restorePosIfNeeded() {
        if (this.mConfigurationHasChanged) {
            this.mCurrentPos = (int)((float)this.mStartPos + (float)(this.mEndPos - this.mStartPos) * this.mSaveCurrentPosRatio);
            UILog.dTag(TAG, "Need restore current pos, mCurrentPos: " + this.mCurrentPos);
        }
    }

    @NonNull
    public String toString() {
        return "mCurrentPos: " + this.mCurrentPos + ", mLastPos: " + this.mLastPos + ", mPressedPos: " + this.mPressedPos + ", isInStartPos: " + this.isInStartPos() + ", isInEndPos: " + this.isInEndPos();
    }
}

