/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.layout.linkage;

import android.content.Context;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.Scroller;
import androidx.annotation.NonNull;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.NestedScrollingParentHelper;
import com.xuexiang.xui.logs.UILog;
import com.xuexiang.xui.widget.layout.linkage.ChildLinkageEvent;
import com.xuexiang.xui.widget.layout.linkage.ILinkageScroll;
import com.xuexiang.xui.widget.layout.linkage.LinkageScrollHandler;
import com.xuexiang.xui.widget.layout.linkage.PosIndicator;
import java.util.HashMap;
import java.util.Map;

public class LinkageScrollLayout
extends ViewGroup
implements NestedScrollingParent {
    public static final String TAG = "ELinkageScrollLayout";
    public static final int FLING_ORIENTATION_UP = 17;
    public static final int FLING_ORIENTATION_DOWN = 18;
    public static final int FLING_ORIENTATION_NONE = 0;
    public static final int LOC_SCROLL_DURATION = 280;
    private NestedScrollingParentHelper mParentHelper;
    private HashMap<View, ViewEdge> mEdgeList = new HashMap();
    private int mScrollRange;
    private Scroller mVelocityScroller;
    private Scroller mScroller;
    private Scroller mLocScroller;
    private VelocityTracker mVelocityTracker;
    private PosIndicator mPosIndicator;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private int mFlingOrientation = 0;
    private boolean mIsIntercept;
    private int mLastY;
    private ChildLinkageEvent mChildLinkageEvent = new ChildLinkageEvent(){

        @Override
        public void onContentScrollToTop(View target) {
            UILog.dTag(LinkageScrollLayout.TAG, "#onContentScrollToTop#");
            if (LinkageScrollLayout.this.mFlingOrientation != 18) {
                UILog.dTag(LinkageScrollLayout.TAG, "onContentScrollToTop, Invalid Fling Orientation");
                return;
            }
            if (LinkageScrollLayout.this.isFirstTarget(target)) {
                return;
            }
            if (!LinkageScrollLayout.this.getLinkageScrollHandler(target).isScrollable()) {
                return;
            }
            ViewEdge targetEdge = LinkageScrollLayout.this.getTargetEdge(target);
            if (targetEdge == null) {
                return;
            }
            if (LinkageScrollLayout.this.getScrollY() != targetEdge.topEdge) {
                return;
            }
            if (LinkageScrollLayout.this.mVelocityScroller.computeScrollOffset()) {
                float currVelocity = LinkageScrollLayout.this.mVelocityScroller.getCurrVelocity();
                currVelocity = currVelocity < 0.0f ? currVelocity : -currVelocity;
                UILog.dTag(LinkageScrollLayout.TAG, "onContentScrollToTop, currVelocity: " + currVelocity);
                LinkageScrollLayout.this.mVelocityScroller.abortAnimation();
                LinkageScrollLayout.this.parentFling(currVelocity);
            }
        }

        @Override
        public void onContentScrollToBottom(View target) {
            UILog.dTag(LinkageScrollLayout.TAG, "#onContentScrollToBottom#");
            if (LinkageScrollLayout.this.mFlingOrientation != 17) {
                UILog.dTag(LinkageScrollLayout.TAG, "onContentScrollToBottom, Invalid Fling Orientation");
                return;
            }
            if (LinkageScrollLayout.this.isLastTarget(target)) {
                return;
            }
            if (!LinkageScrollLayout.this.getLinkageScrollHandler(target).isScrollable()) {
                return;
            }
            ViewEdge targetEdge = LinkageScrollLayout.this.getTargetEdge(target);
            if (targetEdge == null) {
                return;
            }
            if (LinkageScrollLayout.this.getScrollY() != targetEdge.topEdge) {
                return;
            }
            if (LinkageScrollLayout.this.mVelocityScroller.computeScrollOffset()) {
                float currVelocity = LinkageScrollLayout.this.mVelocityScroller.getCurrVelocity();
                currVelocity = currVelocity > 0.0f ? currVelocity : -currVelocity;
                UILog.dTag(LinkageScrollLayout.TAG, "onContentScrollToBottom, currVelocity: " + currVelocity);
                LinkageScrollLayout.this.mVelocityScroller.abortAnimation();
                LinkageScrollLayout.this.parentFling(currVelocity);
            }
        }

        @Override
        public void onContentScroll(View target) {
            LinkageScrollLayout.this.awakenScrollBars();
        }
    };

    public LinkageScrollLayout(Context context) {
        this(context, null);
    }

    public LinkageScrollLayout(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public LinkageScrollLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mScroller = new Scroller(this.getContext());
        this.mLocScroller = new Scroller(this.getContext());
        this.mVelocityScroller = new Scroller(this.getContext());
        this.mPosIndicator = new PosIndicator();
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mMinimumVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mPosIndicator.setTouchSlop(viewConfiguration.getScaledTouchSlop());
        this.setWillNotDraw(false);
        this.setVerticalScrollBarEnabled(true);
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private boolean dispatchTouchEventSupper(MotionEvent event) {
        return super.dispatchTouchEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        float x = ev.getX();
        float y = ev.getY();
        switch (ev.getAction() & 0xFF) {
            case 0: {
                this.mPosIndicator.onDown(x, y);
                this.resetScroll();
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                break;
            }
            case 2: {
                this.mPosIndicator.onMove(x, y);
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(ev);
                break;
            }
            case 1: 
            case 3: {
                this.mPosIndicator.onRelease(x, y);
                break;
            }
        }
        return this.dispatchTouchEventSupper(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 2: {
                View target = this.getTouchTarget((int)ev.getRawX(), (int)ev.getRawY());
                if (!this.mPosIndicator.isDragging() || target == null || this.getLinkageScrollHandler(target).isScrollable()) break;
                this.mIsIntercept = true;
                ViewParent parent = this.getParent();
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 0: {
                this.mIsIntercept = false;
                this.checkTargetsScroll();
                break;
            }
            case 1: 
            case 3: {
                this.mIsIntercept = false;
                break;
            }
        }
        return this.mIsIntercept;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mLastY = (int)event.getY();
                break;
            }
            case 2: {
                if (this.mLastY == 0) {
                    this.mLastY = (int)event.getY();
                    return true;
                }
                int y = (int)event.getY();
                int dy = y - this.mLastY;
                this.mLastY = y;
                this.scrollBy(0, -dy);
                break;
            }
            case 1: 
            case 3: {
                this.mLastY = 0;
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int yVelocity = (int)this.mVelocityTracker.getYVelocity();
                this.recycleVelocityTracker();
                this.parentFling(-yVelocity);
                UILog.dTag(TAG, "#dispatchTouchEvent# ACTION_UP, yVelocity: " + yVelocity);
                break;
            }
        }
        return true;
    }

    private void resetScroll() {
        this.mFlingOrientation = 0;
        this.mVelocityScroller.abortAnimation();
        this.mScroller.abortAnimation();
        this.mLocScroller.abortAnimation();
    }

    private View getTouchTarget(float rawX, float rawY) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View target = this.getChildAt(i);
            int[] location = new int[2];
            target.getLocationOnScreen(location);
            int left = location[0];
            int top = location[1];
            int right = left + target.getWidth();
            int bottom = top + target.getHeight();
            RectF rect = new RectF((float)left, (float)top, (float)right, (float)bottom);
            if (!rect.contains(rawX, rawY)) continue;
            return target;
        }
        return null;
    }

    public void computeScroll() {
        int curY;
        if (this.mScroller.computeScrollOffset()) {
            curY = this.mScroller.getCurrY();
            this.scrollTo(0, curY, true);
            this.invalidate();
        }
        if (this.mLocScroller.computeScrollOffset()) {
            curY = this.mLocScroller.getCurrY();
            this.scrollTo(0, curY, false);
            this.invalidate();
            if (this.mLocScroller.isFinished()) {
                UILog.dTag(TAG, "#computeScroll#, LocScroll finished");
                this.checkTargetsScroll();
            }
        }
    }

    public void scrollTo(int x, int y, boolean isInertial) {
        this.awakenScrollBars();
        if (isInertial) {
            y = Math.max(y, 0);
            y = Math.min(y, this.mScrollRange);
            int edge = this.getNextEdge();
            if (this.mFlingOrientation == 17) {
                y = Math.min(y, edge);
            }
            if (this.mFlingOrientation == 18) {
                y = Math.max(y, edge);
            }
            this.scrollTo(x, y);
            int scrollY = this.getScrollY();
            if (scrollY == edge) {
                int velocity = (int)this.mScroller.getCurrVelocity();
                if (this.mFlingOrientation == 17) {
                    int n = velocity = velocity > 0 ? velocity : -velocity;
                }
                if (this.mFlingOrientation == 18) {
                    velocity = velocity < 0 ? velocity : -velocity;
                }
                UILog.dTag(TAG, "#scrollTo# To Edge: " + edge + ", velocity: " + velocity);
                this.mScroller.abortAnimation();
                View target = this.getTargetByEdge(edge);
                this.getLinkageScrollHandler(target).flingContent(target, velocity);
                this.trackVelocity(velocity);
            }
        } else {
            y = Math.max(y, 0);
            y = Math.min(y, this.mScrollRange);
            this.scrollTo(x, y);
        }
    }

    public void scrollBy(int x, int y) {
        int deltaY;
        this.awakenScrollBars();
        int scrollY = this.getScrollY();
        if (y < 0) {
            deltaY = scrollY + y < 0 ? -scrollY : y;
        } else {
            int n = deltaY = scrollY + y > this.mScrollRange ? this.mScrollRange - scrollY : y;
        }
        if (deltaY != 0) {
            super.scrollBy(x, deltaY);
        }
    }

    private View getTargetByEdge(int edge) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View target = this.getChildAt(i);
            ViewEdge viewEdge = this.mEdgeList.get(target);
            if (viewEdge == null || viewEdge.topEdge != edge) continue;
            return target;
        }
        return null;
    }

    private int getNextEdge() {
        int scrollY = this.getScrollY();
        if (this.mFlingOrientation == 17) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                int topEdge;
                View target = this.getChildAt(i);
                LinkageScrollHandler targetLinkageHandler = this.getLinkageScrollHandler(target);
                ViewEdge targetEdge = this.mEdgeList.get(target);
                int n = topEdge = targetEdge != null ? targetEdge.topEdge : 0;
                if (topEdge <= scrollY || !this.isTargetScrollable(target) || !targetLinkageHandler.canScrollVertically(1)) continue;
                return topEdge;
            }
        } else if (this.mFlingOrientation == 18) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                int topEdge;
                View target = this.getChildAt(i);
                LinkageScrollHandler targetLinkageHandler = this.getLinkageScrollHandler(target);
                ViewEdge targetEdge = this.mEdgeList.get(target);
                int n = topEdge = targetEdge != null ? targetEdge.topEdge : 0;
                if (topEdge >= scrollY || !this.isTargetScrollable(target) || !targetLinkageHandler.canScrollVertically(-1)) continue;
                return topEdge;
            }
        } else {
            throw new RuntimeException("#getNextEdge# unknown Fling Orientation");
        }
        return this.mFlingOrientation == 17 ? this.mScrollRange : 0;
    }

    private void parentFling(float velocityY) {
        if (Math.abs(velocityY) > (float)this.mMinimumVelocity) {
            this.mFlingOrientation = velocityY > 0.0f ? 17 : 18;
            this.mScroller.fling(0, this.getScrollY(), 1, (int)velocityY, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.invalidate();
        }
    }

    private boolean isFirstTarget(View target) {
        View first = this.getChildAt(0);
        return target == first;
    }

    private boolean isLastTarget(View target) {
        View last = this.getChildAt(this.getChildCount() - 1);
        return target == last;
    }

    private void checkTargetsScroll() {
        View child;
        int i;
        int scrollY = this.getScrollY();
        View target = null;
        for (Map.Entry<View, ViewEdge> entry : this.mEdgeList.entrySet()) {
            ViewEdge value = entry.getValue();
            if (scrollY < value.topEdge || scrollY >= value.bottomEdge) continue;
            target = entry.getKey();
            break;
        }
        if (target == null) {
            return;
        }
        int index = this.indexOfChild(target);
        UILog.dTag(TAG, "#checkTargetsScroll# index: " + index);
        for (i = 0; i < index; ++i) {
            child = this.getChildAt(i);
            this.scrollTargetContentToBottom(child);
        }
        for (i = index + 1; i < this.getChildCount(); ++i) {
            child = this.getChildAt(i);
            this.scrollTargetContentToTop(child);
        }
    }

    private void trackVelocity(float velocityY) {
        this.mVelocityScroller.fling(0, 0, 0, (int)velocityY, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.invalidate();
    }

    private LinkageScrollHandler getLinkageScrollHandler(View target) {
        return ((ILinkageScroll)target).provideScrollHandler();
    }

    private boolean isTargetScrollable(View target) {
        LinkageScrollHandler linkageScrollHandler = this.getLinkageScrollHandler(target);
        boolean isScrollable = linkageScrollHandler.isScrollable();
        return isScrollable && target.getHeight() >= this.getHeight();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            child.setVerticalScrollBarEnabled(false);
            child.setHorizontalScrollBarEnabled(false);
            if (!(child instanceof ILinkageScroll)) {
                throw new RuntimeException("Child in LinkageScrollLayout must implement ILinkageScroll");
            }
            ((ILinkageScroll)child).setChildLinkageEvent(this.mChildLinkageEvent);
            child.setOverScrollMode(2);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            View child = this.getChildAt(i);
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mScrollRange = 0;
        int childTop = t;
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            View child = this.getChildAt(i);
            int bottom = childTop + child.getMeasuredHeight();
            child.layout(l, childTop, r, bottom);
            childTop = bottom;
            this.mScrollRange += child.getHeight();
            this.mEdgeList.put(child, new ViewEdge(child.getTop(), child.getBottom()));
        }
        this.mScrollRange -= this.getMeasuredHeight();
    }

    public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int nestedScrollAxes) {
        UILog.dTag(TAG, "#onStartNestedScroll# nestedScrollAxes: " + nestedScrollAxes);
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int axes) {
        UILog.dTag(TAG, "#onNestedScrollAccepted# axes: " + axes);
        this.mParentHelper.onNestedScrollAccepted(child, target, axes);
        this.resetScroll();
    }

    public void onStopNestedScroll(@NonNull View child) {
        UILog.dTag(TAG, "#onStopNestedScroll# child: " + child);
        this.mParentHelper.onStopNestedScroll(child);
    }

    public void onNestedScroll(@NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        if (dyConsumed != 0 && dyUnconsumed != 0) {
            this.scrollBy(0, dyUnconsumed);
        }
    }

    public void onNestedPreScroll(@NonNull View target, int dx, int dy, @NonNull int[] consumed) {
        UILog.dTag(TAG, "#onNestedPreScroll# dy: " + dy);
        boolean moveUp = dy > 0;
        boolean moveDown = !moveUp;
        int scrollY = this.getScrollY();
        ViewEdge targetEdge = this.getTargetEdge(target);
        LinkageScrollHandler targetScrollHandler = ((ILinkageScroll)target).provideScrollHandler();
        if (scrollY == targetEdge.topEdge) {
            if (moveDown && !targetScrollHandler.canScrollVertically(-1) || moveUp && !targetScrollHandler.canScrollVertically(1)) {
                this.scrollBy(0, dy);
                consumed[1] = dy;
            } else {
                UILog.dTag(TAG, "#onNestedPreScroll#, handle scroll by " + target);
            }
        } else if (scrollY > targetEdge.topEdge) {
            if (moveUp) {
                this.scrollBy(0, dy);
                consumed[1] = dy;
            }
            if (moveDown) {
                int end = scrollY + dy;
                int deltaY = end > targetEdge.topEdge ? dy : targetEdge.topEdge - scrollY;
                this.scrollBy(0, deltaY);
                consumed[1] = deltaY;
            }
        } else {
            if (moveDown) {
                this.scrollBy(0, dy);
                consumed[1] = dy;
            }
            if (moveUp) {
                int end = scrollY + dy;
                int deltaY = end < targetEdge.topEdge ? dy : targetEdge.topEdge - scrollY;
                this.scrollBy(0, deltaY);
                consumed[1] = deltaY;
            }
        }
    }

    public void gotoChild(int index) {
        View target;
        int i;
        this.smoothScrollToIndex(index);
        for (i = 0; i < index; ++i) {
            target = this.getChildAt(i);
            this.scrollTargetContentToBottom(target);
        }
        for (i = index; i < this.getChildCount(); ++i) {
            target = this.getChildAt(i);
            this.scrollTargetContentToTop(target);
        }
    }

    private void scrollToIndex(int index) {
        index = Math.max(index, 0);
        View target = this.getChildAt(index = Math.min(index, this.getChildCount() - 1));
        ViewEdge viewEdge = this.mEdgeList.get(target);
        if (viewEdge != null) {
            this.scrollTo(0, viewEdge.topEdge, false);
        }
    }

    private void smoothScrollToIndex(int index) {
        index = Math.max(index, 0);
        View target = this.getChildAt(index = Math.min(index, this.getChildCount() - 1));
        ViewEdge viewEdge = this.mEdgeList.get(target);
        if (viewEdge != null) {
            this.mLocScroller.startScroll(0, this.getScrollY(), 0, viewEdge.topEdge - this.getScrollY(), 280);
            this.invalidate();
        }
    }

    private void scrollTargetContentToTop(View target) {
        LinkageScrollHandler targetScrollHandler = ((ILinkageScroll)target).provideScrollHandler();
        if (targetScrollHandler.isScrollable() && targetScrollHandler.canScrollVertically(-1)) {
            targetScrollHandler.scrollContentToTop();
        }
    }

    private void scrollTargetContentToBottom(View target) {
        LinkageScrollHandler targetScrollHandler = ((ILinkageScroll)target).provideScrollHandler();
        if (targetScrollHandler.isScrollable() && targetScrollHandler.canScrollVertically(1)) {
            targetScrollHandler.scrollContentToBottom();
        }
    }

    private ViewEdge getTargetEdge(View target) {
        ViewEdge viewEdge = this.mEdgeList.get(target);
        return viewEdge;
    }

    public boolean onNestedFling(@NonNull View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    public boolean onNestedPreFling(@NonNull View target, float velocityX, float velocityY) {
        UILog.dTag(TAG, "#onNestedPreFling# velocityY: " + velocityY);
        int scrollY = this.getScrollY();
        ViewEdge targetEdge = this.getTargetEdge(target);
        int n = this.mFlingOrientation = velocityY > 0.0f ? 17 : 18;
        if (scrollY == targetEdge.topEdge) {
            this.trackVelocity(velocityY);
            return false;
        }
        this.parentFling(velocityY);
        return true;
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    protected int computeVerticalScrollExtent() {
        return super.computeVerticalScrollExtent();
    }

    protected int computeVerticalScrollRange() {
        int range = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            ILinkageScroll linkageScroll = (ILinkageScroll)child;
            int childRange = linkageScroll.provideScrollHandler().getVerticalScrollRange();
            range += childRange;
        }
        return range;
    }

    protected int computeVerticalScrollOffset() {
        int offset = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            ILinkageScroll linkageScroll = (ILinkageScroll)child;
            int childOffset = linkageScroll.provideScrollHandler().getVerticalScrollOffset();
            offset += childOffset;
        }
        return offset += this.getScrollY();
    }

    private static class ViewEdge {
        public int topEdge;
        public int bottomEdge;

        public ViewEdge(int topEdge, int bottomEdge) {
            this.topEdge = topEdge;
            this.bottomEdge = bottomEdge;
        }
    }
}

