/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.layout;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.layout.interpolator.FastOutSlowInInterpolator;

public class ExpandableLayout
extends FrameLayout {
    public static final String KEY_SUPER_STATE = "key_super_state";
    public static final String KEY_EXPANSION = "key_expansion";
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final int DEFAULT_DURATION = 300;
    private int mDuration = 300;
    private float mParallax;
    private float mExpansion;
    private int mOrientation;
    private int mState;
    private Interpolator mInterpolator = new FastOutSlowInInterpolator();
    private ValueAnimator mAnimator;
    private OnExpansionChangedListener mListener;

    public ExpandableLayout(Context context) {
        this(context, null);
    }

    public ExpandableLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ExpandableLayout);
            this.mDuration = a.getInt(R.styleable.ExpandableLayout_el_duration, 300);
            this.mExpansion = a.getBoolean(R.styleable.ExpandableLayout_el_expanded, false) ? 1.0f : 0.0f;
            this.mOrientation = a.getInt(R.styleable.ExpandableLayout_android_orientation, 1);
            this.mParallax = a.getFloat(R.styleable.ExpandableLayout_el_parallax, 1.0f);
            a.recycle();
            this.mState = this.mExpansion == 0.0f ? 0 : 3;
            this.setParallax(this.mParallax);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        this.mExpansion = this.isExpanded() ? 1.0f : 0.0f;
        bundle.putFloat(KEY_EXPANSION, this.mExpansion);
        bundle.putParcelable(KEY_SUPER_STATE, superState);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        Bundle bundle = (Bundle)parcelable;
        this.mExpansion = bundle.getFloat(KEY_EXPANSION);
        this.mState = this.mExpansion == 1.0f ? 3 : 0;
        Parcelable superState = bundle.getParcelable(KEY_SUPER_STATE);
        super.onRestoreInstanceState(superState);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int size = this.mOrientation == 0 ? width : height;
        this.setVisibility(this.mExpansion == 0.0f && size == 0 ? 8 : 0);
        int expansionDelta = size - Math.round((float)size * this.mExpansion);
        if (this.mParallax > 0.0f) {
            float parallaxDelta = (float)expansionDelta * this.mParallax;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (this.mOrientation == 0) {
                    int direction = -1;
                    if (Build.VERSION.SDK_INT >= 17 && this.getLayoutDirection() == 1) {
                        direction = 1;
                    }
                    child.setTranslationX((float)direction * parallaxDelta);
                    continue;
                }
                child.setTranslationY(-parallaxDelta);
            }
        }
        if (this.mOrientation == 0) {
            this.setMeasuredDimension(width - expansionDelta, height);
        } else {
            this.setMeasuredDimension(width, height - expansionDelta);
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
        }
        super.onConfigurationChanged(newConfig);
    }

    public int getState() {
        return this.mState;
    }

    public boolean isExpanded() {
        return this.mState == 2 || this.mState == 3;
    }

    public void toggle() {
        this.toggle(true);
    }

    public void toggle(boolean animate) {
        if (this.isExpanded()) {
            this.collapse(animate);
        } else {
            this.expand(animate);
        }
    }

    public void expand() {
        this.expand(true);
    }

    public void expand(boolean animate) {
        this.setExpanded(true, animate);
    }

    public void collapse() {
        this.collapse(true);
    }

    public void collapse(boolean animate) {
        this.setExpanded(false, animate);
    }

    public void setExpanded(boolean expand) {
        this.setExpanded(expand, true);
    }

    public void setExpanded(boolean expand, boolean animate) {
        int targetExpansion;
        if (expand == this.isExpanded()) {
            return;
        }
        int n = targetExpansion = expand ? 1 : 0;
        if (animate) {
            this.animateSize(targetExpansion);
        } else {
            this.setExpansion(targetExpansion);
        }
    }

    public int getDuration() {
        return this.mDuration;
    }

    public ExpandableLayout setInterpolator(Interpolator interpolator2) {
        this.mInterpolator = interpolator2;
        return this;
    }

    public ExpandableLayout setDuration(int duration) {
        this.mDuration = duration;
        return this;
    }

    public float getExpansion() {
        return this.mExpansion;
    }

    public void setExpansion(float expansion) {
        if (this.mExpansion == expansion) {
            return;
        }
        float delta = expansion - this.mExpansion;
        if (expansion == 0.0f) {
            this.mState = 0;
        } else if (expansion == 1.0f) {
            this.mState = 3;
        } else if (delta < 0.0f) {
            this.mState = 1;
        } else if (delta > 0.0f) {
            this.mState = 2;
        }
        this.setVisibility(this.mState == 0 ? 8 : 0);
        this.mExpansion = expansion;
        this.requestLayout();
        if (this.mListener != null) {
            this.mListener.onExpansionChanged(expansion, this.mState);
        }
    }

    public float getParallax() {
        return this.mParallax;
    }

    public ExpandableLayout setParallax(float parallax) {
        this.mParallax = parallax = Math.min(1.0f, Math.max(0.0f, parallax));
        return this;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public ExpandableLayout setOrientation(int orientation) {
        if (orientation < 0 || orientation > 1) {
            throw new IllegalArgumentException("Orientation must be either 0 (horizontal) or 1 (vertical)");
        }
        this.mOrientation = orientation;
        return this;
    }

    public ExpandableLayout setOnExpansionChangedListener(OnExpansionChangedListener listener) {
        this.mListener = listener;
        return this;
    }

    private void animateSize(int targetExpansion) {
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
        this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mExpansion, targetExpansion});
        this.mAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
        this.mAnimator.setDuration((long)this.mDuration);
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ExpandableLayout.this.setExpansion(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        this.mAnimator.addListener((Animator.AnimatorListener)new ExpansionListener(targetExpansion));
        this.mAnimator.start();
    }

    private class ExpansionListener
    implements Animator.AnimatorListener {
        private int targetExpansion;
        private boolean canceled;

        public ExpansionListener(int targetExpansion) {
            this.targetExpansion = targetExpansion;
        }

        public void onAnimationStart(Animator animation) {
            ExpandableLayout.this.mState = this.targetExpansion == 0 ? 1 : 2;
        }

        public void onAnimationEnd(Animator animation) {
            if (!this.canceled) {
                ExpandableLayout.this.mState = this.targetExpansion == 0 ? 0 : 3;
                ExpandableLayout.this.setExpansion(this.targetExpansion);
            }
        }

        public void onAnimationCancel(Animator animation) {
            this.canceled = true;
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    public static interface OnExpansionChangedListener {
        public void onExpansionChanged(float var1, int var2);
    }

    public static interface State {
        public static final int COLLAPSED = 0;
        public static final int COLLAPSING = 1;
        public static final int EXPANDING = 2;
        public static final int EXPANDED = 3;
    }
}

