/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.strategy.impl;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.xuexiang.xui.widget.imageview.strategy.DiskCacheStrategyEnum;
import com.xuexiang.xui.widget.imageview.strategy.IImageLoadStrategy;
import com.xuexiang.xui.widget.imageview.strategy.ILoadListener;
import com.xuexiang.xui.widget.imageview.strategy.LoadOption;

public class GlideImageLoadStrategy
implements IImageLoadStrategy {
    @Override
    public void loadImage(@NonNull ImageView imageView, Object path) {
        Glide.with((Context)imageView.getContext()).load(path).into(imageView);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, final @NonNull ILoadListener listener) {
        Glide.with((Context)imageView.getContext()).load(path).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                listener.onLoadFailed((Throwable)e);
                return false;
            }

            public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                listener.onLoadSuccess();
                return false;
            }
        }).into(imageView);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path) {
        Glide.with((Context)imageView.getContext()).asGif().load(path).into(imageView);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, final @NonNull ILoadListener listener) {
        Glide.with((Context)imageView.getContext()).asGif().load(path).listener((RequestListener)new RequestListener<GifDrawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                listener.onLoadFailed((Throwable)e);
                return false;
            }

            public boolean onResourceReady(GifDrawable resource, Object model, Target<GifDrawable> target, DataSource dataSource, boolean isFirstResource) {
                listener.onLoadSuccess();
                return false;
            }
        }).into(imageView);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, DiskCacheStrategyEnum strategy) {
        this.loadImage(imageView, path, LoadOption.of(strategy));
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, DiskCacheStrategyEnum strategy, ILoadListener listener) {
        this.loadImage(imageView, path, LoadOption.of(strategy), listener);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, DiskCacheStrategyEnum strategy) {
        this.loadGifImage(imageView, path, LoadOption.of(strategy));
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, DiskCacheStrategyEnum strategy, ILoadListener listener) {
        this.loadGifImage(imageView, path, LoadOption.of(strategy), listener);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, Drawable placeholder, DiskCacheStrategyEnum strategy) {
        this.loadImage(imageView, path, LoadOption.of(placeholder).setCacheStrategy(strategy));
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, Drawable placeholder, DiskCacheStrategyEnum strategy, ILoadListener listener) {
        this.loadImage(imageView, path, LoadOption.of(placeholder).setCacheStrategy(strategy), listener);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, Drawable placeholder, DiskCacheStrategyEnum strategy) {
        this.loadGifImage(imageView, path, LoadOption.of(placeholder).setCacheStrategy(strategy));
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, Drawable placeholder, DiskCacheStrategyEnum strategy, ILoadListener listener) {
        this.loadGifImage(imageView, path, LoadOption.of(placeholder).setCacheStrategy(strategy), listener);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, LoadOption loadOption) {
        this.loadImage(imageView, path, loadOption, null);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, LoadOption loadOption) {
        this.loadGifImage(imageView, path, loadOption, null);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void loadImage(@NonNull ImageView imageView, Object path, LoadOption loadOption, final ILoadListener listener) {
        RequestBuilder builder = Glide.with((Context)imageView.getContext()).load(path).apply((BaseRequestOptions)this.getRequestOptions(loadOption));
        if (listener != null) {
            builder.listener((RequestListener)new RequestListener<Drawable>(){

                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                    listener.onLoadFailed((Throwable)e);
                    return false;
                }

                public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                    listener.onLoadSuccess();
                    return false;
                }
            });
        }
        builder.into(imageView);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void loadGifImage(@NonNull ImageView imageView, Object path, LoadOption loadOption, final ILoadListener listener) {
        RequestBuilder builder = Glide.with((Context)imageView.getContext()).asGif().load(path).apply((BaseRequestOptions)this.getRequestOptions(loadOption));
        if (listener != null) {
            builder.listener((RequestListener)new RequestListener<GifDrawable>(){

                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                    listener.onLoadFailed((Throwable)e);
                    return false;
                }

                public boolean onResourceReady(GifDrawable resource, Object model, Target<GifDrawable> target, DataSource dataSource, boolean isFirstResource) {
                    listener.onLoadSuccess();
                    return false;
                }
            });
        }
        builder.into(imageView);
    }

    @SuppressLint(value={"CheckResult"})
    private RequestOptions getRequestOptions(LoadOption loadOption) {
        RequestOptions options = new RequestOptions();
        if (loadOption.hasSize()) {
            options.override(loadOption.getWidth(), loadOption.getHeight());
        }
        if (loadOption.placeholder != null) {
            options.placeholder(loadOption.placeholder);
        }
        if (loadOption.error != null) {
            options.error(loadOption.error);
        }
        if (loadOption.cacheStrategy != null) {
            options.diskCacheStrategy(this.toGlideStrategy(loadOption.cacheStrategy));
        }
        switch (loadOption.align) {
            case CENTER_CROP: {
                options.centerCrop();
                break;
            }
            case CIRCLE_CROP: {
                options.circleCrop();
                break;
            }
            case CENTER_INSIDE: {
                options.centerInside();
                break;
            }
            case FIT_CENTER: {
                options.fitCenter();
                break;
            }
        }
        options.timeout(loadOption.timeoutMs);
        return options;
    }

    @Override
    public void clearCache(Context context) {
        Glide.get((Context)context).clearMemory();
        Glide.get((Context)context).clearDiskCache();
    }

    @Override
    public void clearMemoryCache(Context context) {
        Glide.get((Context)context).clearMemory();
    }

    @Override
    public void clearDiskCache(Context context) {
        Glide.get((Context)context).clearDiskCache();
    }

    private DiskCacheStrategy toGlideStrategy(DiskCacheStrategyEnum strategyEnum) {
        switch (strategyEnum) {
            case ALL: {
                return DiskCacheStrategy.ALL;
            }
            case NONE: {
                return DiskCacheStrategy.NONE;
            }
            case DATA: {
                return DiskCacheStrategy.DATA;
            }
            case RESOURCE: {
                return DiskCacheStrategy.RESOURCE;
            }
            case AUTOMATIC: {
                return DiskCacheStrategy.AUTOMATIC;
            }
        }
        return DiskCacheStrategy.AUTOMATIC;
    }
}

