/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.strategy;

import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import com.xuexiang.xui.widget.imageview.strategy.AlignEnum;
import com.xuexiang.xui.widget.imageview.strategy.DiskCacheStrategyEnum;

public class LoadOption {
    public static final int DEFAULT_TIMEOUT = 2500;
    public DiskCacheStrategyEnum cacheStrategy;
    public Drawable placeholder;
    public Drawable error;
    public int width;
    public int height;
    public AlignEnum align = AlignEnum.DEFAULT;
    public int timeoutMs = 2500;

    public static LoadOption of(DiskCacheStrategyEnum cacheStrategy) {
        return new LoadOption(cacheStrategy);
    }

    public static LoadOption of(Drawable placeholder) {
        return new LoadOption(placeholder);
    }

    public LoadOption() {
    }

    public LoadOption(DiskCacheStrategyEnum cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
    }

    public LoadOption(Drawable placeholder) {
        this.placeholder = placeholder;
    }

    public DiskCacheStrategyEnum getCacheStrategy() {
        return this.cacheStrategy;
    }

    public LoadOption setCacheStrategy(DiskCacheStrategyEnum cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
        return this;
    }

    public Drawable getPlaceholder() {
        return this.placeholder;
    }

    public LoadOption setPlaceholder(Drawable placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public LoadOption setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public boolean hasSize() {
        return this.width != 0 && this.height != 0;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public AlignEnum getAlign() {
        return this.align;
    }

    public LoadOption setAlign(AlignEnum align) {
        this.align = align;
        return this;
    }

    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    public LoadOption setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    public Drawable getError() {
        return this.error;
    }

    public LoadOption setError(Drawable error) {
        this.error = error;
        return this;
    }

    @NonNull
    public String toString() {
        return "LoadOption{cacheStrategy=" + (Object)((Object)this.cacheStrategy) + ", placeholder=" + this.placeholder + ", width=" + this.width + ", height=" + this.height + '}';
    }
}

