/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.preview.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.ViewPager;
import com.xuexiang.xui.R;

public class BezierBannerView
extends View
implements ViewPager.OnPageChangeListener {
    private Paint mCirclePaint;
    private Paint mCirclePaint2;
    private Path mPath = new Path();
    private Path mPath2 = new Path();
    private int mSelectedColor;
    private int mUnSelectedColor;
    private float distance = 80.0f;
    private float mRadius = 30.0f;
    private float mChangeRadius;
    private float mNomarlRadius = 20.0f;
    private float mChangeBgRadius;
    private float mSupportChangeRadius;
    private float mSupport_Next_ChangeRadius;
    float mCenterPointX;
    float mCenterPointY;
    float mSupportCircleX;
    float mSupportCircleY;
    float mSupport_next_centerX;
    float mSupport_next_centerY;
    float mbgNextPointX;
    float mbgNextPointY;
    private boolean autoMove = false;
    private float mProgress = 0.0f;
    private float mProgress2 = 0.0f;
    private float mOriginProgress;
    private int mSelectedIndex = 0;
    private int count;
    private int MOVE_STEP_ONE = 1;
    private int MOVE_STEP_TWO = 2;
    float controlPointX;
    float controlPointY;
    float mStartX;
    float mStartY;
    float endPointX;
    float endPointY;
    private int mDrection;
    public static int DIRECTION_LEFT = 1;
    public static int DIRECTION_RIGHT = 2;
    private static final String TAG = BezierBannerView.class.getName();
    Interpolator accelerateinterpolator = new AccelerateDecelerateInterpolator();

    public BezierBannerView(Context context) {
        this(context, null);
    }

    public BezierBannerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BezierBannerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs);
        this.initPaint();
    }

    private void initPaint() {
        Paint p = new Paint(1);
        p.setColor(this.mSelectedColor);
        p.setStyle(Paint.Style.FILL);
        p.setAntiAlias(true);
        p.setDither(true);
        this.mCirclePaint = p;
        Paint p1 = new Paint(1);
        p1.setColor(this.mUnSelectedColor);
        p1.setStyle(Paint.Style.FILL);
        p1.setAntiAlias(true);
        p1.setDither(true);
        this.mCirclePaint2 = p1;
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.BezierBannerView);
        this.mSelectedColor = typedArray.getColor(R.styleable.BezierBannerView_bbv_selectedColor, -1);
        this.mUnSelectedColor = typedArray.getColor(R.styleable.BezierBannerView_bbv_unSelectedColor, -5592406);
        this.mRadius = typedArray.getDimension(R.styleable.BezierBannerView_bbv_selectedRadius, this.mRadius);
        this.mNomarlRadius = typedArray.getDimension(R.styleable.BezierBannerView_bbv_unSelectedRadius, this.mNomarlRadius);
        this.distance = typedArray.getDimension(R.styleable.BezierBannerView_bbv_spacing, this.distance);
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = (int)(this.mNomarlRadius * 2.0f * (float)this.count + (this.mRadius - this.mNomarlRadius) * 2.0f + (float)(this.count - 1) * this.distance + (float)this.getPaddingLeft() + (float)this.getPaddingRight());
        int height = (int)(2.0f * this.mRadius + (float)this.getPaddingTop() + (float)this.getPaddingBottom());
        int mWidth = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(widthSize, width) : widthSize);
        int mHeight = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(heightSize, height) : heightSize);
        this.setMeasuredDimension(mWidth, mHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
        for (int i = 0; i < this.count; ++i) {
            if (this.mDrection == DIRECTION_RIGHT) {
                if (i == this.mSelectedIndex || i == this.mSelectedIndex + 1) continue;
                canvas.drawCircle(this.getCenterPointAt(i), this.mRadius, this.mNomarlRadius, this.mCirclePaint2);
                continue;
            }
            if (this.mDrection != DIRECTION_LEFT || i == this.mSelectedIndex || i == this.mSelectedIndex - 1) continue;
            canvas.drawCircle(this.getCenterPointAt(i), this.mRadius, this.mNomarlRadius, this.mCirclePaint2);
        }
        canvas.drawCircle(this.mSupport_next_centerX, this.mSupport_next_centerY, this.mSupport_Next_ChangeRadius, this.mCirclePaint2);
        canvas.drawCircle(this.mbgNextPointX, this.mbgNextPointY, this.mChangeBgRadius, this.mCirclePaint2);
        canvas.drawPath(this.mPath2, this.mCirclePaint2);
        canvas.drawCircle(this.mSupportCircleX, this.mSupportCircleY, this.mSupportChangeRadius, this.mCirclePaint);
        canvas.drawCircle(this.mCenterPointX, this.mCenterPointY, this.mChangeRadius, this.mCirclePaint);
        canvas.drawPath(this.mPath, this.mCirclePaint);
        canvas.restore();
    }

    public void setProgress(float progress) {
        if (progress == 0.0f) {
            return;
        }
        this.mOriginProgress = progress;
        if ((double)progress <= 0.5) {
            this.mProgress = progress / 0.5f;
            this.mProgress2 = 0.0f;
        } else {
            this.mProgress2 = (progress - 0.5f) / 0.5f;
            this.mProgress = 1.0f;
        }
        if (this.mDrection == DIRECTION_RIGHT) {
            this.moveToNext();
        } else {
            this.moveToPrivous();
        }
        this.invalidate();
    }

    private void moveToNext() {
        this.mPath.reset();
        this.mPath2.reset();
        float mRadiusProgress = this.accelerateinterpolator.getInterpolation(this.mOriginProgress);
        this.mCenterPointX = this.getValue(this.getCenterPointAt(this.mSelectedIndex), this.getCenterPointAt(this.mSelectedIndex + 1) - this.mRadius, this.MOVE_STEP_TWO);
        this.mCenterPointY = this.mRadius;
        this.mChangeRadius = this.getValue(this.mRadius, 0.0f, mRadiusProgress);
        double radian = Math.toRadians(this.getValue(45.0f, 0.0f, this.MOVE_STEP_ONE));
        float mX = (float)(Math.sin(radian) * (double)this.mChangeRadius);
        float mY = (float)(Math.cos(radian) * (double)this.mChangeRadius);
        this.mSupportCircleX = this.getValue(this.getCenterPointAt(this.mSelectedIndex) + this.mRadius, this.getCenterPointAt(this.mSelectedIndex + 1), this.MOVE_STEP_ONE);
        this.mSupportCircleY = this.mRadius;
        this.mSupportChangeRadius = this.getValue(0.0f, this.mRadius, mRadiusProgress);
        double supportradian = Math.toRadians(this.getValue(0.0f, 45.0f, this.MOVE_STEP_TWO));
        float msupportradianX = (float)(Math.sin(supportradian) * (double)this.mSupportChangeRadius);
        float msupportradianY = (float)(Math.cos(supportradian) * (double)this.mSupportChangeRadius);
        this.mStartX = this.mCenterPointX + mX;
        this.mStartY = this.mCenterPointY - mY;
        this.endPointX = this.mSupportCircleX - msupportradianX;
        this.endPointY = this.mRadius - msupportradianY;
        this.controlPointX = this.getValueForAll(this.getCenterPointAt(this.mSelectedIndex) + this.mRadius, this.getCenterPointAt(this.mSelectedIndex + 1) - this.mRadius);
        this.controlPointY = this.mRadius;
        this.mPath.moveTo(this.mStartX, this.mStartY);
        this.mPath.quadTo(this.controlPointX, this.controlPointY, this.endPointX, this.endPointY);
        this.mPath.lineTo(this.endPointX, this.mRadius + msupportradianY);
        this.mPath.quadTo(this.controlPointX, this.mRadius, this.mStartX, this.mStartY + 2.0f * mY);
        this.mPath.lineTo(this.mStartX, this.mStartY);
        this.mbgNextPointX = this.getValue(this.getCenterPointAt(this.mSelectedIndex + 1), this.getCenterPointAt(this.mSelectedIndex) + this.mNomarlRadius, this.MOVE_STEP_TWO);
        this.mbgNextPointY = this.mRadius;
        this.mChangeBgRadius = this.getValue(this.mNomarlRadius, 0.0f, mRadiusProgress);
        double m_Next_radian = Math.toRadians(this.getValue(45.0f, 0.0f, this.MOVE_STEP_ONE));
        float mX_next = (float)(Math.sin(m_Next_radian) * (double)this.mChangeBgRadius);
        float mY_next = (float)(Math.cos(m_Next_radian) * (double)this.mChangeBgRadius);
        this.mSupport_next_centerX = this.getValue(this.getCenterPointAt(this.mSelectedIndex + 1) - this.mNomarlRadius, this.getCenterPointAt(this.mSelectedIndex), this.MOVE_STEP_ONE);
        this.mSupport_next_centerY = this.mRadius;
        this.mSupport_Next_ChangeRadius = this.getValue(0.0f, this.mNomarlRadius, mRadiusProgress);
        double mSupport_Next_radian = Math.toRadians(this.getValue(0.0f, 45.0f, this.MOVE_STEP_TWO));
        float mSupport_Next_radianX = (float)(Math.sin(mSupport_Next_radian) * (double)this.mSupport_Next_ChangeRadius);
        float mSupport_Next_radianY = (float)(Math.cos(mSupport_Next_radian) * (double)this.mSupport_Next_ChangeRadius);
        float startPoint_support_nextX = this.mbgNextPointX - mX_next;
        float startPoint_support_nextY = this.mbgNextPointY - mY_next;
        float endPoint_support_nextX = this.mSupport_next_centerX + mSupport_Next_radianX;
        float endPoint_support_nextY = this.mSupport_next_centerY - mSupport_Next_radianY;
        float controlPointX_Next = this.getValueForAll(this.getCenterPointAt(this.mSelectedIndex + 1) - this.mNomarlRadius, this.getCenterPointAt(this.mSelectedIndex) + this.mNomarlRadius);
        float controlPointY_Next = this.mRadius;
        this.mPath2.moveTo(startPoint_support_nextX, startPoint_support_nextY);
        this.mPath2.quadTo(controlPointX_Next, controlPointY_Next, endPoint_support_nextX, endPoint_support_nextY);
        this.mPath2.lineTo(endPoint_support_nextX, this.mRadius + mSupport_Next_radianY);
        this.mPath2.quadTo(controlPointX_Next, controlPointY_Next, startPoint_support_nextX, startPoint_support_nextY + 2.0f * mY_next);
        this.mPath2.lineTo(startPoint_support_nextX, startPoint_support_nextY);
    }

    private void moveToPrivous() {
        this.mPath.reset();
        this.mPath2.reset();
        float mRadiusProgress = this.accelerateinterpolator.getInterpolation(this.mOriginProgress);
        this.mCenterPointX = this.getValue(this.getCenterPointAt(this.mSelectedIndex), this.getCenterPointAt(this.mSelectedIndex - 1) + this.mRadius, this.MOVE_STEP_TWO);
        this.mCenterPointY = this.mRadius;
        this.mChangeRadius = this.getValue(this.mRadius, 0.0f, mRadiusProgress);
        double radian = Math.toRadians(this.getValue(45.0f, 0.0f, this.MOVE_STEP_ONE));
        float mX = (float)(Math.sin(radian) * (double)this.mChangeRadius);
        float mY = (float)(Math.cos(radian) * (double)this.mChangeRadius);
        this.mSupportCircleX = this.getValue(this.getCenterPointAt(this.mSelectedIndex) - this.mRadius, this.getCenterPointAt(this.mSelectedIndex - 1), this.MOVE_STEP_ONE);
        this.mSupportCircleY = this.mRadius;
        this.mSupportChangeRadius = this.getValue(0.0f, this.mRadius, mRadiusProgress);
        double supportradian = Math.toRadians(this.getValue(0.0f, 45.0f, this.MOVE_STEP_TWO));
        float msupportradianX = (float)(Math.sin(supportradian) * (double)this.mSupportChangeRadius);
        float msupportradianY = (float)(Math.cos(supportradian) * (double)this.mSupportChangeRadius);
        this.mStartX = this.mCenterPointX - mX;
        this.mStartY = this.mCenterPointY - mY;
        this.endPointX = this.mSupportCircleX + msupportradianX;
        this.endPointY = this.mRadius - msupportradianY;
        this.controlPointX = this.getValueForAll(this.getCenterPointAt(this.mSelectedIndex) - this.mRadius, this.getCenterPointAt(this.mSelectedIndex - 1) + this.mRadius);
        this.controlPointY = this.mRadius;
        this.mPath.moveTo(this.mStartX, this.mStartY);
        this.mPath.quadTo(this.controlPointX, this.controlPointY, this.endPointX, this.endPointY);
        this.mPath.lineTo(this.endPointX, this.mRadius + msupportradianY);
        this.mPath.quadTo(this.controlPointX, this.mRadius, this.mStartX, this.mStartY + 2.0f * mY);
        this.mPath.lineTo(this.mStartX, this.mStartY);
        this.mbgNextPointX = this.getValue(this.getCenterPointAt(this.mSelectedIndex - 1), this.getCenterPointAt(this.mSelectedIndex) - this.mNomarlRadius, this.MOVE_STEP_TWO);
        this.mbgNextPointY = this.mRadius;
        this.mChangeBgRadius = this.getValue(this.mNomarlRadius, 0.0f, mRadiusProgress);
        double m_Next_radian = Math.toRadians(this.getValue(45.0f, 0.0f, this.MOVE_STEP_ONE));
        float mX_next = (float)(Math.sin(m_Next_radian) * (double)this.mChangeBgRadius);
        float mY_next = (float)(Math.cos(m_Next_radian) * (double)this.mChangeBgRadius);
        this.mSupport_next_centerX = this.getValue(this.getCenterPointAt(this.mSelectedIndex - 1) + this.mNomarlRadius, this.getCenterPointAt(this.mSelectedIndex), this.MOVE_STEP_ONE);
        this.mSupport_next_centerY = this.mRadius;
        this.mSupport_Next_ChangeRadius = this.getValue(0.0f, this.mNomarlRadius, mRadiusProgress);
        double mSupport_Next_radian = Math.toRadians(this.getValue(0.0f, 45.0f, this.MOVE_STEP_TWO));
        float mSupport_Next_radianX = (float)(Math.sin(mSupport_Next_radian) * (double)this.mSupport_Next_ChangeRadius);
        float mSupport_Next_radianY = (float)(Math.cos(mSupport_Next_radian) * (double)this.mSupport_Next_ChangeRadius);
        float startPoint_support_nextX = this.mbgNextPointX + mX_next;
        float startPoint_support_nextY = this.mbgNextPointY - mY_next;
        float endPoint_support_nextX = this.mSupport_next_centerX - mSupport_Next_radianX;
        float endPoint_support_nextY = this.mSupport_next_centerY - mSupport_Next_radianY;
        float controlPointX_Next = this.getValueForAll(this.getCenterPointAt(this.mSelectedIndex - 1) + this.mNomarlRadius, this.getCenterPointAt(this.mSelectedIndex) - this.mNomarlRadius);
        float controlPointY_Next = this.mRadius;
        this.mPath2.moveTo(startPoint_support_nextX, startPoint_support_nextY);
        this.mPath2.quadTo(controlPointX_Next, controlPointY_Next, endPoint_support_nextX, endPoint_support_nextY);
        this.mPath2.lineTo(endPoint_support_nextX, this.mRadius + mSupport_Next_radianY);
        this.mPath2.quadTo(controlPointX_Next, controlPointY_Next, startPoint_support_nextX, startPoint_support_nextY + 2.0f * mY_next);
        this.mPath2.lineTo(startPoint_support_nextX, startPoint_support_nextY);
    }

    public float getValue(float start, float end, int step) {
        if (step == this.MOVE_STEP_ONE) {
            return start + (end - start) * this.mProgress;
        }
        return start + (end - start) * this.mProgress2;
    }

    public float getValueForAll(float start, float end) {
        return start + (end - start) * this.mOriginProgress;
    }

    public float getValue(float start, float end, float progress) {
        return start + (end - start) * progress;
    }

    private float getCenterPointAt(int index) {
        if (index == 0) {
            return this.mRadius;
        }
        return (float)index * (this.distance + 2.0f * this.mNomarlRadius) + this.mNomarlRadius + (this.mRadius - this.mNomarlRadius);
    }

    public void setDirection(int direction) {
        this.mDrection = direction;
    }

    public void resetProgress() {
        this.mProgress = 0.0f;
        this.mProgress2 = 0.0f;
        this.mOriginProgress = 0.0f;
    }

    public void attachToViewpager(ViewPager viewPager) {
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        if (viewPager.getAdapter() != null) {
            this.count = viewPager.getAdapter().getCount();
        }
        this.mSelectedIndex = viewPager.getCurrentItem();
        this.moveToNext();
        this.mDrection = DIRECTION_RIGHT;
        this.invalidate();
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (positionOffset == 0.0f) {
            this.mSelectedIndex = position;
            Log.d((String)TAG, (String)"\u5230\u8fbe");
            this.resetProgress();
        }
        if ((float)position + positionOffset - (float)this.mSelectedIndex > 0.0f) {
            this.mDrection = DIRECTION_RIGHT;
            if ((float)position + positionOffset > (float)(this.mSelectedIndex + 1)) {
                this.mSelectedIndex = position;
                Log.d((String)TAG, (String)"\u5411\u5de6\u5feb\u901f\u6ed1\u52a8");
            } else {
                this.setProgress(positionOffset);
            }
        } else if ((float)position + positionOffset - (float)this.mSelectedIndex < 0.0f) {
            this.mDrection = DIRECTION_LEFT;
            if ((float)position + positionOffset < (float)(this.mSelectedIndex - 1)) {
                this.mSelectedIndex = position;
                Log.d((String)TAG, (String)"\u5411\u53f3\u5feb\u901f\u6ed1\u52a8");
            } else {
                this.setProgress(1.0f - positionOffset);
            }
        }
    }

    public void onPageSelected(int position) {
    }

    public void onPageScrollStateChanged(int state) {
    }
}

