/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.preview.ui;

import android.content.Context;
import android.content.Intent;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Toast;
import android.widget.VideoView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import com.xuexiang.xui.R;

public class VideoPlayerActivity
extends AppCompatActivity {
    public static final String KEY_URL = "com.xuexiang.xui.widget.preview.KEY_URL";
    private VideoView mVideoView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.preview_activity_video_player);
        this.mVideoView = (VideoView)this.findViewById(R.id.video);
        String videoPath = this.getIntent().getStringExtra(KEY_URL);
        if (TextUtils.isEmpty((CharSequence)videoPath)) {
            Toast.makeText((Context)this, (int)R.string.xui_preview_video_path_error, (int)0).show();
            this.finish();
            return;
        }
        this.mVideoView.setVideoPath(videoPath);
        this.mVideoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                Toast.makeText((Context)VideoPlayerActivity.this, (int)R.string.xui_preview_play_failed, (int)0).show();
                return false;
            }
        });
        this.mVideoView.start();
        this.findViewById(R.id.rl_root).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoPlayerActivity.this.finish();
                VideoPlayerActivity.this.recycle();
            }
        });
    }

    private void recycle() {
        if (this.mVideoView != null) {
            this.mVideoView.stopPlayback();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mVideoView != null && !this.mVideoView.isPlaying()) {
            this.mVideoView.start();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mVideoView != null) {
            this.mVideoView.pause();
        }
    }

    protected void onStop() {
        if (this.isFinishing()) {
            this.recycle();
        }
        super.onStop();
    }

    public static void start(Fragment fragment, String url) {
        Intent intent = new Intent(fragment.getContext(), VideoPlayerActivity.class);
        intent.putExtra(KEY_URL, url);
        fragment.startActivity(intent);
    }
}

