/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.preview.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.Fragment;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.imageview.photoview.PhotoViewAttacher;
import com.xuexiang.xui.widget.imageview.preview.MediaLoader;
import com.xuexiang.xui.widget.imageview.preview.enitity.IPreviewInfo;
import com.xuexiang.xui.widget.imageview.preview.loader.ISimpleTarget;
import com.xuexiang.xui.widget.imageview.preview.loader.OnVideoClickListener;
import com.xuexiang.xui.widget.imageview.preview.ui.PreviewActivity;
import com.xuexiang.xui.widget.imageview.preview.ui.VideoPlayerActivity;
import com.xuexiang.xui.widget.imageview.preview.view.SmoothImageView;
import com.xuexiang.xui.widget.progress.materialprogressbar.MaterialProgressBar;

public class BasePhotoFragment
extends Fragment {
    private static final String GIF = ".gif";
    public static final String KEY_TRANS_PHOTO = "com.xuexiang.xui.widget.preview.KEY_TRANS_PHOTO";
    public static final String KEY_SING_FILING = "com.xuexiang.xui.widget.preview.KEY_SING_FILING";
    public static final String KEY_PREVIEW_ITEM = "com.xuexiang.xui.widget.preview.KEY_PREVIEW_ITEM";
    public static final String KEY_DRAG = "com.xuexiang.xui.widget.preview.KEY_DRAG";
    public static final String KEY_SENSITIVITY = "com.xuexiang.xui.widget.preview.KEY_SENSITIVITY";
    public static final String KEY_PROGRESS_COLOR = "com.xuexiang.xui.widget.preview.KEY_PROGRESS_COLOR";
    private IPreviewInfo mPreviewInfo;
    private boolean isTransPhoto = false;
    protected SmoothImageView mImageView;
    protected View mRootView;
    protected MaterialProgressBar mLoadingView;
    protected ISimpleTarget mISimpleTarget;
    protected ImageView mBtnVideo;
    public static OnVideoClickListener listener;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.preview_fragment_image_photo, container, false);
    }

    public static BasePhotoFragment newInstance(Class<? extends BasePhotoFragment> fragmentClass, IPreviewInfo item, boolean currentIndex, boolean isSingleFling, boolean isDrag, float sensitivity, int progressColorId) {
        BasePhotoFragment fragment;
        try {
            fragment = fragmentClass.newInstance();
        }
        catch (Exception e) {
            fragment = new BasePhotoFragment();
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_PREVIEW_ITEM, (Parcelable)item);
        bundle.putBoolean(KEY_TRANS_PHOTO, currentIndex);
        bundle.putBoolean(KEY_SING_FILING, isSingleFling);
        bundle.putBoolean(KEY_DRAG, isDrag);
        bundle.putFloat(KEY_SENSITIVITY, sensitivity);
        bundle.putInt(KEY_PROGRESS_COLOR, progressColorId);
        fragment.setArguments(bundle);
        return fragment;
    }

    @CallSuper
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
        this.initArgs();
    }

    @CallSuper
    public void onStop() {
        MediaLoader.get().onStop(this);
        super.onStop();
    }

    @CallSuper
    public void onDestroyView() {
        this.release();
        super.onDestroyView();
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
    }

    public void onDestroy() {
        super.onDestroy();
        MediaLoader.get().clearMemory((Context)this.getActivity());
        if (this.getActivity() != null && this.getActivity().isFinishing()) {
            listener = null;
        }
    }

    public void release() {
        this.mISimpleTarget = null;
        if (this.mImageView != null) {
            this.mImageView.setImageBitmap(null);
            this.mImageView.setOnViewTapListener(null);
            this.mImageView.setOnPhotoTapListener(null);
            this.mImageView.setAlphaChangeListener(null);
            this.mImageView.setTransformOutListener(null);
            this.mImageView.transformIn(null);
            this.mImageView.transformOut(null);
            this.mImageView.setOnLongClickListener(null);
            this.mBtnVideo.setOnClickListener(null);
            this.mImageView = null;
            this.mRootView = null;
            this.isTransPhoto = false;
        }
    }

    private void initView(View view) {
        this.mLoadingView = (MaterialProgressBar)view.findViewById(R.id.loading);
        this.mImageView = (SmoothImageView)view.findViewById(R.id.photoView);
        this.mBtnVideo = (ImageView)view.findViewById(R.id.btnVideo);
        this.mRootView = view.findViewById(R.id.rootView);
        this.mRootView.setDrawingCacheEnabled(false);
        this.mImageView.setDrawingCacheEnabled(false);
        this.mBtnVideo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String video = BasePhotoFragment.this.mPreviewInfo.getVideoUrl();
                if (video != null && !video.isEmpty()) {
                    if (listener != null) {
                        listener.onPlayerVideo(video);
                    } else {
                        VideoPlayerActivity.start(BasePhotoFragment.this, video);
                    }
                }
            }
        });
        this.mISimpleTarget = new ISimpleTarget(){

            @Override
            public void onResourceReady() {
                BasePhotoFragment.this.mLoadingView.setVisibility(8);
                String video = BasePhotoFragment.this.mPreviewInfo.getVideoUrl();
                if (video != null && !video.isEmpty()) {
                    BasePhotoFragment.this.mBtnVideo.setVisibility(0);
                    ViewCompat.animate((View)BasePhotoFragment.this.mBtnVideo).alpha(1.0f).setDuration(1000L).start();
                } else {
                    BasePhotoFragment.this.mBtnVideo.setVisibility(8);
                }
            }

            @Override
            public void onLoadFailed(Drawable errorDrawable) {
                BasePhotoFragment.this.mLoadingView.setVisibility(8);
                BasePhotoFragment.this.mBtnVideo.setVisibility(8);
                if (errorDrawable != null) {
                    BasePhotoFragment.this.mImageView.setImageDrawable(errorDrawable);
                }
            }
        };
    }

    private void initArgs() {
        Bundle bundle = this.getArguments();
        boolean isSingleFling = true;
        if (bundle != null) {
            int colorId = bundle.getInt(KEY_PROGRESS_COLOR, R.color.xui_config_color_main_theme);
            this.mLoadingView.setSupportIndeterminateTintList(ResUtils.getColors(this.getContext(), colorId));
            isSingleFling = bundle.getBoolean(KEY_SING_FILING);
            this.mPreviewInfo = (IPreviewInfo)bundle.getParcelable(KEY_PREVIEW_ITEM);
            assert (this.mPreviewInfo != null);
            this.mImageView.setDrag(bundle.getBoolean(KEY_DRAG), bundle.getFloat(KEY_SENSITIVITY));
            this.mImageView.setThumbRect(this.mPreviewInfo.getBounds());
            this.mRootView.setTag((Object)this.mPreviewInfo.getUrl());
            this.isTransPhoto = bundle.getBoolean(KEY_TRANS_PHOTO, false);
            if (this.mPreviewInfo.getUrl().toLowerCase().contains(GIF)) {
                this.mImageView.setZoomable(false);
                MediaLoader.get().displayGifImage(this, this.mPreviewInfo.getUrl(), (ImageView)this.mImageView, this.mISimpleTarget);
            } else {
                MediaLoader.get().displayImage(this, this.mPreviewInfo.getUrl(), (ImageView)this.mImageView, this.mISimpleTarget);
            }
        }
        if (!this.isTransPhoto) {
            this.mRootView.setBackgroundColor(-16777216);
        } else {
            this.mImageView.setMinimumScale(0.7f);
        }
        if (isSingleFling) {
            this.mImageView.setOnViewTapListener(new PhotoViewAttacher.OnViewTapListener(){

                @Override
                public void onViewTap(View view, float x, float y) {
                    if (BasePhotoFragment.this.mImageView.checkMinScale()) {
                        BasePhotoFragment.this.transformOut();
                    }
                }
            });
        } else {
            this.mImageView.setOnPhotoTapListener(new PhotoViewAttacher.OnPhotoTapListener(){

                @Override
                public void onPhotoTap(View view, float x, float y) {
                    if (BasePhotoFragment.this.mImageView.checkMinScale()) {
                        BasePhotoFragment.this.transformOut();
                    }
                }

                @Override
                public void onOutsidePhotoTap() {
                }
            });
        }
        this.mImageView.setAlphaChangeListener(new SmoothImageView.OnAlphaChangeListener(){

            @Override
            public void onAlphaChange(int alpha) {
                if (alpha == 255) {
                    String video = BasePhotoFragment.this.mPreviewInfo.getVideoUrl();
                    if (video != null && !video.isEmpty()) {
                        BasePhotoFragment.this.mBtnVideo.setVisibility(0);
                    } else {
                        BasePhotoFragment.this.mBtnVideo.setVisibility(8);
                    }
                } else {
                    BasePhotoFragment.this.mBtnVideo.setVisibility(8);
                }
                BasePhotoFragment.this.mRootView.setBackgroundColor(BasePhotoFragment.getColorWithAlpha((float)alpha / 255.0f, -16777216));
            }
        });
        this.mImageView.setTransformOutListener(new SmoothImageView.OnTransformOutListener(){

            @Override
            public void onTransformOut() {
                BasePhotoFragment.this.transformOut();
            }
        });
    }

    private void transformOut() {
        PreviewActivity activity = (PreviewActivity)this.getActivity();
        if (activity != null) {
            activity.transformOut();
        }
    }

    public static int getColorWithAlpha(float alpha, int baseColor) {
        int a = Math.min(255, Math.max(0, (int)(alpha * 255.0f))) << 24;
        int rgb = 0xFFFFFF & baseColor;
        return a + rgb;
    }

    public void transformIn() {
        this.mImageView.transformIn(new SmoothImageView.onTransformListener(){

            @Override
            public void onTransformCompleted(SmoothImageView.Status status) {
                BasePhotoFragment.this.mRootView.setBackgroundColor(-16777216);
            }
        });
    }

    public void transformOut(SmoothImageView.onTransformListener listener) {
        this.mImageView.transformOut(listener);
    }

    public void resetMatrix() {
        if (this.mImageView != null) {
            this.mImageView.resetMatrix();
        }
    }

    public void changeBg(int color2) {
        ViewCompat.animate((View)this.mBtnVideo).alpha(0.0f).setDuration(500L).start();
        this.mRootView.setBackgroundColor(color2);
    }

    public IPreviewInfo getPreviewInfo() {
        return this.mPreviewInfo;
    }
}

