/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.preview.loader;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.imageview.preview.loader.IMediaLoader;
import com.xuexiang.xui.widget.imageview.preview.loader.ISimpleTarget;

public class GlideMediaLoader
implements IMediaLoader {
    private RequestOptions mRequestOptions;

    public GlideMediaLoader() {
        this((RequestOptions)((RequestOptions)new RequestOptions().error(R.drawable.xui_ic_no_img)).diskCacheStrategy(DiskCacheStrategy.ALL));
    }

    public GlideMediaLoader(RequestOptions requestOptions) {
        this.mRequestOptions = requestOptions;
    }

    @Override
    public void displayImage(@NonNull Fragment context, @NonNull String path, ImageView imageView, final @NonNull ISimpleTarget simpleTarget) {
        Glide.with((Fragment)context).asBitmap().apply((BaseRequestOptions)this.mRequestOptions).load(path).listener((RequestListener)new RequestListener<Bitmap>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                simpleTarget.onLoadFailed(null);
                return false;
            }

            public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource) {
                simpleTarget.onResourceReady();
                return false;
            }
        }).into(imageView);
    }

    @Override
    public void displayGifImage(@NonNull Fragment context, @NonNull String path, ImageView imageView, final @NonNull ISimpleTarget simpleTarget) {
        Glide.with((Fragment)context).asGif().apply((BaseRequestOptions)this.mRequestOptions).load(path).listener((RequestListener)new RequestListener<GifDrawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                simpleTarget.onLoadFailed(null);
                return false;
            }

            public boolean onResourceReady(GifDrawable resource, Object model, Target<GifDrawable> target, DataSource dataSource, boolean isFirstResource) {
                simpleTarget.onResourceReady();
                return false;
            }
        }).into(imageView);
    }

    @Override
    public void onStop(@NonNull Fragment context) {
        Glide.with((Fragment)context).onStop();
    }

    @Override
    public void clearMemory(@NonNull Context context) {
        Glide.get((Context)context).clearMemory();
    }

    public static RequestOptions getRequestOptions() {
        return (RequestOptions)((RequestOptions)new RequestOptions().placeholder(R.drawable.xui_ic_default_img)).diskCacheStrategy(DiskCacheStrategy.ALL);
    }
}

