/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.photoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import com.xuexiang.xui.widget.imageview.photoview.IPhotoView;
import com.xuexiang.xui.widget.imageview.photoview.PhotoViewAttacher;

public class PhotoView
extends AppCompatImageView
implements IPhotoView {
    private PhotoViewAttacher mAttacher;
    private ImageView.ScaleType mPendingScaleType;

    public PhotoView(Context context) {
        this(context, null);
    }

    public PhotoView(Context context, AttributeSet attr2) {
        this(context, attr2, 0);
    }

    public PhotoView(Context context, AttributeSet attr2, int defStyle) {
        super(context, attr2, defStyle);
        super.setScaleType(ImageView.ScaleType.MATRIX);
        this.init();
    }

    protected void init() {
        if (this.mAttacher == null || this.mAttacher.getImageView() == null) {
            this.mAttacher = new PhotoViewAttacher((ImageView)this);
        }
        if (this.mPendingScaleType != null) {
            this.setScaleType(this.mPendingScaleType);
            this.mPendingScaleType = null;
        }
    }

    @Override
    public void setRotationTo(float rotationDegree) {
        if (this.mAttacher != null) {
            this.mAttacher.setRotationTo(rotationDegree);
        }
    }

    @Override
    public void setRotationBy(float rotationDegree) {
        if (this.mAttacher != null) {
            this.mAttacher.setRotationBy(rotationDegree);
        }
    }

    @Override
    public boolean canZoom() {
        return this.mAttacher != null && this.mAttacher.canZoom();
    }

    @Override
    public RectF getDisplayRect() {
        return this.mAttacher != null ? this.mAttacher.getDisplayRect() : null;
    }

    @Override
    public void getDisplayMatrix(Matrix matrix) {
        if (this.mAttacher != null) {
            this.mAttacher.getDisplayMatrix(matrix);
        }
    }

    @Override
    public boolean setDisplayMatrix(Matrix finalRectangle) {
        return this.mAttacher != null && this.mAttacher.setDisplayMatrix(finalRectangle);
    }

    @Override
    public float getMinimumScale() {
        return this.mAttacher != null ? this.mAttacher.getMinimumScale() : 1.0f;
    }

    @Override
    public float getMediumScale() {
        return this.mAttacher != null ? this.mAttacher.getMediumScale() : 1.75f;
    }

    @Override
    public float getMaximumScale() {
        return this.mAttacher != null ? this.mAttacher.getMaximumScale() : 3.0f;
    }

    @Override
    public float getScale() {
        return this.mAttacher != null ? this.mAttacher.getScale() : 1.0f;
    }

    @Override
    public ImageView.ScaleType getScaleType() {
        return this.mAttacher != null ? this.mAttacher.getScaleType() : null;
    }

    public Matrix getImageMatrix() {
        return this.mAttacher != null ? this.mAttacher.getImageMatrix() : null;
    }

    @Override
    public void setAllowParentInterceptOnEdge(boolean allow) {
        if (this.mAttacher != null) {
            this.mAttacher.setAllowParentInterceptOnEdge(allow);
        }
    }

    @Override
    public void setMinimumScale(float minimumScale) {
        if (this.mAttacher != null) {
            this.mAttacher.setMinimumScale(minimumScale);
        }
    }

    @Override
    public void setMediumScale(float mediumScale) {
        if (this.mAttacher != null) {
            this.mAttacher.setMediumScale(mediumScale);
        }
    }

    @Override
    public void setMaximumScale(float maximumScale) {
        if (this.mAttacher != null) {
            this.mAttacher.setMaximumScale(maximumScale);
        }
    }

    @Override
    public void setScaleLevels(float minimumScale, float mediumScale, float maximumScale) {
        if (this.mAttacher != null) {
            this.mAttacher.setScaleLevels(minimumScale, mediumScale, maximumScale);
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        if (this.mAttacher != null) {
            this.mAttacher.update();
        }
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        if (this.mAttacher != null) {
            this.mAttacher.update();
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        if (this.mAttacher != null) {
            this.mAttacher.update();
        }
    }

    protected boolean setFrame(int l, int t, int r, int b) {
        boolean changed = super.setFrame(l, t, r, b);
        if (this.mAttacher != null) {
            this.mAttacher.update();
        }
        return changed;
    }

    @Override
    public void setOnMatrixChangeListener(PhotoViewAttacher.OnMatrixChangedListener listener) {
        if (this.mAttacher != null) {
            this.mAttacher.setOnMatrixChangeListener(listener);
        }
    }

    @Override
    public void setOnLongClickListener(View.OnLongClickListener l) {
        if (this.mAttacher != null) {
            this.mAttacher.setOnLongClickListener(l);
        }
    }

    @Override
    public void setOnPhotoTapListener(PhotoViewAttacher.OnPhotoTapListener listener) {
        if (this.mAttacher != null) {
            this.mAttacher.setOnPhotoTapListener(listener);
        }
    }

    @Override
    public void setOnViewTapListener(PhotoViewAttacher.OnViewTapListener listener) {
        if (this.mAttacher != null) {
            this.mAttacher.setOnViewTapListener(listener);
        }
    }

    @Override
    public void setScale(float scale) {
        if (this.mAttacher != null) {
            this.mAttacher.setScale(scale);
        }
    }

    @Override
    public void setScale(float scale, boolean animate) {
        if (this.mAttacher != null) {
            this.mAttacher.setScale(scale, animate);
        }
    }

    @Override
    public void setScale(float scale, float focalX, float focalY, boolean animate) {
        if (this.mAttacher != null) {
            this.mAttacher.setScale(scale, focalX, focalY, animate);
        }
    }

    @Override
    public void setScaleType(ImageView.ScaleType scaleType) {
        if (this.mAttacher != null) {
            this.mAttacher.setScaleType(scaleType);
        } else {
            this.mPendingScaleType = scaleType;
        }
    }

    @Override
    public void setZoomable(boolean zoomable) {
        if (this.mAttacher != null) {
            this.mAttacher.setZoomable(zoomable);
        }
    }

    @Override
    public Bitmap getVisibleRectangleBitmap() {
        return this.mAttacher != null ? this.mAttacher.getVisibleRectangleBitmap() : null;
    }

    @Override
    public void setZoomTransitionDuration(int milliseconds) {
        if (this.mAttacher != null) {
            this.mAttacher.setZoomTransitionDuration(milliseconds);
        }
    }

    @Override
    public IPhotoView getIPhotoViewImplementation() {
        return this.mAttacher;
    }

    @Override
    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener newOnDoubleTapListener) {
        if (this.mAttacher != null) {
            this.mAttacher.setOnDoubleTapListener(newOnDoubleTapListener);
        }
    }

    @Override
    public void setOnScaleChangeListener(PhotoViewAttacher.OnScaleChangeListener onScaleChangeListener) {
        if (this.mAttacher != null) {
            this.mAttacher.setOnScaleChangeListener(onScaleChangeListener);
        }
    }

    @Override
    public void setOnSingleFlingListener(PhotoViewAttacher.OnSingleFlingListener onSingleFlingListener) {
        if (this.mAttacher != null) {
            this.mAttacher.setOnSingleFlingListener(onSingleFlingListener);
        }
    }

    protected void onDetachedFromWindow() {
        this.resetMatrix();
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        this.init();
        super.onAttachedToWindow();
    }

    public void resetMatrix() {
        if (this.mAttacher != null) {
            this.mAttacher.cleanup();
            this.mAttacher.resetMatrix();
        }
    }
}

