/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.nine;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.imageview.nine.ItemImageClickListener;
import com.xuexiang.xui.widget.imageview.nine.ItemImageLongClickListener;
import com.xuexiang.xui.widget.imageview.nine.NineGridImageViewAdapter;
import java.util.ArrayList;
import java.util.List;

public class NineGridImageView<T>
extends ViewGroup {
    public static final int STYLE_GRID = 0;
    public static final int STYLE_FILL = 1;
    public static final int NOSPAN = 0;
    public static final int TOPCOLSPAN = 2;
    public static final int BOTTOMCOLSPAN = 3;
    public static final int LEFTROWSPAN = 4;
    private int mRowCount;
    private int mColumnCount;
    private int mMaxSize;
    private int mShowStyle;
    private int mGap;
    private int mSingleImgSize;
    private int mGridSize;
    private int mSpanType;
    private List<ImageView> mImageViewList = new ArrayList<ImageView>();
    private List<T> mImgDataList;
    private NineGridImageViewAdapter<T> mAdapter;
    private ItemImageClickListener<T> mItemImageClickListener;
    private ItemImageLongClickListener<T> mItemImageLongClickListener;

    public NineGridImageView(Context context) {
        this(context, null);
    }

    public NineGridImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.NineGridImageView);
        this.mGap = (int)typedArray.getDimension(R.styleable.NineGridImageView_ngiv_imgGap, 0.0f);
        this.mSingleImgSize = typedArray.getDimensionPixelSize(R.styleable.NineGridImageView_ngiv_singleImgSize, -1);
        this.mShowStyle = typedArray.getInt(R.styleable.NineGridImageView_ngiv_showStyle, 0);
        this.mMaxSize = typedArray.getInt(R.styleable.NineGridImageView_ngiv_maxSize, 9);
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int totalWidth = width - this.getPaddingLeft() - this.getPaddingRight();
        if (this.mImgDataList != null && this.mImgDataList.size() > 0) {
            if (this.mImgDataList.size() == 1 && this.mSingleImgSize != -1) {
                this.mGridSize = Math.min(this.mSingleImgSize, totalWidth);
            } else {
                this.mImageViewList.get(0).setScaleType(ImageView.ScaleType.CENTER_CROP);
                this.mGridSize = (totalWidth - this.mGap * (this.mColumnCount - 1)) / this.mColumnCount;
            }
            height = this.mGridSize * this.mRowCount + this.mGap * (this.mRowCount - 1) + this.getPaddingTop() + this.getPaddingBottom();
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.layoutChildrenView();
    }

    private void layoutChildrenView() {
        if (this.mImgDataList == null) {
            return;
        }
        int showChildrenCount = this.getNeedShowCount(this.mImgDataList.size());
        if (this.mSpanType == 0 || showChildrenCount <= 2) {
            this.layoutForNoSpanChildrenView(showChildrenCount);
            return;
        }
        switch (showChildrenCount) {
            case 3: {
                this.layoutForThreeChildrenView(showChildrenCount);
                break;
            }
            case 4: {
                this.layoutForFourChildrenView(showChildrenCount);
                break;
            }
            case 5: {
                this.layoutForFiveChildrenView(showChildrenCount);
                break;
            }
            case 6: {
                this.layoutForSixChildrenView(showChildrenCount);
                break;
            }
            default: {
                this.layoutForNoSpanChildrenView(showChildrenCount);
            }
        }
    }

    private void layoutForNoSpanChildrenView(int childrenCount) {
        if (childrenCount <= 0) {
            return;
        }
        for (int i = 0; i < childrenCount; ++i) {
            ImageView childrenView = (ImageView)this.getChildAt(i);
            int row = i / this.mColumnCount;
            int column = i % this.mColumnCount;
            int left = (this.mGridSize + this.mGap) * column + this.getPaddingLeft();
            int top = (this.mGridSize + this.mGap) * row + this.getPaddingTop();
            int right = left + this.mGridSize;
            int bottom = top + this.mGridSize;
            childrenView.layout(left, top, right, bottom);
            if (this.mAdapter == null) continue;
            this.mAdapter.onDisplayImage(this.getContext(), childrenView, this.mImgDataList.get(i));
        }
    }

    private void layoutForThreeChildrenView(int childrenCount) {
        for (int i = 0; i < childrenCount; ++i) {
            ImageView childrenView = (ImageView)this.getChildAt(i);
            switch (this.mSpanType) {
                case 2: {
                    int bottom;
                    int right;
                    int top;
                    int left;
                    if (i == 0) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop();
                        right = left + this.mGridSize * 2 + this.mGap;
                        bottom = top + this.mGridSize;
                    } else if (i == 1) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop() + this.mGridSize + this.mGap;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else {
                        left = this.getPaddingLeft() + this.mGridSize + this.mGap;
                        top = this.getPaddingTop() + this.mGridSize + this.mGap;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    }
                    childrenView.layout(left, top, right, bottom);
                    break;
                }
                case 3: {
                    int bottom;
                    int right;
                    int top;
                    int left;
                    if (i == 0) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 1) {
                        left = this.getPaddingLeft() + this.mGridSize + this.mGap;
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop() + this.mGridSize + this.mGap;
                        right = left + this.mGridSize * 2 + this.mGap;
                        bottom = top + this.mGridSize;
                    }
                    childrenView.layout(left, top, right, bottom);
                    break;
                }
                case 4: {
                    int bottom;
                    int right;
                    int top;
                    int left;
                    if (i == 0) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize * 2 + this.mGap;
                    } else if (i == 1) {
                        left = this.getPaddingLeft() + this.mGridSize + this.mGap;
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else {
                        left = this.getPaddingLeft() + this.mGridSize + this.mGap;
                        top = this.getPaddingTop() + this.mGridSize + this.mGap;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    }
                    childrenView.layout(left, top, right, bottom);
                    break;
                }
            }
            if (this.mAdapter == null) continue;
            this.mAdapter.onDisplayImage(this.getContext(), childrenView, this.mImgDataList.get(i));
        }
    }

    private void layoutForFourChildrenView(int childrenCount) {
        for (int i = 0; i < childrenCount; ++i) {
            ImageView childrenView = (ImageView)this.getChildAt(i);
            switch (this.mSpanType) {
                case 2: {
                    int bottom;
                    int right;
                    int top;
                    int left;
                    if (i == 0) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop();
                        right = left + this.mGridSize * 3 + this.mGap * 2;
                        bottom = top + this.mGridSize * 2 + this.mGap;
                    } else if (i == 1) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 2) {
                        left = this.getPaddingLeft() + this.mGridSize + this.mGap;
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    }
                    childrenView.layout(left, top, right, bottom);
                    break;
                }
                case 3: {
                    int bottom;
                    int right;
                    int top;
                    int left;
                    if (i == 0) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 1) {
                        left = this.getPaddingLeft() + this.mGridSize + this.mGap;
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 2) {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop() + this.mGridSize + this.mGap;
                        right = left + this.mGridSize * 3 + this.mGap * 2;
                        bottom = top + this.mGridSize * 2 + this.mGap;
                    }
                    childrenView.layout(left, top, right, bottom);
                    break;
                }
                case 4: {
                    int bottom;
                    int right;
                    int top;
                    int left;
                    if (i == 0) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop();
                        right = left + this.mGridSize * 2 + this.mGap;
                        bottom = top + this.mGridSize * 3 + this.mGap * 2;
                    } else if (i == 1) {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 2) {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop() + this.mGridSize + this.mGap;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    }
                    childrenView.layout(left, top, right, bottom);
                    break;
                }
            }
            if (this.mAdapter == null) continue;
            this.mAdapter.onDisplayImage(this.getContext(), childrenView, this.mImgDataList.get(i));
        }
    }

    private void layoutForFiveChildrenView(int childrenCount) {
        for (int i = 0; i < childrenCount; ++i) {
            ImageView childrenView = (ImageView)this.getChildAt(i);
            switch (this.mSpanType) {
                case 2: {
                    int bottom;
                    int right;
                    int top;
                    int left;
                    if (i == 0) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop();
                        right = left + (this.mGridSize * 3 + this.mGap) / 2;
                        bottom = top + this.mGridSize * 2 + this.mGap;
                    } else if (i == 1) {
                        left = this.getPaddingLeft() + (this.mGridSize * 3 + this.mGap) / 2 + this.mGap;
                        top = this.getPaddingTop();
                        right = left + (this.mGridSize * 3 + this.mGap) / 2;
                        bottom = top + this.mGridSize * 2 + this.mGap;
                    } else if (i == 2) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 3) {
                        left = this.getPaddingLeft() + this.mGridSize + this.mGap;
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    }
                    childrenView.layout(left, top, right, bottom);
                    break;
                }
                case 3: {
                    int bottom;
                    int right;
                    int top;
                    int left;
                    if (i == 0) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 1) {
                        left = this.getPaddingLeft() + this.mGridSize + this.mGap;
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 2) {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 3) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop() + this.mGridSize + this.mGap;
                        right = left + (this.mGridSize * 3 + this.mGap) / 2;
                        bottom = top + this.mGridSize * 2 + this.mGap;
                    } else {
                        left = this.getPaddingLeft() + (this.mGridSize * 3 + this.mGap) / 2 + this.mGap;
                        top = this.getPaddingTop() + this.mGridSize + this.mGap;
                        right = left + (this.mGridSize * 3 + this.mGap) / 2;
                        bottom = top + this.mGridSize * 2 + this.mGap;
                    }
                    childrenView.layout(left, top, right, bottom);
                    break;
                }
                case 4: {
                    int bottom;
                    int right;
                    int top;
                    int left;
                    if (i == 0) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop();
                        right = left + this.mGridSize * 2 + this.mGap;
                        bottom = top + (this.mGridSize * 3 + this.mGap) / 2;
                    } else if (i == 1) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop() + (this.mGridSize * 3 + this.mGap) / 2 + this.mGap;
                        right = left + this.mGridSize * 2 + this.mGap;
                        bottom = top + (this.mGridSize * 3 + this.mGap) / 2;
                    } else if (i == 2) {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 3) {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop() + this.mGridSize + this.mGap;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    }
                    childrenView.layout(left, top, right, bottom);
                    break;
                }
            }
            if (this.mAdapter == null) continue;
            this.mAdapter.onDisplayImage(this.getContext(), childrenView, this.mImgDataList.get(i));
        }
    }

    private void layoutForSixChildrenView(int childrenCount) {
        for (int i = 0; i < childrenCount; ++i) {
            ImageView childrenView = (ImageView)this.getChildAt(i);
            switch (this.mSpanType) {
                case 2: {
                    int bottom;
                    int right;
                    int top;
                    int left;
                    if (i == 0) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop();
                        right = left + this.mGridSize * 2 + this.mGap;
                        bottom = top + this.mGridSize * 2 + this.mGap;
                    } else if (i == 1) {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 2) {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop() + this.mGridSize + this.mGap;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 3) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 4) {
                        left = this.getPaddingLeft() + this.mGridSize + this.mGap;
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    }
                    childrenView.layout(left, top, right, bottom);
                    break;
                }
                case 3: {
                    int bottom;
                    int right;
                    int top;
                    int left;
                    if (i == 0) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 1) {
                        left = this.getPaddingLeft() + this.mGridSize + this.mGap;
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 2) {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 3) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop() + this.mGridSize + this.mGap;
                        right = left + this.mGridSize * 2 + this.mGap;
                        bottom = top + this.mGridSize * 2 + this.mGap;
                    } else if (i == 4) {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop() + this.mGridSize + this.mGap;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    }
                    childrenView.layout(left, top, right, bottom);
                    break;
                }
                case 4: {
                    int bottom;
                    int right;
                    int top;
                    int left;
                    if (i == 0) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop();
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 1) {
                        left = this.getPaddingLeft() + this.mGridSize + this.mGap;
                        top = this.getPaddingTop();
                        right = left + this.mGridSize * 2 + this.mGap;
                        bottom = top + this.mGridSize * 2 + this.mGap;
                    } else if (i == 2) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop() + this.mGridSize + this.mGap;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 3) {
                        left = this.getPaddingLeft();
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else if (i == 4) {
                        left = this.getPaddingLeft() + this.mGridSize + this.mGap;
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    } else {
                        left = this.getPaddingLeft() + this.mGridSize * 2 + this.mGap * 2;
                        top = this.getPaddingTop() + this.mGridSize * 2 + this.mGap * 2;
                        right = left + this.mGridSize;
                        bottom = top + this.mGridSize;
                    }
                    childrenView.layout(left, top, right, bottom);
                    break;
                }
            }
            if (this.mAdapter == null) continue;
            this.mAdapter.onDisplayImage(this.getContext(), childrenView, this.mImgDataList.get(i));
        }
    }

    private void generateUnitRowAndColumnForSpanType(int imagesSize, int[] gridParam) {
        if (imagesSize <= 2) {
            gridParam[0] = 1;
            gridParam[1] = imagesSize;
        } else if (imagesSize == 3) {
            switch (this.mSpanType) {
                case 2: 
                case 3: 
                case 4: {
                    gridParam[0] = 2;
                    gridParam[1] = 2;
                    break;
                }
                default: {
                    gridParam[0] = 1;
                    gridParam[1] = 3;
                    break;
                }
            }
        } else if (imagesSize <= 6) {
            switch (this.mSpanType) {
                case 2: 
                case 3: 
                case 4: {
                    gridParam[0] = 3;
                    gridParam[1] = 3;
                    break;
                }
                default: {
                    gridParam[0] = 2;
                    gridParam[1] = imagesSize / 2 + imagesSize % 2;
                    break;
                }
            }
        } else {
            gridParam[0] = imagesSize / 3 + (imagesSize % 3 == 0 ? 0 : 1);
            gridParam[1] = 3;
        }
    }

    public void setImagesData(List<T> lists) {
        this.setImagesData(lists, 0);
    }

    public void setImagesData(List<T> lists, int spanType) {
        if (lists == null || lists.isEmpty()) {
            this.setVisibility(8);
            return;
        }
        this.setVisibility(0);
        this.mSpanType = spanType;
        int newShowCount = this.getNeedShowCount(lists.size());
        int[] gridParam = this.calculateGridParam(newShowCount, this.mShowStyle);
        this.mRowCount = gridParam[0];
        this.mColumnCount = gridParam[1];
        if (this.mImgDataList == null) {
            for (int i = 0; i < newShowCount; ++i) {
                ImageView iv = this.getImageView(i);
                if (iv == null) {
                    return;
                }
                this.addView((View)iv, this.generateDefaultLayoutParams());
            }
        } else {
            int oldShowCount = this.getNeedShowCount(this.mImgDataList.size());
            if (oldShowCount > newShowCount) {
                this.removeViews(newShowCount, oldShowCount - newShowCount);
            } else if (oldShowCount < newShowCount) {
                for (int i = oldShowCount; i < newShowCount; ++i) {
                    ImageView iv = this.getImageView(i);
                    if (iv == null) {
                        return;
                    }
                    this.addView((View)iv, this.generateDefaultLayoutParams());
                }
            }
        }
        this.mImgDataList = lists;
        this.requestLayout();
    }

    private int getNeedShowCount(int size) {
        if (this.mMaxSize > 0 && size > this.mMaxSize) {
            return this.mMaxSize;
        }
        return size;
    }

    private ImageView getImageView(final int position) {
        if (position < this.mImageViewList.size()) {
            return this.mImageViewList.get(position);
        }
        if (this.mAdapter != null) {
            ImageView imageView = this.mAdapter.generateImageView(this.getContext());
            this.mImageViewList.add(imageView);
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NineGridImageView.this.mAdapter.onItemImageClick((ImageView)v, position, NineGridImageView.this.mImgDataList);
                    if (NineGridImageView.this.mItemImageClickListener != null) {
                        NineGridImageView.this.mItemImageClickListener.onItemImageClick((ImageView)v, position, NineGridImageView.this.mImgDataList);
                    }
                }
            });
            imageView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    boolean consumedEvent = NineGridImageView.this.mAdapter.onItemImageLongClick((ImageView)v, position, NineGridImageView.this.mImgDataList);
                    if (NineGridImageView.this.mItemImageLongClickListener != null) {
                        consumedEvent = NineGridImageView.this.mItemImageLongClickListener.onItemImageLongClick((ImageView)v, position, NineGridImageView.this.mImgDataList) || consumedEvent;
                    }
                    return consumedEvent;
                }
            });
            return imageView;
        }
        Log.e((String)"NineGirdImageView", (String)"Your must set a NineGridImageViewAdapter for NineGirdImageView");
        return null;
    }

    protected int[] calculateGridParam(int imagesSize, int showStyle) {
        int[] gridParam = new int[2];
        switch (showStyle) {
            case 1: {
                this.generateUnitRowAndColumnForSpanType(imagesSize, gridParam);
                break;
            }
            default: {
                gridParam[0] = imagesSize / 3 + (imagesSize % 3 == 0 ? 0 : 1);
                gridParam[1] = 3;
            }
        }
        return gridParam;
    }

    public void setAdapter(NineGridImageViewAdapter adapter) {
        this.mAdapter = adapter;
    }

    public void setGap(int gap) {
        this.mGap = gap;
    }

    public void setShowStyle(int showStyle) {
        this.mShowStyle = showStyle;
    }

    public void setSingleImgSize(int singleImgSize) {
        this.mSingleImgSize = singleImgSize;
    }

    public void setMaxSize(int maxSize) {
        this.mMaxSize = maxSize;
    }

    public void setItemImageClickListener(ItemImageClickListener<T> itemImageViewClickListener) {
        this.mItemImageClickListener = itemImageViewClickListener;
    }

    public void setItemImageLongClickListener(ItemImageLongClickListener<T> itemImageViewLongClickListener) {
        this.mItemImageLongClickListener = itemImageViewLongClickListener;
    }

    public T getImgDataItem(int position) {
        return this.mImgDataList != null && position < this.mImgDataList.size() ? (T)this.mImgDataList.get(position) : null;
    }
}

