/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.edit;

import android.opengl.GLES20;
import com.xuexiang.xui.widget.imageview.edit.GLToolbox;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

class TextureRenderer {
    private int mProgram;
    private int mTexSamplerHandle;
    private int mTexCoordHandle;
    private int mPosCoordHandle;
    private FloatBuffer mTexVertices;
    private FloatBuffer mPosVertices;
    private int mViewWidth;
    private int mViewHeight;
    private int mTexWidth;
    private int mTexHeight;
    private static final String VERTEX_SHADER = "attribute vec4 a_position;\nattribute vec2 a_texcoord;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_Position = a_position;\n  v_texcoord = a_texcoord;\n}\n";
    private static final String FRAGMENT_SHADER = "precision mediump float;\nuniform sampler2D tex_sampler;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler, v_texcoord);\n}\n";
    private static final float[] TEX_VERTICES = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private static final float[] POS_VERTICES = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private static final int FLOAT_SIZE_BYTES = 4;

    TextureRenderer() {
    }

    void init() {
        this.mProgram = GLToolbox.createProgram(VERTEX_SHADER, FRAGMENT_SHADER);
        this.mTexSamplerHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"tex_sampler");
        this.mTexCoordHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"a_texcoord");
        this.mPosCoordHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"a_position");
        this.mTexVertices = ByteBuffer.allocateDirect(TEX_VERTICES.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mTexVertices.put(TEX_VERTICES).position(0);
        this.mPosVertices = ByteBuffer.allocateDirect(POS_VERTICES.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mPosVertices.put(POS_VERTICES).position(0);
    }

    public void tearDown() {
        GLES20.glDeleteProgram((int)this.mProgram);
    }

    void updateTextureSize(int texWidth, int texHeight) {
        this.mTexWidth = texWidth;
        this.mTexHeight = texHeight;
        this.computeOutputVertices();
    }

    void updateViewSize(int viewWidth, int viewHeight) {
        this.mViewWidth = viewWidth;
        this.mViewHeight = viewHeight;
        this.computeOutputVertices();
    }

    void renderTexture(int texId) {
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glUseProgram((int)this.mProgram);
        GLToolbox.checkGlError("glUseProgram");
        GLES20.glViewport((int)0, (int)0, (int)this.mViewWidth, (int)this.mViewHeight);
        GLToolbox.checkGlError("glViewport");
        GLES20.glDisable((int)3042);
        GLES20.glVertexAttribPointer((int)this.mTexCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mTexVertices);
        GLES20.glEnableVertexAttribArray((int)this.mTexCoordHandle);
        GLES20.glVertexAttribPointer((int)this.mPosCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mPosVertices);
        GLES20.glEnableVertexAttribArray((int)this.mPosCoordHandle);
        GLToolbox.checkGlError("vertex attribute setup");
        GLES20.glActiveTexture((int)33984);
        GLToolbox.checkGlError("glActiveTexture");
        GLES20.glBindTexture((int)3553, (int)texId);
        GLToolbox.checkGlError("glBindTexture");
        GLES20.glUniform1i((int)this.mTexSamplerHandle, (int)0);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16384);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    private void computeOutputVertices() {
        if (this.mPosVertices != null) {
            float y1;
            float x1;
            float y0;
            float x0;
            float viewAspectRatio = (float)this.mViewWidth / (float)this.mViewHeight;
            float imgAspectRatio = (float)this.mTexWidth / (float)this.mTexHeight;
            float relativeAspectRatio = viewAspectRatio / imgAspectRatio;
            if (relativeAspectRatio > 1.0f) {
                x0 = -1.0f / relativeAspectRatio;
                y0 = -1.0f;
                x1 = 1.0f / relativeAspectRatio;
                y1 = 1.0f;
            } else {
                x0 = -1.0f;
                y0 = -relativeAspectRatio;
                x1 = 1.0f;
                y1 = relativeAspectRatio;
            }
            float[] coords = new float[]{x0, y0, x1, y0, x0, y1, x1, y1};
            this.mPosVertices.put(coords).position(0);
        }
    }
}

