/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.edit;

import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.widget.TextView;
import androidx.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;

public class TextStyleBuilder {
    private Map<TextStyle, Object> values = new HashMap<TextStyle, Object>();

    protected Map<TextStyle, Object> getValues() {
        return this.values;
    }

    public void withTextSize(float size) {
        this.values.put(TextStyle.SIZE, Float.valueOf(size));
    }

    public void withTextColor(int color2) {
        this.values.put(TextStyle.COLOR, color2);
    }

    public void withTextFont(@NonNull Typeface textTypeface) {
        this.values.put(TextStyle.FONT_FAMILY, textTypeface);
    }

    public void withGravity(int gravity) {
        this.values.put(TextStyle.GRAVITY, gravity);
    }

    public void withBackgroundColor(int background) {
        this.values.put(TextStyle.BACKGROUND, background);
    }

    public void withBackgroundDrawable(@NonNull Drawable bgDrawable) {
        this.values.put(TextStyle.BACKGROUND, bgDrawable);
    }

    public void withTextAppearance(int textAppearance) {
        this.values.put(TextStyle.TEXT_APPEARANCE, textAppearance);
    }

    void applyStyle(@NonNull TextView textView) {
        for (Map.Entry<TextStyle, Object> entry : this.values.entrySet()) {
            switch (entry.getKey()) {
                case SIZE: {
                    float size = ((Float)entry.getValue()).floatValue();
                    this.applyTextSize(textView, size);
                    break;
                }
                case COLOR: {
                    int color2 = (Integer)entry.getValue();
                    this.applyTextColor(textView, color2);
                    break;
                }
                case FONT_FAMILY: {
                    Typeface typeface = (Typeface)entry.getValue();
                    this.applyFontFamily(textView, typeface);
                    break;
                }
                case GRAVITY: {
                    int gravity = (Integer)entry.getValue();
                    this.applyGravity(textView, gravity);
                    break;
                }
                case BACKGROUND: {
                    if (entry.getValue() instanceof Drawable) {
                        Drawable bg = (Drawable)entry.getValue();
                        this.applyBackgroundDrawable(textView, bg);
                        break;
                    }
                    if (!(entry.getValue() instanceof Integer)) break;
                    int bgColor = (Integer)entry.getValue();
                    this.applyBackgroundColor(textView, bgColor);
                    break;
                }
                case TEXT_APPEARANCE: {
                    if (!(entry.getValue() instanceof Integer)) break;
                    int styleAppearance = (Integer)entry.getValue();
                    this.applyTextAppearance(textView, styleAppearance);
                    break;
                }
            }
        }
    }

    protected void applyTextSize(TextView textView, float size) {
        textView.setTextSize(size);
    }

    protected void applyTextColor(TextView textView, int color2) {
        textView.setTextColor(color2);
    }

    protected void applyFontFamily(TextView textView, Typeface typeface) {
        textView.setTypeface(typeface);
    }

    protected void applyGravity(TextView textView, int gravity) {
        textView.setGravity(gravity);
    }

    protected void applyBackgroundColor(TextView textView, int color2) {
        textView.setBackgroundColor(color2);
    }

    protected void applyBackgroundDrawable(TextView textView, Drawable bg) {
        if (Build.VERSION.SDK_INT >= 16) {
            textView.setBackground(bg);
        } else {
            textView.setBackgroundDrawable(bg);
        }
    }

    protected void applyTextAppearance(TextView textView, int styleAppearance) {
        if (Build.VERSION.SDK_INT >= 23) {
            textView.setTextAppearance(styleAppearance);
        } else {
            textView.setTextAppearance(textView.getContext(), styleAppearance);
        }
    }

    protected static enum TextStyle {
        SIZE("TextSize"),
        COLOR("TextColor"),
        GRAVITY("Gravity"),
        FONT_FAMILY("FontFamily"),
        BACKGROUND("Background"),
        TEXT_APPEARANCE("TextAppearance");

        private String property;

        private TextStyle(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }
    }
}

