/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.edit;

import android.graphics.Bitmap;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;

public class SaveSettings {
    private boolean isTransparencyEnabled;
    private boolean isClearViewsEnabled;
    private Bitmap.CompressFormat compressFormat;
    private int compressQuality;

    boolean isTransparencyEnabled() {
        return this.isTransparencyEnabled;
    }

    boolean isClearViewsEnabled() {
        return this.isClearViewsEnabled;
    }

    Bitmap.CompressFormat getCompressFormat() {
        return this.compressFormat;
    }

    int getCompressQuality() {
        return this.compressQuality;
    }

    private SaveSettings(Builder builder) {
        this.isClearViewsEnabled = builder.isClearViewsEnabled;
        this.isTransparencyEnabled = builder.isTransparencyEnabled;
        this.compressFormat = builder.compressFormat;
        this.compressQuality = builder.compressQuality;
    }

    public static class Builder {
        private boolean isTransparencyEnabled = true;
        private boolean isClearViewsEnabled = true;
        private Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
        private int compressQuality = 100;

        public Builder setTransparencyEnabled(boolean transparencyEnabled) {
            this.isTransparencyEnabled = transparencyEnabled;
            return this;
        }

        public Builder setClearViewsEnabled(boolean clearViewsEnabled) {
            this.isClearViewsEnabled = clearViewsEnabled;
            return this;
        }

        public Builder setCompressFormat(@NonNull Bitmap.CompressFormat compressFormat) {
            this.compressFormat = compressFormat;
            return this;
        }

        public Builder setCompressQuality(@IntRange(from=0L, to=100L) int compressQuality) {
            this.compressQuality = compressQuality;
            return this;
        }

        public SaveSettings build() {
            return new SaveSettings(this);
        }
    }
}

