/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.edit;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import com.xuexiang.xui.utils.DrawableUtils;

public class PhotoEnhance {
    public static final int ENHANCE_SATURATION = 0;
    public static final int ENHANCE_BRIGHTNESS = 1;
    public static final int ENHANCE_CONTRAST = 2;
    private Bitmap mBitmap;
    private float mSaturationNum = 1.0f;
    private float mBrightNum = 0.0f;
    private float mContrastNum = 1.0f;
    private ColorMatrix mAllMatrix = null;
    private ColorMatrix mSaturationMatrix = null;
    private ColorMatrix mContrastMatrix = null;
    private ColorMatrix mBrightnessMatrix = null;

    public PhotoEnhance() {
    }

    public PhotoEnhance(Bitmap bitmap) {
        this.mBitmap = bitmap;
    }

    public float getSaturation() {
        return this.mSaturationNum;
    }

    public PhotoEnhance setSaturation(int saturationNum) {
        this.mSaturationNum = (float)saturationNum * 1.0f / 128.0f;
        return this;
    }

    public float getBrightness() {
        return this.mBrightNum;
    }

    public PhotoEnhance setBrightness(int brightNum) {
        this.mBrightNum = brightNum - 128;
        return this;
    }

    public float getContrast() {
        return this.mContrastNum;
    }

    public PhotoEnhance setContrast(int contrastNum) {
        this.mContrastNum = (float)((double)(contrastNum / 2 + 64) / 128.0);
        return this;
    }

    public PhotoEnhance setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        return this;
    }

    public boolean hasSetBitmap() {
        return this.mBitmap != null;
    }

    public Bitmap handleImage(int type) {
        if (this.mBitmap == null) {
            return null;
        }
        Bitmap bitmap = DrawableUtils.createBitmapSafely(this.mBitmap.getWidth(), this.mBitmap.getHeight(), Bitmap.Config.ARGB_8888, 1);
        if (bitmap == null) {
            return null;
        }
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        if (this.mAllMatrix == null) {
            this.mAllMatrix = new ColorMatrix();
        }
        if (this.mSaturationMatrix == null) {
            this.mSaturationMatrix = new ColorMatrix();
        }
        if (this.mContrastMatrix == null) {
            this.mContrastMatrix = new ColorMatrix();
        }
        if (this.mBrightnessMatrix == null) {
            this.mBrightnessMatrix = new ColorMatrix();
        }
        switch (type) {
            case 0: {
                this.mSaturationMatrix.reset();
                this.mSaturationMatrix.setSaturation(this.mSaturationNum);
                break;
            }
            case 1: {
                this.mBrightnessMatrix.reset();
                this.mBrightnessMatrix.set(new float[]{1.0f, 0.0f, 0.0f, 0.0f, this.mBrightNum, 0.0f, 1.0f, 0.0f, 0.0f, this.mBrightNum, 0.0f, 0.0f, 1.0f, 0.0f, this.mBrightNum, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
                break;
            }
            case 2: {
                float regulateBright = 0.0f;
                regulateBright = (1.0f - this.mContrastNum) * 128.0f;
                this.mContrastMatrix.reset();
                this.mContrastMatrix.set(new float[]{this.mContrastNum, 0.0f, 0.0f, 0.0f, regulateBright, 0.0f, this.mContrastNum, 0.0f, 0.0f, regulateBright, 0.0f, 0.0f, this.mContrastNum, 0.0f, regulateBright, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
                break;
            }
        }
        this.mAllMatrix.reset();
        this.mAllMatrix.postConcat(this.mSaturationMatrix);
        this.mAllMatrix.postConcat(this.mBrightnessMatrix);
        this.mAllMatrix.postConcat(this.mContrastMatrix);
        paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(this.mAllMatrix));
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, paint);
        return bitmap;
    }
}

