/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.edit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.imageview.edit.BrushDrawingView;
import com.xuexiang.xui.widget.imageview.edit.CustomEffect;
import com.xuexiang.xui.widget.imageview.edit.FilterImageView;
import com.xuexiang.xui.widget.imageview.edit.ImageFilterView;
import com.xuexiang.xui.widget.imageview.edit.OnBitmapSaveListener;
import com.xuexiang.xui.widget.imageview.edit.PhotoFilter;

public class PhotoEditorView
extends RelativeLayout {
    private static final String TAG = "PhotoEditorView";
    private FilterImageView mImgSource;
    private BrushDrawingView mBrushDrawingView;
    private ImageFilterView mImageFilterView;
    private static final int IMG_SRC_ID = 1;
    private static final int BRUSH_SRC_ID = 2;
    private static final int GL_FILTER_ID = 3;

    public PhotoEditorView(Context context) {
        super(context);
        this.init(null);
    }

    public PhotoEditorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public PhotoEditorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @RequiresApi(api=21)
    public PhotoEditorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    @SuppressLint(value={"Recycle"})
    private void init(@Nullable AttributeSet attrs) {
        TypedArray a;
        Drawable imgSrcDrawable;
        this.mImgSource = new FilterImageView(this.getContext());
        this.mImgSource.setId(1);
        this.mImgSource.setAdjustViewBounds(true);
        RelativeLayout.LayoutParams imgSrcParam = new RelativeLayout.LayoutParams(-1, -2);
        imgSrcParam.addRule(13, -1);
        if (attrs != null && (imgSrcDrawable = (a = this.getContext().obtainStyledAttributes(attrs, R.styleable.PhotoEditorView)).getDrawable(R.styleable.PhotoEditorView_photo_src)) != null) {
            this.mImgSource.setImageDrawable(imgSrcDrawable);
        }
        this.mBrushDrawingView = new BrushDrawingView(this.getContext());
        this.mBrushDrawingView.setVisibility(8);
        this.mBrushDrawingView.setId(2);
        RelativeLayout.LayoutParams brushParam = new RelativeLayout.LayoutParams(-1, -2);
        brushParam.addRule(13, -1);
        brushParam.addRule(6, 1);
        brushParam.addRule(8, 1);
        this.mImageFilterView = new ImageFilterView(this.getContext());
        this.mImageFilterView.setId(3);
        this.mImageFilterView.setVisibility(8);
        RelativeLayout.LayoutParams imgFilterParam = new RelativeLayout.LayoutParams(-1, -2);
        imgFilterParam.addRule(13, -1);
        imgFilterParam.addRule(6, 1);
        imgFilterParam.addRule(8, 1);
        this.mImgSource.setOnImageChangedListener(new FilterImageView.OnImageChangedListener(){

            @Override
            public void onBitmapLoaded(@Nullable Bitmap sourceBitmap) {
                PhotoEditorView.this.mImageFilterView.setFilterEffect(PhotoFilter.NONE);
                PhotoEditorView.this.mImageFilterView.setSourceBitmap(sourceBitmap);
                Log.d((String)PhotoEditorView.TAG, (String)("onBitmapLoaded() called with: sourceBitmap = [" + sourceBitmap + "]"));
            }
        });
        this.addView((View)this.mImgSource, (ViewGroup.LayoutParams)imgSrcParam);
        this.addView((View)this.mImageFilterView, (ViewGroup.LayoutParams)imgFilterParam);
        this.addView(this.mBrushDrawingView, (ViewGroup.LayoutParams)brushParam);
    }

    public ImageView getSource() {
        return this.mImgSource;
    }

    BrushDrawingView getBrushDrawingView() {
        return this.mBrushDrawingView;
    }

    void saveFilter(final @NonNull OnBitmapSaveListener onBitmapSaveListener) {
        if (this.mImageFilterView.getVisibility() == 0) {
            this.mImageFilterView.saveBitmap(new OnBitmapSaveListener(){

                @Override
                public void onBitmapReady(Bitmap saveBitmap) {
                    Log.e((String)PhotoEditorView.TAG, (String)("saveFilter: " + saveBitmap));
                    PhotoEditorView.this.mImgSource.setImageBitmap(saveBitmap);
                    PhotoEditorView.this.mImageFilterView.setVisibility(8);
                    onBitmapSaveListener.onBitmapReady(saveBitmap);
                }

                @Override
                public void onFailure(Exception e) {
                    onBitmapSaveListener.onFailure(e);
                }
            });
        } else {
            onBitmapSaveListener.onBitmapReady(this.mImgSource.getBitmap());
        }
    }

    void setFilterEffect(PhotoFilter filterType) {
        this.mImageFilterView.setVisibility(0);
        this.mImageFilterView.setSourceBitmap(this.mImgSource.getBitmap());
        this.mImageFilterView.setFilterEffect(filterType);
    }

    void setFilterEffect(CustomEffect customEffect) {
        this.mImageFilterView.setVisibility(0);
        this.mImageFilterView.setSourceBitmap(this.mImgSource.getBitmap());
        this.mImageFilterView.setFilterEffect(customEffect);
    }
}

