/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.edit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.UiThread;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.imageview.edit.BitmapUtil;
import com.xuexiang.xui.widget.imageview.edit.BrushDrawingView;
import com.xuexiang.xui.widget.imageview.edit.BrushViewChangeListener;
import com.xuexiang.xui.widget.imageview.edit.CustomEffect;
import com.xuexiang.xui.widget.imageview.edit.MultiTouchListener;
import com.xuexiang.xui.widget.imageview.edit.OnBitmapSaveListener;
import com.xuexiang.xui.widget.imageview.edit.OnPhotoEditorListener;
import com.xuexiang.xui.widget.imageview.edit.PhotoEditorView;
import com.xuexiang.xui.widget.imageview.edit.PhotoFilter;
import com.xuexiang.xui.widget.imageview.edit.SaveSettings;
import com.xuexiang.xui.widget.imageview.edit.TextStyleBuilder;
import com.xuexiang.xui.widget.imageview.edit.ViewType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PhotoEditor
implements BrushViewChangeListener {
    private final LayoutInflater mLayoutInflater;
    private PhotoEditorView mParentView;
    private ImageView mImageView;
    private View mDeleteView;
    private BrushDrawingView mBrushDrawingView;
    private List<View> mAddedViews;
    private List<View> mRedoViews;
    private OnPhotoEditorListener mOnPhotoEditorListener;
    private boolean mIsTextPinchZoomable;
    private Typeface mDefaultTextTypeface;
    private Typeface mDefaultEmojiTypeface;

    private PhotoEditor(Builder builder) {
        this.mParentView = builder.parentView;
        this.mImageView = builder.imageView;
        this.mDeleteView = builder.deleteView;
        this.mBrushDrawingView = builder.brushDrawingView;
        this.mIsTextPinchZoomable = builder.isTextPinchZoomable;
        this.mDefaultTextTypeface = builder.textTypeface;
        this.mDefaultEmojiTypeface = builder.emojiTypeface;
        this.mLayoutInflater = (LayoutInflater)builder.context.getSystemService("layout_inflater");
        this.mBrushDrawingView.setBrushViewChangeListener(this);
        this.mAddedViews = new ArrayList<View>();
        this.mRedoViews = new ArrayList<View>();
    }

    public void addImage(Bitmap desiredImage) {
        View imageRootView = this.getLayout(ViewType.IMAGE);
        ImageView imageView = (ImageView)imageRootView.findViewById(R.id.iv_editor_image);
        final FrameLayout frmBorder = (FrameLayout)imageRootView.findViewById(R.id.fl_border);
        final ImageView imgClose = (ImageView)imageRootView.findViewById(R.id.iv_editor_close);
        imageView.setImageBitmap(desiredImage);
        MultiTouchListener multiTouchListener = this.getMultiTouchListener();
        multiTouchListener.setOnGestureControl(new MultiTouchListener.OnGestureControl(){

            @Override
            public void onClick() {
                boolean isBackgroundVisible = frmBorder.getTag() != null && (Boolean)frmBorder.getTag() != false;
                frmBorder.setBackgroundResource(isBackgroundVisible ? 0 : R.drawable.pe_rounded_border_tv);
                imgClose.setVisibility(isBackgroundVisible ? 8 : 0);
                frmBorder.setTag((Object)(!isBackgroundVisible ? 1 : 0));
            }

            @Override
            public void onLongClick() {
            }
        });
        imageRootView.setOnTouchListener((View.OnTouchListener)multiTouchListener);
        this.addViewToParent(imageRootView, ViewType.IMAGE);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void addText(String text, int colorCodeTextView) {
        this.addText(null, text, colorCodeTextView);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void addText(@Nullable Typeface textTypeface, String text, int colorCodeTextView) {
        TextStyleBuilder styleBuilder = new TextStyleBuilder();
        styleBuilder.withTextColor(colorCodeTextView);
        if (textTypeface != null) {
            styleBuilder.withTextFont(textTypeface);
        }
        this.addText(text, styleBuilder);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void addText(String text, @Nullable TextStyleBuilder styleBuilder) {
        this.mBrushDrawingView.setBrushDrawingMode(false);
        final View textRootView = this.getLayout(ViewType.TEXT);
        final TextView textInputTv = (TextView)textRootView.findViewById(R.id.tv_editor_text);
        final ImageView imgClose = (ImageView)textRootView.findViewById(R.id.iv_editor_close);
        final FrameLayout frmBorder = (FrameLayout)textRootView.findViewById(R.id.fl_border);
        textInputTv.setText((CharSequence)text);
        if (styleBuilder != null) {
            styleBuilder.applyStyle(textInputTv);
        }
        MultiTouchListener multiTouchListener = this.getMultiTouchListener();
        multiTouchListener.setOnGestureControl(new MultiTouchListener.OnGestureControl(){

            @Override
            public void onClick() {
                boolean isBackgroundVisible = frmBorder.getTag() != null && (Boolean)frmBorder.getTag() != false;
                frmBorder.setBackgroundResource(isBackgroundVisible ? 0 : R.drawable.pe_rounded_border_tv);
                imgClose.setVisibility(isBackgroundVisible ? 8 : 0);
                frmBorder.setTag((Object)(!isBackgroundVisible ? 1 : 0));
            }

            @Override
            public void onLongClick() {
                String textInput = textInputTv.getText().toString();
                int currentTextColor = textInputTv.getCurrentTextColor();
                if (PhotoEditor.this.mOnPhotoEditorListener != null) {
                    PhotoEditor.this.mOnPhotoEditorListener.onEditTextChangeListener(textRootView, textInput, currentTextColor);
                }
            }
        });
        textRootView.setOnTouchListener((View.OnTouchListener)multiTouchListener);
        this.addViewToParent(textRootView, ViewType.TEXT);
    }

    public void editText(@NonNull View view, String inputText, int colorCode) {
        this.editText(view, null, inputText, colorCode);
    }

    public void editText(@NonNull View view, @Nullable Typeface textTypeface, String inputText, int colorCode) {
        TextStyleBuilder styleBuilder = new TextStyleBuilder();
        styleBuilder.withTextColor(colorCode);
        if (textTypeface != null) {
            styleBuilder.withTextFont(textTypeface);
        }
        this.editText(view, inputText, styleBuilder);
    }

    public void editText(@NonNull View view, String inputText, @Nullable TextStyleBuilder styleBuilder) {
        TextView inputTextView = (TextView)view.findViewById(R.id.tv_editor_text);
        if (inputTextView != null && this.mAddedViews.contains(view) && !TextUtils.isEmpty((CharSequence)inputText)) {
            inputTextView.setText((CharSequence)inputText);
            if (styleBuilder != null) {
                styleBuilder.applyStyle(inputTextView);
            }
            this.mParentView.updateViewLayout(view, view.getLayoutParams());
            int i = this.mAddedViews.indexOf(view);
            if (i > -1) {
                this.mAddedViews.set(i, view);
            }
        }
    }

    public void addEmoji(String emojiName) {
        this.addEmoji(null, emojiName);
    }

    public void addEmoji(Typeface emojiTypeface, String emojiName) {
        this.mBrushDrawingView.setBrushDrawingMode(false);
        View emojiRootView = this.getLayout(ViewType.EMOJI);
        TextView emojiTextView = (TextView)emojiRootView.findViewById(R.id.tv_editor_text);
        final FrameLayout frmBorder = (FrameLayout)emojiRootView.findViewById(R.id.fl_border);
        final ImageView imgClose = (ImageView)emojiRootView.findViewById(R.id.iv_editor_close);
        if (emojiTypeface != null) {
            emojiTextView.setTypeface(emojiTypeface);
        }
        emojiTextView.setTextSize(56.0f);
        emojiTextView.setText((CharSequence)emojiName);
        MultiTouchListener multiTouchListener = this.getMultiTouchListener();
        multiTouchListener.setOnGestureControl(new MultiTouchListener.OnGestureControl(){

            @Override
            public void onClick() {
                boolean isBackgroundVisible = frmBorder.getTag() != null && (Boolean)frmBorder.getTag() != false;
                frmBorder.setBackgroundResource(isBackgroundVisible ? 0 : R.drawable.pe_rounded_border_tv);
                imgClose.setVisibility(isBackgroundVisible ? 8 : 0);
                frmBorder.setTag((Object)(!isBackgroundVisible ? 1 : 0));
            }

            @Override
            public void onLongClick() {
            }
        });
        emojiRootView.setOnTouchListener((View.OnTouchListener)multiTouchListener);
        this.addViewToParent(emojiRootView, ViewType.EMOJI);
    }

    private void addViewToParent(View rootView, ViewType viewType) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13, -1);
        this.mParentView.addView(rootView, (ViewGroup.LayoutParams)params);
        this.mAddedViews.add(rootView);
        if (this.mOnPhotoEditorListener != null) {
            this.mOnPhotoEditorListener.onAddViewListener(viewType, this.mAddedViews.size());
        }
    }

    @NonNull
    private MultiTouchListener getMultiTouchListener() {
        MultiTouchListener multiTouchListener = new MultiTouchListener(this.mDeleteView, this.mParentView, this.mImageView, this.mIsTextPinchZoomable, this.mOnPhotoEditorListener);
        return multiTouchListener;
    }

    private View getLayout(final ViewType viewType) {
        View rootView = null;
        switch (viewType) {
            case TEXT: {
                rootView = this.mLayoutInflater.inflate(R.layout.xui_layout_photo_editor_text, null);
                TextView txtText = (TextView)rootView.findViewById(R.id.tv_editor_text);
                if (txtText == null || this.mDefaultTextTypeface == null) break;
                txtText.setGravity(17);
                if (this.mDefaultEmojiTypeface == null) break;
                txtText.setTypeface(this.mDefaultTextTypeface);
                break;
            }
            case IMAGE: {
                rootView = this.mLayoutInflater.inflate(R.layout.xui_layout_photo_editor_image, null);
                break;
            }
            case EMOJI: {
                rootView = this.mLayoutInflater.inflate(R.layout.xui_layout_photo_editor_text, null);
                TextView txtTextEmoji = (TextView)rootView.findViewById(R.id.tv_editor_text);
                if (txtTextEmoji == null) break;
                if (this.mDefaultEmojiTypeface != null) {
                    txtTextEmoji.setTypeface(this.mDefaultEmojiTypeface);
                }
                txtTextEmoji.setGravity(17);
                txtTextEmoji.setLayerType(1, null);
                break;
            }
        }
        if (rootView != null) {
            rootView.setTag((Object)viewType);
            ImageView imgClose = (ImageView)rootView.findViewById(R.id.iv_editor_close);
            final View finalRootView = rootView;
            if (imgClose != null) {
                imgClose.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        PhotoEditor.this.viewUndo(finalRootView, viewType);
                    }
                });
            }
        }
        return rootView;
    }

    public PhotoEditor setBrushDrawingMode(boolean brushDrawingMode) {
        if (this.mBrushDrawingView != null) {
            this.mBrushDrawingView.setBrushDrawingMode(brushDrawingMode);
        }
        return this;
    }

    public Boolean getBrushDrawableMode() {
        return this.mBrushDrawingView != null && this.mBrushDrawingView.getBrushDrawingMode();
    }

    public PhotoEditor setBrushSize(float size) {
        if (this.mBrushDrawingView != null) {
            this.mBrushDrawingView.setBrushSize(size);
        }
        return this;
    }

    public PhotoEditor setOpacity(@IntRange(from=0L, to=100L) int opacity) {
        if (this.mBrushDrawingView != null) {
            opacity = (int)((double)opacity / 100.0 * 255.0);
            this.mBrushDrawingView.setOpacity(opacity);
        }
        return this;
    }

    public PhotoEditor setBrushColor(@ColorInt int color2) {
        if (this.mBrushDrawingView != null) {
            this.mBrushDrawingView.setBrushColor(color2);
        }
        return this;
    }

    public PhotoEditor setBrushEraserSize(float brushEraserSize) {
        if (this.mBrushDrawingView != null) {
            this.mBrushDrawingView.setBrushEraserSize(brushEraserSize);
        }
        return this;
    }

    void setBrushEraserColor(@ColorInt int color2) {
        if (this.mBrushDrawingView != null) {
            this.mBrushDrawingView.setBrushEraserColor(color2);
        }
    }

    public float getEraserSize() {
        return this.mBrushDrawingView != null ? this.mBrushDrawingView.getEraserSize() : 0.0f;
    }

    public float getBrushSize() {
        if (this.mBrushDrawingView != null) {
            return this.mBrushDrawingView.getBrushSize();
        }
        return 0.0f;
    }

    public int getBrushColor() {
        if (this.mBrushDrawingView != null) {
            return this.mBrushDrawingView.getBrushColor();
        }
        return 0;
    }

    public PhotoEditor brushEraser() {
        if (this.mBrushDrawingView != null) {
            this.mBrushDrawingView.brushEraser();
        }
        return this;
    }

    private void viewUndo(View removedView, ViewType viewType) {
        if (this.mAddedViews.size() > 0 && this.mAddedViews.contains(removedView)) {
            this.mParentView.removeView(removedView);
            this.mAddedViews.remove(removedView);
            this.mRedoViews.add(removedView);
            if (this.mOnPhotoEditorListener != null) {
                this.mOnPhotoEditorListener.onRemoveViewListener(viewType, this.mAddedViews.size());
            }
        }
    }

    public boolean undo() {
        if (this.mAddedViews.size() > 0) {
            Object viewTag;
            View removeView = this.mAddedViews.get(this.mAddedViews.size() - 1);
            if (removeView instanceof BrushDrawingView) {
                return this.mBrushDrawingView != null && this.mBrushDrawingView.undo();
            }
            this.mAddedViews.remove(this.mAddedViews.size() - 1);
            this.mParentView.removeView(removeView);
            this.mRedoViews.add(removeView);
            if (this.mOnPhotoEditorListener != null && (viewTag = removeView.getTag()) != null && viewTag instanceof ViewType) {
                this.mOnPhotoEditorListener.onRemoveViewListener((ViewType)((Object)viewTag), this.mAddedViews.size());
            }
        }
        return this.mAddedViews.size() != 0;
    }

    public boolean redo() {
        if (this.mRedoViews.size() > 0) {
            View redoView = this.mRedoViews.get(this.mRedoViews.size() - 1);
            if (redoView instanceof BrushDrawingView) {
                return this.mBrushDrawingView != null && this.mBrushDrawingView.redo();
            }
            this.mRedoViews.remove(this.mRedoViews.size() - 1);
            this.mParentView.addView(redoView);
            this.mAddedViews.add(redoView);
            Object viewTag = redoView.getTag();
            if (this.mOnPhotoEditorListener != null && viewTag != null && viewTag instanceof ViewType) {
                this.mOnPhotoEditorListener.onAddViewListener((ViewType)((Object)viewTag), this.mAddedViews.size());
            }
        }
        return this.mRedoViews.size() != 0;
    }

    private void clearBrushAllViews() {
        if (this.mBrushDrawingView != null) {
            this.mBrushDrawingView.clearAll();
        }
    }

    public void clearAllViews() {
        for (int i = 0; i < this.mAddedViews.size(); ++i) {
            this.mParentView.removeView(this.mAddedViews.get(i));
        }
        if (this.mAddedViews.contains((Object)this.mBrushDrawingView)) {
            this.mParentView.addView(this.mBrushDrawingView);
        }
        this.mAddedViews.clear();
        this.mRedoViews.clear();
        this.clearBrushAllViews();
    }

    @UiThread
    public void clearHelperBox() {
        for (int i = 0; i < this.mParentView.getChildCount(); ++i) {
            ImageView imgClose;
            View childAt = this.mParentView.getChildAt(i);
            FrameLayout frmBorder = (FrameLayout)childAt.findViewById(R.id.fl_border);
            if (frmBorder != null) {
                frmBorder.setBackgroundResource(0);
            }
            if ((imgClose = (ImageView)childAt.findViewById(R.id.iv_editor_close)) == null) continue;
            imgClose.setVisibility(8);
        }
    }

    public PhotoEditor setFilterEffect(CustomEffect customEffect) {
        this.mParentView.setFilterEffect(customEffect);
        return this;
    }

    public PhotoEditor setFilterEffect(PhotoFilter filterType) {
        this.mParentView.setFilterEffect(filterType);
        return this;
    }

    @RequiresPermission(allOf={"android.permission.WRITE_EXTERNAL_STORAGE"})
    public void saveAsFile(@NonNull String imagePath, @NonNull OnSaveListener onSaveListener) {
        this.saveAsFile(imagePath, new SaveSettings.Builder().build(), onSaveListener);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    @RequiresPermission(allOf={"android.permission.WRITE_EXTERNAL_STORAGE"})
    public void saveAsFile(final @NonNull String imagePath, final @NonNull SaveSettings saveSettings, final @NonNull OnSaveListener onSaveListener) {
        this.mParentView.saveFilter(new OnBitmapSaveListener(){

            @Override
            public void onBitmapReady(Bitmap saveBitmap) {
                new AsyncTask<String, String, Exception>(){

                    protected void onPreExecute() {
                        super.onPreExecute();
                        PhotoEditor.this.clearHelperBox();
                        PhotoEditor.this.mParentView.setDrawingCacheEnabled(false);
                    }

                    @SuppressLint(value={"MissingPermission"})
                    protected Exception doInBackground(String ... strings) {
                        File file = new File(imagePath);
                        try {
                            FileOutputStream out = new FileOutputStream(file, false);
                            if (PhotoEditor.this.mParentView != null) {
                                PhotoEditor.this.mParentView.setDrawingCacheEnabled(true);
                                Bitmap drawingCache = saveSettings.isTransparencyEnabled() ? BitmapUtil.removeTransparency(PhotoEditor.this.mParentView.getDrawingCache()) : PhotoEditor.this.mParentView.getDrawingCache();
                                drawingCache.compress(saveSettings.getCompressFormat(), saveSettings.getCompressQuality(), (OutputStream)out);
                            }
                            out.flush();
                            out.close();
                            return null;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return e;
                        }
                    }

                    protected void onPostExecute(Exception e) {
                        super.onPostExecute((Object)e);
                        if (e == null) {
                            if (saveSettings.isClearViewsEnabled()) {
                                PhotoEditor.this.clearAllViews();
                            }
                            onSaveListener.onSuccess(imagePath);
                        } else {
                            onSaveListener.onFailure(e);
                        }
                    }
                }.execute((Object[])new String[0]);
            }

            @Override
            public void onFailure(Exception e) {
                onSaveListener.onFailure(e);
            }
        });
    }

    @SuppressLint(value={"StaticFieldLeak"})
    public void saveAsBitmap(@NonNull OnBitmapSaveListener onBitmapSaveListener) {
        this.saveAsBitmap(new SaveSettings.Builder().build(), onBitmapSaveListener);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    public void saveAsBitmap(final @NonNull SaveSettings saveSettings, final @NonNull OnBitmapSaveListener onBitmapSaveListener) {
        this.mParentView.saveFilter(new OnBitmapSaveListener(){

            @Override
            public void onBitmapReady(Bitmap saveBitmap) {
                new AsyncTask<String, String, Bitmap>(){

                    protected void onPreExecute() {
                        super.onPreExecute();
                        PhotoEditor.this.clearHelperBox();
                        PhotoEditor.this.mParentView.setDrawingCacheEnabled(false);
                    }

                    protected Bitmap doInBackground(String ... strings) {
                        if (PhotoEditor.this.mParentView != null) {
                            PhotoEditor.this.mParentView.setDrawingCacheEnabled(true);
                            return saveSettings.isTransparencyEnabled() ? BitmapUtil.removeTransparency(PhotoEditor.this.mParentView.getDrawingCache()) : PhotoEditor.this.mParentView.getDrawingCache();
                        }
                        return null;
                    }

                    protected void onPostExecute(Bitmap bitmap) {
                        super.onPostExecute((Object)bitmap);
                        if (bitmap != null) {
                            if (saveSettings.isClearViewsEnabled()) {
                                PhotoEditor.this.clearAllViews();
                            }
                            onBitmapSaveListener.onBitmapReady(bitmap);
                        } else {
                            onBitmapSaveListener.onFailure(new Exception("Failed to load the bitmap"));
                        }
                    }
                }.execute((Object[])new String[0]);
            }

            @Override
            public void onFailure(Exception e) {
                onBitmapSaveListener.onFailure(e);
            }
        });
    }

    private static String convertEmoji(String emoji) {
        String returnedEmoji;
        try {
            int convertEmojiToInt = Integer.parseInt(emoji.substring(2), 16);
            returnedEmoji = new String(Character.toChars(convertEmojiToInt));
        }
        catch (NumberFormatException e) {
            returnedEmoji = "";
        }
        return returnedEmoji;
    }

    public PhotoEditor setOnPhotoEditorListener(@NonNull OnPhotoEditorListener onPhotoEditorListener) {
        this.mOnPhotoEditorListener = onPhotoEditorListener;
        return this;
    }

    public boolean isCacheEmpty() {
        return this.mAddedViews.size() == 0 && this.mRedoViews.size() == 0;
    }

    @Override
    public void onViewAdd(BrushDrawingView brushDrawingView) {
        if (this.mRedoViews.size() > 0) {
            this.mRedoViews.remove(this.mRedoViews.size() - 1);
        }
        this.mAddedViews.add(brushDrawingView);
        if (this.mOnPhotoEditorListener != null) {
            this.mOnPhotoEditorListener.onAddViewListener(ViewType.BRUSH_DRAWING, this.mAddedViews.size());
        }
    }

    @Override
    public void onViewRemoved(BrushDrawingView brushDrawingView) {
        if (this.mAddedViews.size() > 0) {
            View removeView = this.mAddedViews.remove(this.mAddedViews.size() - 1);
            if (!(removeView instanceof BrushDrawingView)) {
                this.mParentView.removeView(removeView);
            }
            this.mRedoViews.add(removeView);
        }
        if (this.mOnPhotoEditorListener != null) {
            this.mOnPhotoEditorListener.onRemoveViewListener(ViewType.BRUSH_DRAWING, this.mAddedViews.size());
        }
    }

    @Override
    public void onStartDrawing() {
        if (this.mOnPhotoEditorListener != null) {
            this.mOnPhotoEditorListener.onStartViewChangeListener(ViewType.BRUSH_DRAWING);
        }
    }

    @Override
    public void onStopDrawing() {
        if (this.mOnPhotoEditorListener != null) {
            this.mOnPhotoEditorListener.onStopViewChangeListener(ViewType.BRUSH_DRAWING);
        }
    }

    public static ArrayList<String> getEmojis(Context context) {
        String[] emojiList;
        ArrayList<String> convertedEmojiList = new ArrayList<String>();
        for (String emojiUnicode : emojiList = context.getResources().getStringArray(R.array.photo_editor_emoji)) {
            convertedEmojiList.add(PhotoEditor.convertEmoji(emojiUnicode));
        }
        return convertedEmojiList;
    }

    public static class Builder {
        private Context context;
        private PhotoEditorView parentView;
        private ImageView imageView;
        private View deleteView;
        private BrushDrawingView brushDrawingView;
        private Typeface textTypeface;
        private Typeface emojiTypeface;
        private boolean isTextPinchZoomable = true;

        public Builder(Context context, PhotoEditorView photoEditorView) {
            this.context = context;
            this.parentView = photoEditorView;
            this.imageView = photoEditorView.getSource();
            this.brushDrawingView = photoEditorView.getBrushDrawingView();
        }

        Builder setDeleteView(View deleteView) {
            this.deleteView = deleteView;
            return this;
        }

        public Builder setDefaultTextTypeface(Typeface textTypeface) {
            this.textTypeface = textTypeface;
            return this;
        }

        public Builder setDefaultEmojiTypeface(Typeface emojiTypeface) {
            this.emojiTypeface = emojiTypeface;
            return this;
        }

        public Builder setPinchTextScalable(boolean isTextPinchZoomable) {
            this.isTextPinchZoomable = isTextPinchZoomable;
            return this;
        }

        public PhotoEditor build() {
            return new PhotoEditor(this);
        }
    }

    public static interface OnSaveListener {
        public void onSuccess(@NonNull String var1);

        public void onFailure(@NonNull Exception var1);
    }
}

