/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.edit;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.effect.Effect;
import android.media.effect.EffectContext;
import android.media.effect.EffectFactory;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.GLUtils;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import com.xuexiang.xui.widget.imageview.edit.BitmapUtil;
import com.xuexiang.xui.widget.imageview.edit.CustomEffect;
import com.xuexiang.xui.widget.imageview.edit.GLToolbox;
import com.xuexiang.xui.widget.imageview.edit.OnBitmapSaveListener;
import com.xuexiang.xui.widget.imageview.edit.PhotoFilter;
import com.xuexiang.xui.widget.imageview.edit.TextureRenderer;
import java.util.Map;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

class ImageFilterView
extends GLSurfaceView
implements GLSurfaceView.Renderer {
    private static final String TAG = "ImageFilterView";
    private int[] mTextures = new int[2];
    private EffectContext mEffectContext;
    private Effect mEffect;
    private TextureRenderer mTexRenderer = new TextureRenderer();
    private int mImageWidth;
    private int mImageHeight;
    private boolean mInitialized = false;
    private PhotoFilter mCurrentEffect;
    private Bitmap mSourceBitmap;
    private CustomEffect mCustomEffect;
    private OnBitmapSaveListener mOnBitmapSaveListener;
    private boolean isSaveImage = false;

    public ImageFilterView(Context context) {
        super(context);
        this.init();
    }

    public ImageFilterView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setEGLContextClientVersion(2);
        this.setRenderer(this);
        this.setRenderMode(0);
        this.setFilterEffect(PhotoFilter.NONE);
    }

    void setSourceBitmap(Bitmap sourceBitmap) {
        this.mSourceBitmap = sourceBitmap;
        this.mInitialized = false;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        if (this.mTexRenderer != null) {
            this.mTexRenderer.updateViewSize(width, height);
        }
    }

    public void onDrawFrame(GL10 gl) {
        if (!this.mInitialized) {
            this.mEffectContext = EffectContext.createWithCurrentGlContext();
            this.mTexRenderer.init();
            this.loadTextures();
            this.mInitialized = true;
        }
        if (this.mCurrentEffect != PhotoFilter.NONE || this.mCustomEffect != null) {
            this.initEffect();
            this.applyEffect();
        }
        this.renderResult();
        if (this.isSaveImage) {
            final Bitmap mFilterBitmap = BitmapUtil.createBitmapFromGLSurface(this, gl);
            Log.e((String)TAG, (String)("onDrawFrame: " + mFilterBitmap));
            this.isSaveImage = false;
            if (this.mOnBitmapSaveListener != null) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        ImageFilterView.this.mOnBitmapSaveListener.onBitmapReady(mFilterBitmap);
                    }
                });
            }
        }
    }

    void setFilterEffect(PhotoFilter effect) {
        this.mCurrentEffect = effect;
        this.mCustomEffect = null;
        this.requestRender();
    }

    void setFilterEffect(CustomEffect customEffect) {
        this.mCustomEffect = customEffect;
        this.requestRender();
    }

    void saveBitmap(OnBitmapSaveListener onBitmapSaveListener) {
        this.mOnBitmapSaveListener = onBitmapSaveListener;
        this.isSaveImage = true;
        this.requestRender();
    }

    private void loadTextures() {
        GLES20.glGenTextures((int)2, (int[])this.mTextures, (int)0);
        if (this.mSourceBitmap != null) {
            this.mImageWidth = this.mSourceBitmap.getWidth();
            this.mImageHeight = this.mSourceBitmap.getHeight();
            this.mTexRenderer.updateTextureSize(this.mImageWidth, this.mImageHeight);
            GLES20.glBindTexture((int)3553, (int)this.mTextures[0]);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)this.mSourceBitmap, (int)0);
            GLToolbox.initTexParams();
        }
    }

    private void initEffect() {
        EffectFactory effectFactory = this.mEffectContext.getFactory();
        if (this.mEffect != null) {
            this.mEffect.release();
        }
        if (this.mCustomEffect != null) {
            this.mEffect = effectFactory.createEffect(this.mCustomEffect.getEffectName());
            Map<String, Object> parameters = this.mCustomEffect.getParameters();
            for (Map.Entry<String, Object> param : parameters.entrySet()) {
                this.mEffect.setParameter(param.getKey(), param.getValue());
            }
        } else {
            switch (this.mCurrentEffect) {
                case AUTO_FIX: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.AutoFixEffect");
                    this.mEffect.setParameter("scale", (Object)Float.valueOf(0.5f));
                    break;
                }
                case BLACK_WHITE: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.BlackWhiteEffect");
                    this.mEffect.setParameter("black", (Object)Float.valueOf(0.1f));
                    this.mEffect.setParameter("white", (Object)Float.valueOf(0.7f));
                    break;
                }
                case BRIGHTNESS: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.BrightnessEffect");
                    this.mEffect.setParameter("brightness", (Object)Float.valueOf(2.0f));
                    break;
                }
                case CONTRAST: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.ContrastEffect");
                    this.mEffect.setParameter("contrast", (Object)Float.valueOf(1.4f));
                    break;
                }
                case CROSS_PROCESS: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.CrossProcessEffect");
                    break;
                }
                case DOCUMENTARY: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.DocumentaryEffect");
                    break;
                }
                case DUE_TONE: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.DuotoneEffect");
                    this.mEffect.setParameter("first_color", (Object)-256);
                    this.mEffect.setParameter("second_color", (Object)-12303292);
                    break;
                }
                case FILL_LIGHT: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.FillLightEffect");
                    this.mEffect.setParameter("strength", (Object)Float.valueOf(0.8f));
                    break;
                }
                case FISH_EYE: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.FisheyeEffect");
                    this.mEffect.setParameter("scale", (Object)Float.valueOf(0.5f));
                    break;
                }
                case FLIP_HORIZONTAL: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.FlipEffect");
                    this.mEffect.setParameter("horizontal", (Object)true);
                    break;
                }
                case FLIP_VERTICAL: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.FlipEffect");
                    this.mEffect.setParameter("vertical", (Object)true);
                    break;
                }
                case GRAIN: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.GrainEffect");
                    this.mEffect.setParameter("strength", (Object)Float.valueOf(1.0f));
                    break;
                }
                case GRAY_SCALE: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.GrayscaleEffect");
                    break;
                }
                case LOMISH: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.LomoishEffect");
                    break;
                }
                case NEGATIVE: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.NegativeEffect");
                    break;
                }
                case NONE: {
                    break;
                }
                case POSTERIZE: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.PosterizeEffect");
                    break;
                }
                case ROTATE: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.RotateEffect");
                    this.mEffect.setParameter("angle", (Object)180);
                    break;
                }
                case SATURATE: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.SaturateEffect");
                    this.mEffect.setParameter("scale", (Object)Float.valueOf(0.5f));
                    break;
                }
                case SEPIA: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.SepiaEffect");
                    break;
                }
                case SHARPEN: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.SharpenEffect");
                    break;
                }
                case TEMPERATURE: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.ColorTemperatureEffect");
                    this.mEffect.setParameter("scale", (Object)Float.valueOf(0.9f));
                    break;
                }
                case TINT: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.TintEffect");
                    this.mEffect.setParameter("tint", (Object)-65281);
                    break;
                }
                case VIGNETTE: {
                    this.mEffect = effectFactory.createEffect("android.media.effect.effects.VignetteEffect");
                    this.mEffect.setParameter("scale", (Object)Float.valueOf(0.5f));
                    break;
                }
            }
        }
    }

    private void applyEffect() {
        this.mEffect.apply(this.mTextures[0], this.mImageWidth, this.mImageHeight, this.mTextures[1]);
    }

    private void renderResult() {
        if (this.mCurrentEffect != PhotoFilter.NONE || this.mCustomEffect != null) {
            this.mTexRenderer.renderTexture(this.mTextures[1]);
        } else {
            this.mTexRenderer.renderTexture(this.mTextures[0]);
        }
    }
}

