/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.edit;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;

class FilterImageView
extends AppCompatImageView {
    private OnImageChangedListener mOnImageChangedListener;

    public FilterImageView(Context context) {
        super(context);
    }

    public FilterImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FilterImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setOnImageChangedListener(OnImageChangedListener onImageChangedListener) {
        this.mOnImageChangedListener = onImageChangedListener;
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        if (this.mOnImageChangedListener != null) {
            this.mOnImageChangedListener.onBitmapLoaded(this.getBitmap());
        }
    }

    public void setImageIcon(@Nullable Icon icon) {
        super.setImageIcon(icon);
        if (this.mOnImageChangedListener != null) {
            this.mOnImageChangedListener.onBitmapLoaded(this.getBitmap());
        }
    }

    public void setImageMatrix(Matrix matrix) {
        super.setImageMatrix(matrix);
        if (this.mOnImageChangedListener != null) {
            this.mOnImageChangedListener.onBitmapLoaded(this.getBitmap());
        }
    }

    public void setImageState(int[] state, boolean merge) {
        super.setImageState(state, merge);
        if (this.mOnImageChangedListener != null) {
            this.mOnImageChangedListener.onBitmapLoaded(this.getBitmap());
        }
    }

    public void setImageTintList(@Nullable ColorStateList tint) {
        super.setImageTintList(tint);
        if (this.mOnImageChangedListener != null) {
            this.mOnImageChangedListener.onBitmapLoaded(this.getBitmap());
        }
    }

    public void setImageTintMode(@Nullable PorterDuff.Mode tintMode) {
        super.setImageTintMode(tintMode);
        if (this.mOnImageChangedListener != null) {
            this.mOnImageChangedListener.onBitmapLoaded(this.getBitmap());
        }
    }

    public void setImageDrawable(@Nullable Drawable drawable2) {
        super.setImageDrawable(drawable2);
        if (this.mOnImageChangedListener != null) {
            this.mOnImageChangedListener.onBitmapLoaded(this.getBitmap());
        }
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        if (this.mOnImageChangedListener != null) {
            this.mOnImageChangedListener.onBitmapLoaded(this.getBitmap());
        }
    }

    public void setImageURI(@Nullable Uri uri) {
        super.setImageURI(uri);
        if (this.mOnImageChangedListener != null) {
            this.mOnImageChangedListener.onBitmapLoaded(this.getBitmap());
        }
    }

    public void setImageLevel(int level) {
        super.setImageLevel(level);
        if (this.mOnImageChangedListener != null) {
            this.mOnImageChangedListener.onBitmapLoaded(this.getBitmap());
        }
    }

    @Nullable
    Bitmap getBitmap() {
        if (this.getDrawable() != null) {
            return ((BitmapDrawable)this.getDrawable()).getBitmap();
        }
        return null;
    }

    static interface OnImageChangedListener {
        public void onBitmapLoaded(@Nullable Bitmap var1);
    }
}

