/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.edit;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;

public class CustomEffect {
    private String mEffectName;
    private Map<String, Object> mParametersMap;

    private CustomEffect(Builder builder) {
        this.mEffectName = builder.mEffectName;
        this.mParametersMap = builder.mParametersMap;
    }

    public String getEffectName() {
        return this.mEffectName;
    }

    public Map<String, Object> getParameters() {
        return this.mParametersMap;
    }

    public static class Builder {
        private String mEffectName;
        private Map<String, Object> mParametersMap = new HashMap<String, Object>();

        public Builder(@NonNull String effectName) throws RuntimeException {
            if (TextUtils.isEmpty((CharSequence)effectName)) {
                throw new RuntimeException("Effect name cannot be empty.Please provide effect name from EffectFactory");
            }
            this.mEffectName = effectName;
        }

        public Builder setParameter(@NonNull String paramKey, Object paramValue) {
            this.mParametersMap.put(paramKey, paramValue);
            return this;
        }

        public CustomEffect build() {
            return new CustomEffect(this);
        }
    }
}

