/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.edit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.xuexiang.xui.widget.imageview.edit.BrushViewChangeListener;
import com.xuexiang.xui.widget.imageview.edit.LinePath;
import java.util.Stack;

public class BrushDrawingView
extends View {
    static final float DEFAULT_BRUSH_SIZE = 25.0f;
    static final float DEFAULT_ERASER_SIZE = 50.0f;
    static final int DEFAULT_OPACITY = 255;
    private float mBrushSize = 25.0f;
    private float mBrushEraserSize = 50.0f;
    private int mOpacity = 255;
    private final Stack<LinePath> mDrawnPaths = new Stack();
    private final Stack<LinePath> mRedoPaths = new Stack();
    private final Paint mDrawPaint = new Paint();
    private Canvas mDrawCanvas;
    private boolean mBrushDrawMode;
    private Path mPath;
    private float mTouchX;
    private float mTouchY;
    private static final float TOUCH_TOLERANCE = 4.0f;
    private BrushViewChangeListener mBrushViewChangeListener;

    public BrushDrawingView(Context context) {
        this(context, null);
    }

    public BrushDrawingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BrushDrawingView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setupBrushDrawing();
    }

    private void setupBrushDrawing() {
        this.setLayerType(2, null);
        this.mDrawPaint.setColor(-16777216);
        this.setupPathAndPaint();
        this.setVisibility(8);
    }

    private void setupPathAndPaint() {
        this.mPath = new Path();
        this.mDrawPaint.setAntiAlias(true);
        this.mDrawPaint.setDither(true);
        this.mDrawPaint.setStyle(Paint.Style.STROKE);
        this.mDrawPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mDrawPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mDrawPaint.setStrokeWidth(this.mBrushSize);
        this.mDrawPaint.setAlpha(this.mOpacity);
        this.mDrawPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
    }

    private void refreshBrushDrawing() {
        this.mBrushDrawMode = true;
        this.setupPathAndPaint();
    }

    void brushEraser() {
        this.mBrushDrawMode = true;
        this.mDrawPaint.setStrokeWidth(this.mBrushEraserSize);
        this.mDrawPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
    }

    void setBrushDrawingMode(boolean brushDrawMode) {
        this.mBrushDrawMode = brushDrawMode;
        if (brushDrawMode) {
            this.setVisibility(0);
            this.refreshBrushDrawing();
        }
    }

    void setOpacity(@IntRange(from=0L, to=255L) int opacity) {
        this.mOpacity = opacity;
        this.setBrushDrawingMode(true);
    }

    int getOpacity() {
        return this.mOpacity;
    }

    boolean getBrushDrawingMode() {
        return this.mBrushDrawMode;
    }

    void setBrushSize(float size) {
        this.mBrushSize = size;
        this.setBrushDrawingMode(true);
    }

    void setBrushColor(@ColorInt int color2) {
        this.mDrawPaint.setColor(color2);
        this.setBrushDrawingMode(true);
    }

    void setBrushEraserSize(float brushEraserSize) {
        this.mBrushEraserSize = brushEraserSize;
        this.setBrushDrawingMode(true);
    }

    void setBrushEraserColor(@ColorInt int color2) {
        this.mDrawPaint.setColor(color2);
        this.setBrushDrawingMode(true);
    }

    float getEraserSize() {
        return this.mBrushEraserSize;
    }

    float getBrushSize() {
        return this.mBrushSize;
    }

    int getBrushColor() {
        return this.mDrawPaint.getColor();
    }

    void clearAll() {
        this.mDrawnPaths.clear();
        this.mRedoPaths.clear();
        if (this.mDrawCanvas != null) {
            this.mDrawCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        this.invalidate();
    }

    void setBrushViewChangeListener(BrushViewChangeListener brushViewChangeListener) {
        this.mBrushViewChangeListener = brushViewChangeListener;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        Bitmap canvasBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mDrawCanvas = new Canvas(canvasBitmap);
    }

    protected void onDraw(Canvas canvas) {
        for (LinePath linePath : this.mDrawnPaths) {
            canvas.drawPath(linePath.getDrawPath(), linePath.getDrawPaint());
        }
        canvas.drawPath(this.mPath, this.mDrawPaint);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.mBrushDrawMode) {
            float touchX = event.getX();
            float touchY = event.getY();
            switch (event.getAction()) {
                case 0: {
                    this.touchStart(touchX, touchY);
                    break;
                }
                case 2: {
                    this.touchMove(touchX, touchY);
                    break;
                }
                case 1: {
                    this.touchUp();
                    break;
                }
            }
            this.invalidate();
            return true;
        }
        return false;
    }

    boolean undo() {
        if (!this.mDrawnPaths.empty()) {
            this.mRedoPaths.push(this.mDrawnPaths.pop());
            this.invalidate();
        }
        if (this.mBrushViewChangeListener != null) {
            this.mBrushViewChangeListener.onViewRemoved(this);
        }
        return !this.mDrawnPaths.empty();
    }

    boolean redo() {
        if (!this.mRedoPaths.empty()) {
            this.mDrawnPaths.push(this.mRedoPaths.pop());
            this.invalidate();
        }
        if (this.mBrushViewChangeListener != null) {
            this.mBrushViewChangeListener.onViewAdd(this);
        }
        return !this.mRedoPaths.empty();
    }

    private void touchStart(float x, float y) {
        this.mRedoPaths.clear();
        this.mPath.reset();
        this.mPath.moveTo(x, y);
        this.mTouchX = x;
        this.mTouchY = y;
        if (this.mBrushViewChangeListener != null) {
            this.mBrushViewChangeListener.onStartDrawing();
        }
    }

    private void touchMove(float x, float y) {
        float dx = Math.abs(x - this.mTouchX);
        float dy = Math.abs(y - this.mTouchY);
        if (dx >= 4.0f || dy >= 4.0f) {
            this.mPath.quadTo(this.mTouchX, this.mTouchY, (x + this.mTouchX) / 2.0f, (y + this.mTouchY) / 2.0f);
            this.mTouchX = x;
            this.mTouchY = y;
        }
    }

    private void touchUp() {
        this.mPath.lineTo(this.mTouchX, this.mTouchY);
        this.mDrawCanvas.drawPath(this.mPath, this.mDrawPaint);
        this.mDrawnPaths.push(new LinePath(this.mPath, this.mDrawPaint));
        this.mPath = new Path();
        if (this.mBrushViewChangeListener != null) {
            this.mBrushViewChangeListener.onStopDrawing();
            this.mBrushViewChangeListener.onViewAdd(this);
        }
    }

    @VisibleForTesting
    Paint getDrawingPaint() {
        return this.mDrawPaint;
    }

    @VisibleForTesting
    Pair<Stack<LinePath>, Stack<LinePath>> getDrawingPath() {
        return new Pair(this.mDrawnPaths, this.mRedoPaths);
    }
}

