/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.edit;

import android.graphics.Bitmap;
import android.opengl.GLException;
import android.opengl.GLSurfaceView;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.opengles.GL10;

class BitmapUtil {
    BitmapUtil() {
    }

    static Bitmap removeTransparency(Bitmap source) {
        int x;
        int y;
        int y2;
        int x2;
        int firstX = 0;
        int firstY = 0;
        int lastX = source.getWidth();
        int lastY = source.getHeight();
        int[] pixels = new int[source.getWidth() * source.getHeight()];
        source.getPixels(pixels, 0, source.getWidth(), 0, 0, source.getWidth(), source.getHeight());
        block0: for (x2 = 0; x2 < source.getWidth(); ++x2) {
            for (y2 = 0; y2 < source.getHeight(); ++y2) {
                if (pixels[x2 + y2 * source.getWidth()] == 0) continue;
                firstX = x2;
                break block0;
            }
        }
        block2: for (y = 0; y < source.getHeight(); ++y) {
            for (x = firstX; x < source.getHeight(); ++x) {
                if (pixels[x + y * source.getWidth()] == 0) continue;
                firstY = y;
                break block2;
            }
        }
        block4: for (x2 = source.getWidth() - 1; x2 >= firstX; --x2) {
            for (y2 = source.getHeight() - 1; y2 >= firstY; --y2) {
                if (pixels[x2 + y2 * source.getWidth()] == 0) continue;
                lastX = x2;
                break block4;
            }
        }
        block6: for (y = source.getHeight() - 1; y >= firstY; --y) {
            for (x = source.getWidth() - 1; x >= firstX; --x) {
                if (pixels[x + y * source.getWidth()] == 0) continue;
                lastY = y;
                break block6;
            }
        }
        return Bitmap.createBitmap((Bitmap)source, (int)firstX, (int)firstY, (int)(lastX - firstX), (int)(lastY - firstY));
    }

    static Bitmap createBitmapFromGLSurface(GLSurfaceView glSurfaceView, GL10 gl) throws OutOfMemoryError {
        int x = 0;
        int y = 0;
        int w = glSurfaceView.getWidth();
        int h = glSurfaceView.getHeight();
        int[] bitmapBuffer = new int[w * h];
        int[] bitmapSource = new int[w * h];
        IntBuffer intBuffer = IntBuffer.wrap(bitmapBuffer);
        intBuffer.position(0);
        try {
            gl.glReadPixels(x, y, w, h, 6408, 5121, (Buffer)intBuffer);
            for (int i = 0; i < h; ++i) {
                int offset1 = i * w;
                int offset2 = (h - i - 1) * w;
                for (int j = 0; j < w; ++j) {
                    int pixel;
                    int texturePixel = bitmapBuffer[offset1 + j];
                    int blue = texturePixel >> 16 & 0xFF;
                    int red = texturePixel << 16 & 0xFF0000;
                    bitmapSource[offset2 + j] = pixel = texturePixel & 0xFF00FF00 | red | blue;
                }
            }
        }
        catch (GLException e) {
            return null;
        }
        return Bitmap.createBitmap((int[])bitmapSource, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }
}

