/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.crop;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.xuexiang.xui.utils.ThemeUtils;

final class PaintUtil {
    private static final String DEFAULT_LINE_COLOR_ID = "#AAFFFFFF";
    private static final String DEFAULT_BACKGROUND_COLOR_ID = "#B0000000";
    private static final float DEFAULT_LINE_THICKNESS_DP = 3.0f;
    private static final float DEFAULT_CORNER_THICKNESS_DP = 5.0f;
    private static final float DEFAULT_GUIDELINE_THICKNESS_PX = 1.0f;

    private PaintUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    static Paint newBorderPaint(Context context) {
        float lineThicknessPx = TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        Paint borderPaint = new Paint();
        borderPaint.setColor(Color.parseColor((String)DEFAULT_LINE_COLOR_ID));
        borderPaint.setStrokeWidth(lineThicknessPx);
        borderPaint.setStyle(Paint.Style.STROKE);
        return borderPaint;
    }

    static Paint newGuidelinePaint(Context context) {
        Paint paint = new Paint();
        paint.setColor(Color.parseColor((String)DEFAULT_LINE_COLOR_ID));
        paint.setStrokeWidth(1.0f);
        return paint;
    }

    static Paint newBackgroundPaint(Context context) {
        Paint paint = new Paint();
        paint.setColor(Color.parseColor((String)DEFAULT_BACKGROUND_COLOR_ID));
        return paint;
    }

    static Paint newCornerPaint(Context context) {
        float lineThicknessPx = TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        Paint cornerPaint = new Paint();
        cornerPaint.setColor(ThemeUtils.getMainThemeColor(context));
        cornerPaint.setStrokeWidth(lineThicknessPx);
        cornerPaint.setStyle(Paint.Style.STROKE);
        return cornerPaint;
    }

    static float getCornerThickness() {
        return 5.0f;
    }

    static float getLineThickness() {
        return 3.0f;
    }
}

