/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.crop;

import android.graphics.Rect;
import com.xuexiang.xui.widget.imageview.crop.AspectRatioUtil;
import com.xuexiang.xui.widget.imageview.crop.Edge;
import com.xuexiang.xui.widget.imageview.crop.HandleHelper;

class HorizontalHandleHelper
extends HandleHelper {
    private Edge mEdge;

    HorizontalHandleHelper(Edge edge) {
        super(edge, null);
        this.mEdge = edge;
    }

    @Override
    void updateCropWindow(float x, float y, float targetAspectRatio, Rect imageRect, float snapRadius) {
        float offset;
        this.mEdge.adjustCoordinate(x, y, imageRect, snapRadius, targetAspectRatio);
        float left = Edge.LEFT.getCoordinate();
        float top = Edge.TOP.getCoordinate();
        float right = Edge.RIGHT.getCoordinate();
        float bottom = Edge.BOTTOM.getCoordinate();
        float targetWidth = AspectRatioUtil.calculateWidth(top, bottom, targetAspectRatio);
        float currentWidth = right - left;
        float difference = targetWidth - currentWidth;
        float halfDifference = difference / 2.0f;
        Edge.LEFT.setCoordinate(left -= halfDifference);
        Edge.RIGHT.setCoordinate(right += halfDifference);
        if (Edge.LEFT.isOutsideMargin(imageRect, snapRadius) && !this.mEdge.isNewRectangleOutOfBounds(Edge.LEFT, imageRect, targetAspectRatio)) {
            offset = Edge.LEFT.snapToRect(imageRect);
            Edge.RIGHT.offset(-offset);
            this.mEdge.adjustCoordinate(targetAspectRatio);
        }
        if (Edge.RIGHT.isOutsideMargin(imageRect, snapRadius) && !this.mEdge.isNewRectangleOutOfBounds(Edge.RIGHT, imageRect, targetAspectRatio)) {
            offset = Edge.RIGHT.snapToRect(imageRect);
            Edge.LEFT.offset(-offset);
            this.mEdge.adjustCoordinate(targetAspectRatio);
        }
    }
}

