/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ThemeUtils;

public class SignatureView
extends View {
    public static final float DEFAULT_PEN_SIZE = 10.0f;
    private float mX;
    private float mY;
    private Paint mGesturePaint = new Paint();
    private Path mPath = new Path();
    private Canvas mCacheCanvas;
    private Bitmap mCacheBitmap;
    private boolean mIsTouched = false;
    private float mPenSize = 10.0f;
    private int mPenColor = -16777216;
    private int mBackColor = 0;
    private Paint mBorderPaint;
    private int mBorderWidth;

    public SignatureView(Context context) {
        super(context);
        this.initAttrs(context, null);
    }

    public SignatureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public SignatureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SignatureView);
        this.mPenSize = typedArray.getDimension(R.styleable.SignatureView_stv_penSize, this.mPenSize);
        this.mPenColor = typedArray.getColor(R.styleable.SignatureView_stv_penColor, -16777216);
        this.mBackColor = typedArray.getColor(R.styleable.SignatureView_stv_backColor, 0);
        boolean hasBorder = typedArray.getBoolean(R.styleable.SignatureView_stv_hasBorder, false);
        this.updateBorderStyle(hasBorder);
        typedArray.recycle();
        this.initPaint();
    }

    private void updateBorderStyle(boolean hasBorder) {
        if (hasBorder) {
            this.mBorderPaint = new Paint();
            this.mBorderWidth = DensityUtils.dp2px(this.getContext(), 1.0f);
            this.initBorderPaintStyle();
        } else {
            this.mBorderPaint = null;
            this.mBorderWidth = 0;
        }
    }

    private void initPaint() {
        this.mGesturePaint.setAntiAlias(true);
        this.mGesturePaint.setDither(true);
        this.mGesturePaint.setStyle(Paint.Style.STROKE);
        this.mGesturePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mGesturePaint.setStrokeWidth(this.mPenSize);
        this.mGesturePaint.setColor(this.mPenColor);
    }

    private void initBorderPaintStyle() {
        if (this.mBorderPaint != null) {
            this.mBorderPaint.setAntiAlias(true);
            this.mBorderPaint.setStyle(Paint.Style.STROKE);
            this.mBorderPaint.setStrokeCap(Paint.Cap.ROUND);
            this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
            this.mBorderPaint.setColor(-16777216);
            this.mBorderPaint.setColor(ThemeUtils.resolveColor(this.getContext(), R.attr.xui_config_color_separator_dark));
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateCacheCanvasSize();
    }

    private void updateCacheCanvasSize() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.mCacheBitmap = Bitmap.createBitmap((int)(this.getWidth() - 2 * this.mBorderWidth), (int)(this.getHeight() - 2 * this.mBorderWidth), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mCacheCanvas = new Canvas(this.mCacheBitmap);
            this.mCacheCanvas.drawColor(this.mBackColor);
            this.mIsTouched = false;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.touchDown(event);
                break;
            }
            case 2: {
                this.mIsTouched = true;
                this.touchMove(event);
                break;
            }
            case 1: {
                this.touchUp();
                break;
            }
        }
        this.invalidate();
        return true;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBorder(canvas);
        canvas.drawBitmap(this.mCacheBitmap, (float)this.mBorderWidth, (float)this.mBorderWidth, this.mGesturePaint);
        canvas.drawPath(this.mPath, this.mGesturePaint);
    }

    private void drawBorder(Canvas canvas) {
        if (this.mBorderPaint != null) {
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mBorderPaint);
        }
    }

    private void touchDown(MotionEvent event) {
        this.mPath.reset();
        float x = event.getX();
        float y = event.getY();
        this.mX = x;
        this.mY = y;
        this.mPath.moveTo(x, y);
    }

    private void touchMove(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        float previousX = this.mX;
        float previousY = this.mY;
        float dx = Math.abs(x - previousX);
        float dy = Math.abs(y - previousY);
        if (dx >= 3.0f || dy >= 3.0f) {
            float cX = (x + previousX) / 2.0f;
            float cY = (y + previousY) / 2.0f;
            this.mPath.quadTo(previousX, previousY, cX, cY);
            this.mX = x;
            this.mY = y;
        }
    }

    private void touchUp() {
        this.mCacheCanvas.translate((float)(-this.mBorderWidth), (float)(-this.mBorderWidth));
        this.mCacheCanvas.drawPath(this.mPath, this.mGesturePaint);
        this.mCacheCanvas.translate((float)this.mBorderWidth, (float)this.mBorderWidth);
        this.mPath.reset();
    }

    public void clear() {
        if (this.mCacheCanvas != null) {
            this.mIsTouched = false;
            this.mGesturePaint.setColor(this.mPenColor);
            if (this.mBackColor == 0) {
                this.mCacheCanvas.drawColor(this.mBackColor, PorterDuff.Mode.CLEAR);
            } else {
                this.mCacheCanvas.drawColor(this.mBackColor);
            }
            this.mGesturePaint.setColor(this.mPenColor);
            this.invalidate();
        }
    }

    public Bitmap getSnapshot() {
        return this.mCacheBitmap;
    }

    public SignatureView setPenSize(float penSize) {
        this.mPenSize = penSize = penSize > 0.0f ? penSize : 10.0f;
        if (this.mGesturePaint != null) {
            this.mGesturePaint.setStrokeWidth(penSize);
        }
        return this;
    }

    public SignatureView enableBorder(boolean hasBorder) {
        this.updateBorderStyle(hasBorder);
        this.updateCacheCanvasSize();
        return this;
    }

    public SignatureView setBackColor(int backColor) {
        this.mBackColor = backColor;
        if (this.mCacheCanvas != null) {
            this.mCacheCanvas.drawColor(this.mBackColor);
        }
        return this;
    }

    public SignatureView setPenColor(int penColor) {
        this.mPenColor = penColor;
        if (this.mGesturePaint != null) {
            this.mGesturePaint.setColor(penColor);
        }
        return this;
    }

    public boolean getTouched() {
        return this.mIsTouched;
    }

    public void recycle() {
        if (this.mCacheBitmap != null) {
            this.mCacheBitmap.recycle();
            this.mCacheBitmap = null;
        }
        if (this.mCacheCanvas != null) {
            this.mCacheCanvas.drawColor(this.mBackColor, PorterDuff.Mode.CLEAR);
            this.mCacheCanvas = null;
        }
        this.mGesturePaint = null;
        this.mPath = null;
    }

    public SignatureView setViewSize(int width, int height) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(width, height);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        return this;
    }
}

