/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.appcompat.widget.AppCompatImageView;
import com.xuexiang.xui.R;

public class RadiusImageView
extends AppCompatImageView {
    private static final int DEFAULT_BORDER_COLOR = -7829368;
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private static final int COLOR_DRAWABLE_DIMEN = 2;
    private boolean mIsSelected = false;
    private boolean mIsOval = false;
    private boolean mIsCircle = false;
    private int mBorderWidth;
    private int mBorderColor;
    private int mSelectedBorderWidth;
    private int mSelectedBorderColor;
    private int mSelectedMaskColor;
    private boolean mIsTouchSelectModeEnabled = true;
    private int mCornerRadius;
    private Paint mBitmapPaint;
    private Paint mBorderPaint;
    private ColorFilter mColorFilter;
    private ColorFilter mSelectedColorFilter;
    private BitmapShader mBitmapShader;
    private boolean mNeedResetShader = false;
    private RectF mRectF = new RectF();
    private Bitmap mBitmap;
    private Matrix mMatrix;
    private int mWidth;
    private int mHeight;

    public RadiusImageView(Context context) {
        this(context, null);
    }

    public RadiusImageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.RadiusImageViewStyle);
    }

    public RadiusImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mMatrix = new Matrix();
        this.setScaleType(ImageView.ScaleType.CENTER_CROP);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.RadiusImageView, defStyleAttr, 0);
        this.mBorderWidth = array.getDimensionPixelSize(R.styleable.RadiusImageView_riv_border_width, 0);
        this.mBorderColor = array.getColor(R.styleable.RadiusImageView_riv_border_color, -7829368);
        this.mSelectedBorderWidth = array.getDimensionPixelSize(R.styleable.RadiusImageView_riv_selected_border_width, this.mBorderWidth);
        this.mSelectedBorderColor = array.getColor(R.styleable.RadiusImageView_riv_selected_border_color, this.mBorderColor);
        this.mSelectedMaskColor = array.getColor(R.styleable.RadiusImageView_riv_selected_mask_color, 0);
        if (this.mSelectedMaskColor != 0) {
            this.mSelectedColorFilter = new PorterDuffColorFilter(this.mSelectedMaskColor, PorterDuff.Mode.DARKEN);
        }
        this.mIsTouchSelectModeEnabled = array.getBoolean(R.styleable.RadiusImageView_riv_is_touch_select_mode_enabled, true);
        this.mIsCircle = array.getBoolean(R.styleable.RadiusImageView_riv_is_circle, false);
        if (!this.mIsCircle) {
            this.mIsOval = array.getBoolean(R.styleable.RadiusImageView_riv_is_oval, false);
        }
        if (!this.mIsOval) {
            this.mCornerRadius = array.getDimensionPixelSize(R.styleable.RadiusImageView_riv_corner_radius, 0);
        }
        array.recycle();
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType != ImageView.ScaleType.CENTER_CROP) {
            throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301ScaleType %s", scaleType));
        }
        super.setScaleType(scaleType);
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        if (adjustViewBounds) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301adjustViewBounds");
        }
    }

    public void setBorderWidth(int borderWidth) {
        if (this.mBorderWidth != borderWidth) {
            this.mBorderWidth = borderWidth;
            this.invalidate();
        }
    }

    public void setBorderColor(@ColorInt int borderColor) {
        if (this.mBorderColor != borderColor) {
            this.mBorderColor = borderColor;
            this.invalidate();
        }
    }

    public void setCornerRadius(int cornerRadius) {
        if (this.mCornerRadius != cornerRadius) {
            this.mCornerRadius = cornerRadius;
            if (!this.mIsCircle && !this.mIsOval) {
                this.invalidate();
            }
        }
    }

    public void setSelectedBorderColor(@ColorInt int selectedBorderColor) {
        if (this.mSelectedBorderColor != selectedBorderColor) {
            this.mSelectedBorderColor = selectedBorderColor;
            if (this.mIsSelected) {
                this.invalidate();
            }
        }
    }

    public void setSelectedBorderWidth(int selectedBorderWidth) {
        if (this.mSelectedBorderWidth != selectedBorderWidth) {
            this.mSelectedBorderWidth = selectedBorderWidth;
            if (this.mIsSelected) {
                this.invalidate();
            }
        }
    }

    public void setSelectedMaskColor(@ColorInt int selectedMaskColor) {
        if (this.mSelectedMaskColor != selectedMaskColor) {
            this.mSelectedMaskColor = selectedMaskColor;
            this.mSelectedColorFilter = this.mSelectedMaskColor != 0 ? new PorterDuffColorFilter(this.mSelectedMaskColor, PorterDuff.Mode.DARKEN) : null;
            if (this.mIsSelected) {
                this.invalidate();
            }
        }
        this.mSelectedMaskColor = selectedMaskColor;
    }

    public void setCircle(boolean isCircle) {
        if (this.mIsCircle != isCircle) {
            this.mIsCircle = isCircle;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setOval(boolean isOval) {
        boolean forceUpdate = false;
        if (isOval && this.mIsCircle) {
            this.mIsCircle = false;
            forceUpdate = true;
        }
        if (this.mIsOval != isOval || forceUpdate) {
            this.mIsOval = isOval;
            this.requestLayout();
            this.invalidate();
        }
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    public int getCornerRadius() {
        return this.mCornerRadius;
    }

    public int getSelectedBorderColor() {
        return this.mSelectedBorderColor;
    }

    public int getSelectedBorderWidth() {
        return this.mSelectedBorderWidth;
    }

    public int getSelectedMaskColor() {
        return this.mSelectedMaskColor;
    }

    public boolean isCircle() {
        return this.mIsCircle;
    }

    public boolean isOval() {
        return !this.mIsCircle && this.mIsOval;
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    public void setSelected(boolean isSelected) {
        if (this.mIsSelected != isSelected) {
            this.mIsSelected = isSelected;
            this.invalidate();
        }
    }

    public void setTouchSelectModeEnabled(boolean touchSelectModeEnabled) {
        this.mIsTouchSelectModeEnabled = touchSelectModeEnabled;
    }

    public boolean isTouchSelectModeEnabled() {
        return this.mIsTouchSelectModeEnabled;
    }

    public void setSelectedColorFilter(ColorFilter cf) {
        if (this.mSelectedColorFilter == cf) {
            return;
        }
        this.mSelectedColorFilter = cf;
        if (this.mIsSelected) {
            this.invalidate();
        }
    }

    public void setColorFilter(ColorFilter cf) {
        if (this.mColorFilter == cf) {
            return;
        }
        this.mColorFilter = cf;
        if (!this.mIsSelected) {
            this.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        if (this.mIsCircle) {
            int size = Math.min(width, height);
            this.setMeasuredDimension(size, size);
        } else {
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            if (this.mBitmap == null) {
                return;
            }
            boolean widthWrapContent = widthMode == Integer.MIN_VALUE || widthMode == 0;
            boolean heightWrapContent = heightMode == Integer.MIN_VALUE || heightMode == 0;
            float bmWidth = this.mBitmap.getWidth();
            float bmHeight = this.mBitmap.getHeight();
            float scaleX = (float)width / bmWidth;
            float scaleY = (float)height / bmHeight;
            if (widthWrapContent && heightWrapContent) {
                if (scaleX >= 1.0f && scaleY >= 1.0f) {
                    this.setMeasuredDimension((int)bmWidth, (int)bmHeight);
                    return;
                }
                if (scaleX >= 1.0f) {
                    this.setMeasuredDimension((int)(bmHeight * scaleY), height);
                    return;
                }
                if (scaleY >= 1.0f) {
                    this.setMeasuredDimension(width, (int)(bmHeight * scaleX));
                    return;
                }
                if (scaleX < scaleY) {
                    this.setMeasuredDimension(width, (int)(bmHeight * scaleX));
                } else {
                    this.setMeasuredDimension((int)(bmWidth * scaleY), height);
                }
            } else if (widthWrapContent) {
                this.setMeasuredDimension((int)(bmWidth * scaleY), height);
            } else if (heightWrapContent) {
                this.setMeasuredDimension(width, (int)(bmHeight * scaleX));
            }
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        this.setupBitmap();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.setupBitmap();
    }

    private Bitmap getBitmap() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return null;
        }
        if (drawable2 instanceof BitmapDrawable) {
            Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
            if (bitmap == null) {
                return null;
            }
            float bmWidth = bitmap.getWidth();
            float bmHeight = bitmap.getHeight();
            if (bmWidth == 0.0f || bmHeight == 0.0f) {
                return null;
            }
            float minScaleX = (float)this.getMinimumWidth() / bmWidth;
            float minScaleY = (float)this.getMinimumHeight() / bmHeight;
            if (minScaleX > 1.0f || minScaleY > 1.0f) {
                float scale = Math.max(minScaleX, minScaleY);
                Matrix matrix = new Matrix();
                matrix.postScale(scale, scale);
                return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)((int)bmWidth), (int)((int)bmHeight), (Matrix)matrix, (boolean)false);
            }
            return bitmap;
        }
        try {
            Bitmap bitmap = drawable2 instanceof ColorDrawable ? Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)BITMAP_CONFIG) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setupBitmap() {
        Bitmap bm = this.getBitmap();
        if (bm == this.mBitmap) {
            return;
        }
        this.mBitmap = bm;
        if (this.mBitmap == null) {
            this.mBitmapShader = null;
            this.invalidate();
            return;
        }
        this.mNeedResetShader = true;
        this.mBitmapShader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        if (this.mBitmapPaint == null) {
            this.mBitmapPaint = new Paint();
            this.mBitmapPaint.setAntiAlias(true);
        }
        this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
        this.requestLayout();
        this.invalidate();
    }

    private void updateBitmapShader() {
        this.mMatrix.reset();
        this.mNeedResetShader = false;
        if (this.mBitmapShader == null || this.mBitmap == null) {
            return;
        }
        float bmWidth = this.mBitmap.getWidth();
        float bmHeight = this.mBitmap.getHeight();
        float scaleX = (float)this.mWidth / bmWidth;
        float scaleY = (float)this.mHeight / bmHeight;
        float scale = Math.max(scaleX, scaleY);
        this.mMatrix.setScale(scale, scale);
        this.mMatrix.postTranslate(-(scale * bmWidth - (float)this.mWidth) / 2.0f, -(scale * bmHeight - (float)this.mHeight) / 2.0f);
        this.mBitmapShader.setLocalMatrix(this.mMatrix);
        this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
    }

    private void drawBitmap(Canvas canvas, int borderWidth) {
        float halfBorderWidth = (float)borderWidth * 1.0f / 2.0f;
        this.mBitmapPaint.setColorFilter(this.mIsSelected ? this.mSelectedColorFilter : this.mColorFilter);
        if (this.mIsCircle) {
            int center = this.getWidth() / 2;
            canvas.drawCircle((float)center, (float)center, (float)center - halfBorderWidth, this.mBitmapPaint);
        } else {
            this.mRectF.left = halfBorderWidth;
            this.mRectF.top = halfBorderWidth;
            this.mRectF.right = (float)this.getWidth() - halfBorderWidth;
            this.mRectF.bottom = (float)this.getHeight() - halfBorderWidth;
            if (this.mIsOval) {
                canvas.drawOval(this.mRectF, this.mBitmapPaint);
            } else {
                canvas.drawRoundRect(this.mRectF, (float)this.mCornerRadius, (float)this.mCornerRadius, this.mBitmapPaint);
            }
        }
    }

    private void drawBorder(Canvas canvas, int borderWidth) {
        if (borderWidth <= 0) {
            return;
        }
        float halfBorderWidth = (float)borderWidth * 1.0f / 2.0f;
        this.mBorderPaint.setColor(this.mIsSelected ? this.mSelectedBorderColor : this.mBorderColor);
        this.mBorderPaint.setStrokeWidth((float)borderWidth);
        if (this.mIsCircle) {
            int radius = this.getWidth() / 2;
            canvas.drawCircle((float)radius, (float)radius, (float)radius - halfBorderWidth, this.mBorderPaint);
        } else {
            this.mRectF.left = halfBorderWidth;
            this.mRectF.top = halfBorderWidth;
            this.mRectF.right = (float)this.getWidth() - halfBorderWidth;
            this.mRectF.bottom = (float)this.getHeight() - halfBorderWidth;
            if (this.mIsOval) {
                canvas.drawOval(this.mRectF, this.mBorderPaint);
            } else {
                canvas.drawRoundRect(this.mRectF, (float)this.mCornerRadius, (float)this.mCornerRadius, this.mBorderPaint);
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        int borderWidth;
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        int n = borderWidth = this.mIsSelected ? this.mSelectedBorderWidth : this.mBorderWidth;
        if (this.mBitmap == null || this.mBitmapShader == null) {
            this.drawBorder(canvas, borderWidth);
            return;
        }
        if (this.mWidth != width || this.mHeight != height || this.mNeedResetShader) {
            this.mWidth = width;
            this.mHeight = height;
            this.updateBitmapShader();
        }
        this.drawBitmap(canvas, borderWidth);
        this.drawBorder(canvas, borderWidth);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isClickable()) {
            this.setSelected(false);
            return super.onTouchEvent(event);
        }
        if (!this.mIsTouchSelectModeEnabled) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                this.setSelected(true);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                this.setSelected(false);
                break;
            }
        }
        return super.onTouchEvent(event);
    }
}

