/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.xuexiang.xui.widget.imageview.strategy.DiskCacheStrategyEnum;
import com.xuexiang.xui.widget.imageview.strategy.IImageLoadStrategy;
import com.xuexiang.xui.widget.imageview.strategy.ILoadListener;
import com.xuexiang.xui.widget.imageview.strategy.LoadOption;
import com.xuexiang.xui.widget.imageview.strategy.impl.GlideImageLoadStrategy;

public class ImageLoader
implements IImageLoadStrategy {
    private static volatile ImageLoader sInstance = null;
    private IImageLoadStrategy mStrategy = new GlideImageLoadStrategy();

    private ImageLoader() {
    }

    public ImageLoader setImageLoadStrategy(@NonNull IImageLoadStrategy strategy) {
        this.mStrategy = strategy;
        return this;
    }

    public IImageLoadStrategy getStrategy() {
        return this.mStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageLoader get() {
        if (sInstance != null) return sInstance;
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path) {
        this.mStrategy.loadImage(imageView, path);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, @NonNull ILoadListener listener) {
        this.mStrategy.loadImage(imageView, path, listener);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path) {
        this.mStrategy.loadGifImage(imageView, path);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, @NonNull ILoadListener listener) {
        this.mStrategy.loadGifImage(imageView, path, listener);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, DiskCacheStrategyEnum strategy) {
        this.mStrategy.loadImage(imageView, path, strategy);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, DiskCacheStrategyEnum strategy, ILoadListener listener) {
        this.mStrategy.loadImage(imageView, path, strategy, listener);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, DiskCacheStrategyEnum strategy) {
        this.mStrategy.loadGifImage(imageView, path, strategy);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, DiskCacheStrategyEnum strategy, ILoadListener listener) {
        this.mStrategy.loadGifImage(imageView, path, strategy, listener);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, Drawable placeholder, DiskCacheStrategyEnum strategy) {
        this.mStrategy.loadImage(imageView, path, placeholder, strategy);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, Drawable placeholder, DiskCacheStrategyEnum strategy, ILoadListener listener) {
        this.mStrategy.loadImage(imageView, path, placeholder, strategy, listener);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, Drawable placeholder, DiskCacheStrategyEnum strategy) {
        this.mStrategy.loadGifImage(imageView, path, placeholder, strategy);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, Drawable placeholder, DiskCacheStrategyEnum strategy, ILoadListener listener) {
        this.mStrategy.loadGifImage(imageView, path, placeholder, strategy, listener);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, LoadOption loadOption) {
        this.mStrategy.loadImage(imageView, path, loadOption);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, LoadOption loadOption, ILoadListener listener) {
        this.mStrategy.loadImage(imageView, path, loadOption, listener);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, LoadOption loadOption) {
        this.mStrategy.loadGifImage(imageView, path, loadOption);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, LoadOption loadOption, ILoadListener listener) {
        this.mStrategy.loadGifImage(imageView, path, loadOption, listener);
    }

    @Override
    public void clearCache(Context context) {
        this.mStrategy.clearCache(context);
    }

    @Override
    public void clearMemoryCache(Context context) {
        this.mStrategy.clearMemoryCache(context);
    }

    @Override
    public void clearDiskCache(Context context) {
        this.mStrategy.clearDiskCache(context);
    }
}

