/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.guidview;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import com.xuexiang.xui.widget.guidview.FocusShape;
import com.xuexiang.xui.widget.guidview.Utils;

class Calculator {
    private final int mBitmapWidth;
    private final int mBitmapHeight;
    private FocusShape mFocusShape;
    private int mFocusWidth;
    private int mFocusHeight;
    private int mCircleCenterX;
    private int mCircleCenterY;
    private int mCircleRadius;
    private boolean mHasFocus;

    public void setCircleRadius(int mCircleRadius) {
        this.mCircleRadius = mCircleRadius;
    }

    Calculator(Activity activity, FocusShape focusShape, View view, double radiusFactor, boolean fitSystemWindows, int adjustHeight, int offsetX) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int deviceWidth = displayMetrics.widthPixels;
        int deviceHeight = displayMetrics.heightPixels;
        this.mBitmapWidth = deviceWidth;
        this.mBitmapHeight = deviceHeight - (fitSystemWindows ? 0 : Utils.getStatusBarHeight((Context)activity));
        if (view != null) {
            if (adjustHeight == -1) {
                adjustHeight = fitSystemWindows && Build.VERSION.SDK_INT >= 21 ? 0 : Utils.getStatusBarHeight((Context)activity);
            }
            int[] viewPoint = new int[2];
            view.getLocationInWindow(viewPoint);
            this.mFocusWidth = view.getWidth();
            this.mFocusHeight = view.getHeight();
            this.mFocusShape = focusShape;
            this.mCircleCenterX = viewPoint[0] + this.mFocusWidth / 2 + offsetX;
            this.mCircleCenterY = viewPoint[1] + this.mFocusHeight / 2 - adjustHeight;
            this.mCircleRadius = (int)((double)((int)(Math.hypot(view.getWidth(), view.getHeight()) / 2.0)) * radiusFactor);
            this.mHasFocus = true;
        } else {
            this.mHasFocus = false;
        }
    }

    public void setRectPosition(int positionX, int positionY, int rectWidth, int rectHeight) {
        this.mCircleCenterX = positionX;
        this.mCircleCenterY = positionY;
        this.mFocusWidth = rectWidth;
        this.mFocusHeight = rectHeight;
        this.mFocusShape = FocusShape.ROUNDED_RECTANGLE;
        this.mHasFocus = true;
    }

    public void setCirclePosition(int positionX, int positionY, int radius) {
        this.mCircleCenterX = positionX;
        this.mCircleRadius = radius;
        this.mCircleCenterY = positionY;
        this.mFocusShape = FocusShape.CIRCLE;
        this.mHasFocus = true;
    }

    FocusShape getFocusShape() {
        return this.mFocusShape;
    }

    int getFocusWidth() {
        return this.mFocusWidth;
    }

    int getFocusHeight() {
        return this.mFocusHeight;
    }

    int getCircleCenterX() {
        return this.mCircleCenterX;
    }

    int getCircleCenterY() {
        return this.mCircleCenterY;
    }

    int getViewRadius() {
        return this.mCircleRadius;
    }

    boolean hasFocus() {
        return this.mHasFocus;
    }

    int getBitmapWidth() {
        return this.mBitmapWidth;
    }

    int getBitmapHeight() {
        return this.mBitmapHeight;
    }

    float circleRadius(int animCounter, double animMoveFactor) {
        return (float)((double)this.mCircleRadius + (double)animCounter * animMoveFactor);
    }

    float roundRectLeft(int animCounter, double animMoveFactor) {
        return (float)((double)(this.mCircleCenterX - this.mFocusWidth / 2) - (double)animCounter * animMoveFactor);
    }

    float roundRectTop(int animCounter, double animMoveFactor) {
        return (float)((double)(this.mCircleCenterY - this.mFocusHeight / 2) - (double)animCounter * animMoveFactor);
    }

    float roundRectRight(int animCounter, double animMoveFactor) {
        return (float)((double)(this.mCircleCenterX + this.mFocusWidth / 2) + (double)animCounter * animMoveFactor);
    }

    float roundRectBottom(int animCounter, double animMoveFactor) {
        return (float)((double)(this.mCircleCenterY + this.mFocusHeight / 2) + (double)animCounter * animMoveFactor);
    }

    float roundRectLeftCircleRadius(int animCounter, double animMoveFactor) {
        return (float)((double)(this.mFocusHeight / 2) + (double)animCounter * animMoveFactor);
    }
}

