/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.edittext.verify;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.edittext.verify.PwdEditText;
import com.xuexiang.xui.widget.edittext.verify.PwdTextView;
import com.xuexiang.xui.widget.edittext.verify.TInputConnection;

public class VerifyCodeEditText
extends FrameLayout {
    private static final int DEFAULT_HEIGHT = 50;
    private static final int DEFAULT_EDIT_TEXT_SIZE = 4;
    private LinearLayout mLlContainer;
    private PwdEditText mEditText;
    private int mEtNumber;
    private int mEtWidth;
    private boolean mIsDivideEqually;
    private Drawable mEtDivider;
    private int mEtTextColor;
    private float mEtTextSize;
    private Drawable mBackgroundFocus;
    private Drawable mBackgroundNormal;
    private boolean mIsPwd;
    private float mPwdRadius;
    private PwdTextView[] mPwdTextViews;
    private InputNumberTextWatcher mTextWatcher = new InputNumberTextWatcher();
    private OnInputListener mOnInputListener;

    public VerifyCodeEditText(Context context) {
        this(context, null);
    }

    public VerifyCodeEditText(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.VerifyCodeEditTextStyle);
    }

    public VerifyCodeEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        LayoutInflater.from((Context)context).inflate(R.layout.xui_layout_verify_code, (ViewGroup)this);
        this.mLlContainer = (LinearLayout)this.findViewById(R.id.ll_container);
        this.mEditText = (PwdEditText)this.findViewById(R.id.et_input);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.VerifyCodeEditText, defStyleAttr, 0);
        this.mEtNumber = typedArray.getInteger(R.styleable.VerifyCodeEditText_vcet_number, 4);
        this.mEtWidth = typedArray.getDimensionPixelSize(R.styleable.VerifyCodeEditText_vcet_width, ResUtils.getDimensionPixelSize(context, R.dimen.default_vcet_width));
        this.mIsDivideEqually = typedArray.getBoolean(R.styleable.VerifyCodeEditText_vcet_is_divide_equally, false);
        this.mEtDivider = ResUtils.getDrawableAttrRes(context, typedArray, R.styleable.VerifyCodeEditText_vcet_divider);
        this.mEtTextSize = typedArray.getDimensionPixelSize(R.styleable.VerifyCodeEditText_vcet_text_size, ResUtils.getDimensionPixelSize(context, R.dimen.default_vcet_text_size));
        this.mEtTextColor = typedArray.getColor(R.styleable.VerifyCodeEditText_vcet_text_color, -16777216);
        this.mBackgroundFocus = ResUtils.getDrawableAttrRes(context, typedArray, R.styleable.VerifyCodeEditText_vcet_bg_focus);
        this.mBackgroundNormal = ResUtils.getDrawableAttrRes(context, typedArray, R.styleable.VerifyCodeEditText_vcet_bg_normal);
        this.mIsPwd = typedArray.getBoolean(R.styleable.VerifyCodeEditText_vcet_is_pwd, false);
        this.mPwdRadius = typedArray.getDimensionPixelSize(R.styleable.VerifyCodeEditText_vcet_pwd_radius, ResUtils.getDimensionPixelSize(context, R.dimen.default_vcet_pwd_radius));
        typedArray.recycle();
        if (this.mEtDivider == null) {
            this.mEtDivider = ResUtils.getDrawable(context, R.drawable.vcet_shape_divider);
        }
        if (this.mBackgroundFocus == null) {
            this.mBackgroundFocus = ResUtils.getDrawable(context, R.drawable.vcet_shape_bg_focus);
        }
        if (this.mBackgroundNormal == null) {
            this.mBackgroundNormal = ResUtils.getDrawable(context, R.drawable.vcet_shape_bg_normal);
        }
        if (this.mIsDivideEqually) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    VerifyCodeEditText.this.refreshEditSizeWhenDivideEqually();
                    VerifyCodeEditText.this.initView(VerifyCodeEditText.this.getContext());
                }
            });
        } else {
            this.initView(context);
        }
    }

    private void refreshEditSizeWhenDivideEqually() {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
        int dividerWidth = this.mEtDivider != null ? this.mEtDivider.getMinimumWidth() : 0;
        this.mEtWidth = (DensityUtils.getDisplayWidth(this.getContext(), true) - dividerWidth * (this.mEtNumber - 1) - this.getPaddingLeft() - this.getPaddingRight() - params.leftMargin - params.rightMargin) / this.mEtNumber;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mIsDivideEqually) {
            String input = this.getInputValue();
            this.mEditText.removeTextChangedListener(this.mTextWatcher);
            this.mLlContainer.removeAllViews();
            this.refreshEditSizeWhenDivideEqually();
            this.restoreView(this.getContext(), input);
        }
    }

    private void restoreView(Context context, String input) {
        this.initTextViews(context, this.mEtNumber, this.mEtWidth, this.mEtDivider, this.mEtTextSize, this.mEtTextColor);
        this.initEtContainer((TextView[])this.mPwdTextViews);
        if (!TextUtils.isEmpty((CharSequence)input)) {
            String[] strArray = input.split("");
            for (int i = 0; i < strArray.length && i <= this.mEtNumber; ++i) {
                this.setText(strArray[i], true);
            }
        }
        this.setListener();
    }

    private void initView(Context context) {
        this.initTextViews(context, this.mEtNumber, this.mEtWidth, this.mEtDivider, this.mEtTextSize, this.mEtTextColor);
        this.initEtContainer((TextView[])this.mPwdTextViews);
        this.setListener();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minHeight;
        int heightMeasureSpecValue = heightMeasureSpec;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpecValue);
        if (heightMode == Integer.MIN_VALUE && this.mEtWidth < (minHeight = (int)this.dp2px(50.0f, this.getContext()))) {
            heightMeasureSpecValue = View.MeasureSpec.makeMeasureSpec((int)minHeight, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpecValue);
    }

    private void initTextViews(Context context, int etNumber, int etWidth, Drawable etDividerDrawable, float etTextSize, int etTextColor) {
        this.mEditText.setCursorVisible(false);
        this.mEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(etNumber)});
        if (etDividerDrawable != null) {
            etDividerDrawable.setBounds(0, 0, etDividerDrawable.getMinimumWidth(), etDividerDrawable.getMinimumHeight());
            this.mLlContainer.setDividerDrawable(etDividerDrawable);
        }
        this.mPwdTextViews = new PwdTextView[etNumber];
        for (int i = 0; i < this.mPwdTextViews.length; ++i) {
            PwdTextView textView = new PwdTextView(context);
            textView.setTextSize(0, etTextSize);
            textView.setTextColor(etTextColor);
            if (!this.mIsDivideEqually) {
                textView.setWidth(etWidth);
            }
            textView.setHeight(etWidth);
            if (i == 0) {
                textView.setBackgroundDrawable(this.mBackgroundFocus);
            } else {
                textView.setBackgroundDrawable(this.mBackgroundNormal);
            }
            textView.setGravity(17);
            textView.setFocusable(false);
            this.mPwdTextViews[i] = textView;
        }
    }

    private void initEtContainer(TextView[] textViews) {
        if (this.mIsDivideEqually) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mLlContainer.getLayoutParams();
            if (layoutParams == null) {
                layoutParams = new FrameLayout.LayoutParams(-1, -1);
                layoutParams.gravity = 17;
            } else {
                layoutParams.width = -1;
            }
            this.mLlContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            LinearLayout.LayoutParams childParams = new LinearLayout.LayoutParams(0, -1);
            childParams.weight = 1.0f;
            for (TextView textView : textViews) {
                this.mLlContainer.addView((View)textView, (ViewGroup.LayoutParams)childParams);
            }
        } else {
            for (TextView textView : textViews) {
                this.mLlContainer.addView((View)textView);
            }
        }
    }

    private void setListener() {
        this.mEditText.addTextChangedListener(this.mTextWatcher);
        this.mEditText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 67 && event.getAction() == 0) {
                    VerifyCodeEditText.this.onKeyDelete();
                    return true;
                }
                return false;
            }
        });
        this.mEditText.setBackSpaceListener(new TInputConnection.BackspaceListener(){

            @Override
            public boolean onBackspace() {
                VerifyCodeEditText.this.onKeyDelete();
                return true;
            }
        });
    }

    private void setText(String inputContent, boolean isSilent) {
        if (TextUtils.isEmpty((CharSequence)inputContent)) {
            return;
        }
        for (int i = 0; i < this.mPwdTextViews.length; ++i) {
            PwdTextView tv = this.mPwdTextViews[i];
            if (!"".equals(tv.getText().toString().trim())) continue;
            if (this.mIsPwd) {
                tv.drawPassword(this.mPwdRadius);
            }
            tv.setText(inputContent);
            tv.setBackgroundDrawable(this.mBackgroundNormal);
            if (i < this.mEtNumber - 1) {
                this.mPwdTextViews[i + 1].setBackgroundDrawable(this.mBackgroundFocus);
                if (this.mOnInputListener == null || isSilent) break;
                this.mOnInputListener.onChange(this.getInputValue());
                break;
            }
            if (i != this.mEtNumber - 1 || this.mOnInputListener == null || isSilent) break;
            this.mOnInputListener.onComplete(this.getInputValue());
            break;
        }
    }

    private void onKeyDelete() {
        for (int i = this.mPwdTextViews.length - 1; i >= 0; --i) {
            PwdTextView tv = this.mPwdTextViews[i];
            if ("".equals(tv.getText().toString().trim())) continue;
            if (this.mIsPwd) {
                tv.clearPassword();
            }
            tv.setText("");
            tv.setBackgroundDrawable(this.mBackgroundFocus);
            if (i < this.mEtNumber - 1) {
                this.mPwdTextViews[i + 1].setBackgroundDrawable(this.mBackgroundNormal);
                if (i == 0) {
                    if (this.mOnInputListener == null) break;
                    this.mOnInputListener.onClear();
                    break;
                }
                if (this.mOnInputListener == null) break;
                this.mOnInputListener.onChange(this.getInputValue());
                break;
            }
            if (i != this.mEtNumber - 1 || this.mOnInputListener == null) break;
            this.mOnInputListener.onChange(this.getInputValue());
            break;
        }
    }

    public String getInputValue() {
        StringBuilder sb = new StringBuilder();
        for (PwdTextView tv : this.mPwdTextViews) {
            sb.append(tv.getText().toString().trim());
        }
        return sb.toString();
    }

    public void clearInputValue() {
        for (int i = 0; i < this.mPwdTextViews.length; ++i) {
            if (i == 0) {
                this.mPwdTextViews[i].setBackgroundDrawable(this.mBackgroundFocus);
            } else {
                this.mPwdTextViews[i].setBackgroundDrawable(this.mBackgroundNormal);
            }
            if (this.mIsPwd) {
                this.mPwdTextViews[i].clearPassword();
            }
            this.mPwdTextViews[i].setText("");
        }
        if (this.mOnInputListener != null) {
            this.mOnInputListener.onClear();
        }
    }

    public void setEtNumber(int etNumber) {
        this.mEtNumber = etNumber;
        this.mEditText.removeTextChangedListener(this.mTextWatcher);
        this.mLlContainer.removeAllViews();
        if (this.mIsDivideEqually) {
            this.refreshEditSizeWhenDivideEqually();
        }
        this.initView(this.getContext());
    }

    public int getEtNumber() {
        return this.mEtNumber;
    }

    public void setPwdMode(boolean isPwdMode) {
        this.mIsPwd = isPwdMode;
    }

    public EditText getEditText() {
        return this.mEditText;
    }

    public void setOnInputListener(OnInputListener onInputListener) {
        this.mOnInputListener = onInputListener;
    }

    public float dp2px(float dpValue, Context context) {
        return TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public float sp2px(float spValue, Context context) {
        return TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    private class InputNumberTextWatcher
    implements TextWatcher {
        private InputNumberTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable editable) {
            String inputStr = editable.toString();
            if (!TextUtils.isEmpty((CharSequence)inputStr)) {
                String[] strArray = inputStr.split("");
                for (int i = 0; i < strArray.length && i <= VerifyCodeEditText.this.mEtNumber; ++i) {
                    VerifyCodeEditText.this.setText(strArray[i], false);
                    VerifyCodeEditText.this.mEditText.setText("");
                }
            }
        }
    }

    public static interface OnInputListener {
        public void onComplete(String var1);

        public void onChange(String var1);

        public void onClear();
    }
}

