/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.edittext.materialedittext;

import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.DrawableUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.utils.Utils;
import com.xuexiang.xui.widget.edittext.AsteriskPasswordTransformationMethod;
import com.xuexiang.xui.widget.edittext.materialedittext.validation.METLengthChecker;
import com.xuexiang.xui.widget.edittext.materialedittext.validation.METValidator;
import com.xuexiang.xui.widget.edittext.materialedittext.validation.NotAllowEmptyValidator;
import com.xuexiang.xui.widget.edittext.materialedittext.validation.RegexpValidator;
import io.github.inflationx.calligraphy3.HasTypeface;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Keep
public class MaterialEditText
extends AppCompatEditText
implements HasTypeface {
    public static final int FLOATING_LABEL_NONE = 0;
    public static final int FLOATING_LABEL_NORMAL = 1;
    public static final int FLOATING_LABEL_HIGHLIGHT = 2;
    private int extraPaddingTop;
    private int extraPaddingBottom;
    private int extraPaddingLeft;
    private int extraPaddingRight;
    private int floatingLabelTextSize;
    private int floatingLabelTextColor;
    private int bottomTextSize;
    private int floatingLabelPadding;
    private int bottomSpacing;
    private boolean floatingLabelEnabled;
    private boolean highlightFloatingLabel;
    private int baseColor;
    private int innerPaddingTop;
    private int innerPaddingBottom;
    private int innerPaddingLeft;
    private int innerPaddingRight;
    private int primaryColor;
    private int errorColor;
    private int minCharacters;
    private int maxCharacters;
    private boolean singleLineEllipsis;
    private boolean floatingLabelAlwaysShown;
    private boolean helperTextAlwaysShown;
    private int bottomEllipsisSize;
    private int minBottomLines;
    private int minBottomTextLines;
    private float currentBottomLines;
    private float bottomLines;
    private String helperText;
    private int helperTextColor = -1;
    private String tempErrorText;
    private float floatingLabelFraction;
    private boolean floatingLabelShown;
    private float focusFraction;
    private Typeface accentTypeface;
    private CharSequence floatingLabelText;
    private boolean hideUnderline;
    private int underlineColor;
    private int underlineHeight;
    private int underlineHeightFocused;
    private boolean autoValidate;
    private boolean charactersCountValid;
    private boolean floatingLabelAnimating;
    private boolean checkCharactersCountAtBeginning;
    private Bitmap[] iconLeftBitmaps;
    private Bitmap[] iconRightBitmaps;
    private Bitmap[] clearButtonBitmaps;
    private Bitmap[] showPwIconBitmaps;
    private Bitmap[] hidePwIconBitmaps;
    private boolean passwordVisible;
    private boolean validateOnFocusLost;
    private boolean showClearButton;
    private boolean showPasswordButton;
    private boolean firstShown;
    private int iconSize;
    private int iconOuterWidth;
    private int iconOuterHeight;
    private int iconPadding;
    private boolean actionButtonTouched;
    private boolean actionButtonClicking;
    private ColorStateList textColorStateList;
    private ColorStateList textColorHintStateList;
    private ArgbEvaluator focusEvaluator = new ArgbEvaluator();
    Paint paint = new Paint(1);
    TextPaint textPaint = new TextPaint(1);
    StaticLayout textLayout;
    ObjectAnimator labelAnimator;
    ObjectAnimator labelFocusAnimator;
    ObjectAnimator bottomLinesAnimator;
    View.OnFocusChangeListener innerFocusChangeListener;
    View.OnFocusChangeListener outerFocusChangeListener;
    private List<METValidator> validators = new ArrayList<METValidator>();
    private METLengthChecker lengthChecker;
    private PasswordTransformationMethod mTransformationMethod;

    public MaterialEditText(Context context) {
        this(context, null);
    }

    public MaterialEditText(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.MaterialEditTextStyle);
    }

    public MaterialEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        String fontPathForView;
        this.iconSize = this.getPixel(32);
        this.iconOuterWidth = this.getPixel(24);
        this.iconOuterHeight = this.getPixel(32);
        this.bottomSpacing = this.getResources().getDimensionPixelSize(R.dimen.default_edittext_components_spacing);
        this.bottomEllipsisSize = this.getResources().getDimensionPixelSize(R.dimen.default_bottom_ellipsis_height);
        int defaultBaseColor = -16777216;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaterialEditText, defStyleAttr, 0);
        this.textColorStateList = ResUtils.getColorStateListAttrRes(context, typedArray, R.styleable.MaterialEditText_met_textColor);
        this.textColorHintStateList = ResUtils.getColorStateListAttrRes(context, typedArray, R.styleable.MaterialEditText_met_textColorHint);
        this.baseColor = typedArray.getColor(R.styleable.MaterialEditText_met_baseColor, defaultBaseColor);
        this.primaryColor = typedArray.getColor(R.styleable.MaterialEditText_met_primaryColor, ThemeUtils.resolveColor(this.getContext(), R.attr.colorPrimary, this.baseColor));
        this.setFloatingLabelInternal(typedArray.getInt(R.styleable.MaterialEditText_met_floatingLabel, 0));
        this.errorColor = typedArray.getColor(R.styleable.MaterialEditText_met_errorColor, ThemeUtils.resolveColor(this.getContext(), R.attr.xui_config_color_error_text));
        boolean allowEmpty = typedArray.getBoolean(R.styleable.MaterialEditText_met_allowEmpty, true);
        if (!allowEmpty) {
            String errorEmpty = typedArray.getString(R.styleable.MaterialEditText_met_errorEmpty);
            if (!TextUtils.isEmpty((CharSequence)errorEmpty)) {
                this.validators.add(new NotAllowEmptyValidator(errorEmpty));
            } else {
                this.validators.add(new NotAllowEmptyValidator(ResUtils.getString(context, R.string.xui_met_not_allow_empty)));
            }
        }
        this.minCharacters = typedArray.getInt(R.styleable.MaterialEditText_met_minCharacters, 0);
        this.maxCharacters = typedArray.getInt(R.styleable.MaterialEditText_met_maxCharacters, 0);
        this.singleLineEllipsis = typedArray.getBoolean(R.styleable.MaterialEditText_met_singleLineEllipsis, false);
        this.helperText = typedArray.getString(R.styleable.MaterialEditText_met_helperText);
        this.helperTextColor = typedArray.getColor(R.styleable.MaterialEditText_met_helperTextColor, -1);
        this.minBottomTextLines = typedArray.getInt(R.styleable.MaterialEditText_met_minBottomTextLines, 0);
        String fontPathForAccent = typedArray.getString(R.styleable.MaterialEditText_met_accentTypeface);
        if (fontPathForAccent != null) {
            this.accentTypeface = XUI.getDefaultTypeface(fontPathForAccent);
            this.textPaint.setTypeface(this.accentTypeface);
        }
        if ((fontPathForView = typedArray.getString(R.styleable.MaterialEditText_met_typeface)) != null) {
            Typeface typeface = XUI.getDefaultTypeface(fontPathForView);
            this.setTypeface(typeface);
        }
        this.floatingLabelText = typedArray.getString(R.styleable.MaterialEditText_met_floatingLabelText);
        if (this.floatingLabelText == null) {
            this.floatingLabelText = this.getHint();
        }
        this.floatingLabelPadding = typedArray.getDimensionPixelSize(R.styleable.MaterialEditText_met_floatingLabelPadding, this.bottomSpacing);
        this.floatingLabelTextSize = typedArray.getDimensionPixelSize(R.styleable.MaterialEditText_met_floatingLabelTextSize, this.getResources().getDimensionPixelSize(R.dimen.default_floating_label_text_size));
        this.floatingLabelTextColor = typedArray.getColor(R.styleable.MaterialEditText_met_floatingLabelTextColor, -1);
        this.floatingLabelAnimating = typedArray.getBoolean(R.styleable.MaterialEditText_met_floatingLabelAnimating, true);
        this.bottomTextSize = typedArray.getDimensionPixelSize(R.styleable.MaterialEditText_met_bottomTextSize, this.getResources().getDimensionPixelSize(R.dimen.default_bottom_text_size));
        this.hideUnderline = typedArray.getBoolean(R.styleable.MaterialEditText_met_hideUnderline, false);
        this.underlineColor = typedArray.getColor(R.styleable.MaterialEditText_met_underlineColor, -1);
        this.underlineHeight = typedArray.getDimensionPixelSize(R.styleable.MaterialEditText_met_underlineHeight, this.getPixel(1));
        this.underlineHeightFocused = typedArray.getDimensionPixelSize(R.styleable.MaterialEditText_met_underlineHeightFocused, this.getPixel(2));
        this.autoValidate = typedArray.getBoolean(R.styleable.MaterialEditText_met_autoValidate, false);
        this.iconLeftBitmaps = this.generateIconBitmaps(typedArray.getResourceId(R.styleable.MaterialEditText_met_iconLeft, -1));
        this.iconRightBitmaps = this.generateIconBitmaps(typedArray.getResourceId(R.styleable.MaterialEditText_met_iconRight, -1));
        this.showClearButton = typedArray.getBoolean(R.styleable.MaterialEditText_met_clearButton, false);
        this.clearButtonBitmaps = this.generateIconBitmaps(DrawableUtils.getBitmapByDrawableId(this.getContext(), R.drawable.xui_ic_default_clear_btn));
        this.showPasswordButton = typedArray.getBoolean(R.styleable.MaterialEditText_met_passWordButton, false);
        boolean isAsteriskStyle = typedArray.getBoolean(R.styleable.MaterialEditText_met_isAsteriskStyle, false);
        this.mTransformationMethod = isAsteriskStyle ? AsteriskPasswordTransformationMethod.getInstance() : PasswordTransformationMethod.getInstance();
        if (this.showPasswordButton) {
            this.handleSwitchPasswordInputVisibility();
        }
        this.showPwIconBitmaps = this.generateIconBitmaps(DrawableUtils.getBitmapByDrawableId(this.getContext(), R.drawable.pet_icon_visibility_24dp));
        this.hidePwIconBitmaps = this.generateIconBitmaps(DrawableUtils.getBitmapByDrawableId(this.getContext(), R.drawable.pet_icon_visibility_off_24dp));
        String regexp = typedArray.getString(R.styleable.MaterialEditText_met_regexp);
        if (!TextUtils.isEmpty((CharSequence)regexp)) {
            String errorMessage = typedArray.getString(R.styleable.MaterialEditText_met_errorMessage);
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                this.validators.add(new RegexpValidator(errorMessage, regexp));
            } else {
                this.validators.add(new RegexpValidator(ResUtils.getString(context, R.string.xui_met_input_error), regexp));
            }
        }
        this.iconPadding = typedArray.getDimensionPixelSize(R.styleable.MaterialEditText_met_iconPadding, this.getPixel(8));
        this.floatingLabelAlwaysShown = typedArray.getBoolean(R.styleable.MaterialEditText_met_floatingLabelAlwaysShown, false);
        this.helperTextAlwaysShown = typedArray.getBoolean(R.styleable.MaterialEditText_met_helperTextAlwaysShown, false);
        this.validateOnFocusLost = typedArray.getBoolean(R.styleable.MaterialEditText_met_validateOnFocusLost, false);
        this.checkCharactersCountAtBeginning = typedArray.getBoolean(R.styleable.MaterialEditText_met_checkCharactersCountAtBeginning, true);
        typedArray.recycle();
        int[] paddings = new int[]{16842965, 16842966, 16842967, 16842968, 16842969};
        TypedArray paddingsTypedArray = context.obtainStyledAttributes(attrs, paddings);
        int padding = paddingsTypedArray.getDimensionPixelSize(0, 0);
        this.innerPaddingLeft = paddingsTypedArray.getDimensionPixelSize(1, padding);
        this.innerPaddingTop = paddingsTypedArray.getDimensionPixelSize(2, padding);
        this.innerPaddingRight = paddingsTypedArray.getDimensionPixelSize(3, padding);
        this.innerPaddingBottom = paddingsTypedArray.getDimensionPixelSize(4, padding);
        paddingsTypedArray.recycle();
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(null);
        } else {
            this.setBackgroundDrawable(null);
        }
        if (this.singleLineEllipsis) {
            TransformationMethod transformationMethod = this.getTransformationMethod();
            this.setSingleLine();
            this.setTransformationMethod(transformationMethod);
        }
        this.initMinBottomLines();
        this.initPadding();
        this.initText();
        this.initFloatingLabel();
        this.initTextWatcher();
        this.checkCharactersCount();
    }

    private void initText() {
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            Editable text = this.getText();
            this.setText(null);
            this.resetHintTextColor();
            this.setText((CharSequence)text);
            this.setSelection(text != null ? text.length() : 0);
            this.floatingLabelFraction = 1.0f;
            this.floatingLabelShown = true;
        } else {
            this.resetHintTextColor();
        }
        this.resetTextColor();
    }

    private void initTextWatcher() {
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                MaterialEditText.this.checkCharactersCount();
                if (MaterialEditText.this.autoValidate) {
                    MaterialEditText.this.validate();
                } else {
                    MaterialEditText.this.setError(null);
                }
                MaterialEditText.this.postInvalidate();
            }
        });
    }

    public MaterialEditText setIconLeft(@DrawableRes int res) {
        this.iconLeftBitmaps = this.generateIconBitmaps(res);
        this.initPadding();
        return this;
    }

    public MaterialEditText setIconLeft(Drawable drawable2) {
        this.iconLeftBitmaps = this.generateIconBitmaps(drawable2);
        this.initPadding();
        return this;
    }

    public MaterialEditText setIconLeft(Bitmap bitmap) {
        this.iconLeftBitmaps = this.generateIconBitmaps(bitmap);
        this.initPadding();
        return this;
    }

    public MaterialEditText setIconRight(@DrawableRes int res) {
        this.iconRightBitmaps = this.generateIconBitmaps(res);
        this.initPadding();
        return this;
    }

    public MaterialEditText setIconRight(Drawable drawable2) {
        this.iconRightBitmaps = this.generateIconBitmaps(drawable2);
        this.initPadding();
        return this;
    }

    public MaterialEditText setIconRight(Bitmap bitmap) {
        this.iconRightBitmaps = this.generateIconBitmaps(bitmap);
        this.initPadding();
        return this;
    }

    public boolean isShowClearButton() {
        return this.showClearButton;
    }

    public boolean isShowPasswordButton() {
        return this.showPasswordButton;
    }

    public MaterialEditText setShowClearButton(boolean show) {
        this.showClearButton = show;
        this.correctPaddings();
        return this;
    }

    public MaterialEditText setPasswordTransformationMethod(PasswordTransformationMethod transformationMethod) {
        this.mTransformationMethod = transformationMethod;
        return this;
    }

    private Bitmap[] generateIconBitmaps(@DrawableRes int origin) {
        if (origin == -1) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        int size = Math.max(options.outWidth, options.outHeight);
        options.inSampleSize = size > this.iconSize ? size / this.iconSize : 1;
        options.inJustDecodeBounds = false;
        return this.generateIconBitmaps(BitmapFactory.decodeResource((Resources)this.getResources(), (int)origin, (BitmapFactory.Options)options));
    }

    private Bitmap[] generateIconBitmaps(Drawable drawable2) {
        if (drawable2 == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return this.generateIconBitmaps(Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.iconSize, (int)this.iconSize, (boolean)false));
    }

    private Bitmap[] generateIconBitmaps(Bitmap origin) {
        if (origin == null) {
            return null;
        }
        Bitmap[] iconBitmaps = new Bitmap[4];
        origin = this.scaleIcon(origin);
        iconBitmaps[0] = origin.copy(Bitmap.Config.ARGB_8888, true);
        Canvas canvas = new Canvas(iconBitmaps[0]);
        canvas.drawColor(this.baseColor & 0xFFFFFF | (Utils.isLight(this.baseColor) ? -16777216 : -1979711488), PorterDuff.Mode.SRC_IN);
        iconBitmaps[1] = origin.copy(Bitmap.Config.ARGB_8888, true);
        canvas = new Canvas(iconBitmaps[1]);
        canvas.drawColor(this.primaryColor, PorterDuff.Mode.SRC_IN);
        iconBitmaps[2] = origin.copy(Bitmap.Config.ARGB_8888, true);
        canvas = new Canvas(iconBitmaps[2]);
        canvas.drawColor(this.baseColor & 0xFFFFFF | (Utils.isLight(this.baseColor) ? 0x4C000000 : 0x42000000), PorterDuff.Mode.SRC_IN);
        iconBitmaps[3] = origin.copy(Bitmap.Config.ARGB_8888, true);
        canvas = new Canvas(iconBitmaps[3]);
        canvas.drawColor(this.errorColor, PorterDuff.Mode.SRC_IN);
        return iconBitmaps;
    }

    private Bitmap scaleIcon(Bitmap origin) {
        int height;
        int width = origin.getWidth();
        int size = Math.max(width, height = origin.getHeight());
        if (size == this.iconSize) {
            return origin;
        }
        if (size > this.iconSize) {
            int scaledHeight;
            int scaledWidth;
            if (width > this.iconSize) {
                scaledWidth = this.iconSize;
                scaledHeight = (int)((float)this.iconSize * ((float)height / (float)width));
            } else {
                scaledHeight = this.iconSize;
                scaledWidth = (int)((float)this.iconSize * ((float)width / (float)height));
            }
            return Bitmap.createScaledBitmap((Bitmap)origin, (int)scaledWidth, (int)scaledHeight, (boolean)false);
        }
        return origin;
    }

    public float getFloatingLabelFraction() {
        return this.floatingLabelFraction;
    }

    public MaterialEditText setFloatingLabelFraction(float floatingLabelFraction) {
        this.floatingLabelFraction = floatingLabelFraction;
        this.invalidate();
        return this;
    }

    public float getFocusFraction() {
        return this.focusFraction;
    }

    public MaterialEditText setFocusFraction(float focusFraction) {
        this.focusFraction = focusFraction;
        this.invalidate();
        return this;
    }

    public float getCurrentBottomLines() {
        return this.currentBottomLines;
    }

    public MaterialEditText setCurrentBottomLines(float currentBottomLines) {
        this.currentBottomLines = currentBottomLines;
        this.initPadding();
        return this;
    }

    public boolean isFloatingLabelAlwaysShown() {
        return this.floatingLabelAlwaysShown;
    }

    public MaterialEditText setFloatingLabelAlwaysShown(boolean floatingLabelAlwaysShown) {
        this.floatingLabelAlwaysShown = floatingLabelAlwaysShown;
        this.invalidate();
        return this;
    }

    public boolean isHelperTextAlwaysShown() {
        return this.helperTextAlwaysShown;
    }

    public MaterialEditText setHelperTextAlwaysShown(boolean helperTextAlwaysShown) {
        this.helperTextAlwaysShown = helperTextAlwaysShown;
        this.invalidate();
        return this;
    }

    @Nullable
    public Typeface getAccentTypeface() {
        return this.accentTypeface;
    }

    public MaterialEditText setAccentTypeface(Typeface accentTypeface) {
        this.accentTypeface = accentTypeface;
        this.textPaint.setTypeface(accentTypeface);
        this.postInvalidate();
        return this;
    }

    public boolean isHideUnderline() {
        return this.hideUnderline;
    }

    public MaterialEditText setHideUnderline(boolean hideUnderline) {
        this.hideUnderline = hideUnderline;
        this.initPadding();
        this.postInvalidate();
        return this;
    }

    public int getUnderlineColor() {
        return this.underlineColor;
    }

    public MaterialEditText setUnderlineColor(int color2) {
        this.underlineColor = color2;
        this.postInvalidate();
        return this;
    }

    public CharSequence getFloatingLabelText() {
        return this.floatingLabelText;
    }

    public MaterialEditText setFloatingLabelText(@Nullable CharSequence floatingLabelText) {
        this.floatingLabelText = floatingLabelText == null ? this.getHint() : floatingLabelText;
        this.postInvalidate();
        return this;
    }

    public int getFloatingLabelTextSize() {
        return this.floatingLabelTextSize;
    }

    public MaterialEditText setFloatingLabelTextSize(int size) {
        this.floatingLabelTextSize = size;
        this.initPadding();
        return this;
    }

    public int getFloatingLabelTextColor() {
        return this.floatingLabelTextColor;
    }

    public MaterialEditText setFloatingLabelTextColor(int color2) {
        this.floatingLabelTextColor = color2;
        this.postInvalidate();
        return this;
    }

    public int getBottomTextSize() {
        return this.bottomTextSize;
    }

    public void setBottomTextSize(int size) {
        this.bottomTextSize = size;
        this.initPadding();
    }

    private int getPixel(int dp) {
        return DensityUtils.dp2px(this.getContext(), dp);
    }

    private void initPadding() {
        this.extraPaddingTop = this.floatingLabelEnabled ? this.floatingLabelTextSize + this.floatingLabelPadding : this.floatingLabelPadding;
        this.textPaint.setTextSize((float)this.bottomTextSize);
        Paint.FontMetrics textMetrics = this.textPaint.getFontMetrics();
        this.extraPaddingBottom = (int)((textMetrics.descent - textMetrics.ascent) * this.currentBottomLines) + (this.hideUnderline ? this.bottomSpacing : this.bottomSpacing * 2);
        this.extraPaddingLeft = this.getStartIcon() == null ? 0 : this.iconOuterWidth + this.iconPadding;
        this.extraPaddingRight = this.getEndIcon() == null ? 0 : this.iconOuterWidth + this.iconPadding;
        this.correctPaddings();
    }

    private void initMinBottomLines() {
        boolean extendBottom;
        boolean bl = extendBottom = this.minCharacters > 0 || this.maxCharacters > 0 || this.singleLineEllipsis || this.tempErrorText != null || this.helperText != null;
        this.minBottomLines = this.minBottomTextLines > 0 ? this.minBottomTextLines : (extendBottom ? 1 : 0);
        this.currentBottomLines = this.minBottomLines;
    }

    @Deprecated
    public final void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
    }

    public MaterialEditText setPaddings(int left, int top, int right, int bottom) {
        this.innerPaddingTop = top;
        this.innerPaddingBottom = bottom;
        this.innerPaddingLeft = left;
        this.innerPaddingRight = right;
        this.correctPaddings();
        return this;
    }

    private void correctPaddings() {
        int buttonsWidthLeft = 0;
        int buttonsWidthRight = 0;
        int buttonsWidth = this.iconOuterWidth * this.getButtonsCount();
        if (this.isRTL()) {
            buttonsWidthLeft = buttonsWidth;
        } else {
            buttonsWidthRight = buttonsWidth;
        }
        super.setPaddingRelative(this.innerPaddingLeft + this.extraPaddingLeft + buttonsWidthLeft, this.innerPaddingTop + this.extraPaddingTop, this.innerPaddingRight + this.extraPaddingRight + buttonsWidthRight, this.innerPaddingBottom + this.extraPaddingBottom);
    }

    private int getButtonsCount() {
        return this.isShowClearButton() || this.isShowPasswordButton() ? 1 : 0;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.firstShown) {
            this.firstShown = true;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.adjustBottomLines();
        }
    }

    private boolean adjustBottomLines() {
        int destBottomLines;
        if (this.getWidth() == 0) {
            return false;
        }
        this.textPaint.setTextSize((float)this.bottomTextSize);
        if (this.tempErrorText != null || this.helperText != null) {
            Layout.Alignment alignment = (this.getGravity() & 0x800005) == 0x800005 || this.isRTL() ? Layout.Alignment.ALIGN_OPPOSITE : ((this.getGravity() & 0x800003) == 0x800003 ? Layout.Alignment.ALIGN_NORMAL : Layout.Alignment.ALIGN_CENTER);
            this.textLayout = new StaticLayout((CharSequence)(this.tempErrorText != null ? this.tempErrorText : this.helperText), this.textPaint, this.getWidth() - this.getBottomTextLeftOffset() - this.getBottomTextRightOffset() - this.getPaddingLeft() - this.getPaddingRight(), alignment, 1.0f, 0.0f, true);
            destBottomLines = Math.max(this.textLayout.getLineCount(), this.minBottomTextLines);
        } else {
            destBottomLines = this.minBottomLines;
        }
        if (this.bottomLines != (float)destBottomLines) {
            this.getBottomLinesAnimator(destBottomLines).start();
        }
        this.bottomLines = destBottomLines;
        return true;
    }

    public int getInnerPaddingTop() {
        return this.innerPaddingTop;
    }

    public int getInnerPaddingBottom() {
        return this.innerPaddingBottom;
    }

    public int getInnerPaddingLeft() {
        return this.innerPaddingLeft;
    }

    public int getInnerPaddingRight() {
        return this.innerPaddingRight;
    }

    private void initFloatingLabel() {
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (MaterialEditText.this.floatingLabelEnabled) {
                    if (s.length() == 0) {
                        if (MaterialEditText.this.floatingLabelShown) {
                            MaterialEditText.this.floatingLabelShown = false;
                            MaterialEditText.this.getLabelAnimator().reverse();
                        }
                    } else if (!MaterialEditText.this.floatingLabelShown) {
                        MaterialEditText.this.floatingLabelShown = true;
                        MaterialEditText.this.getLabelAnimator().start();
                    }
                }
            }
        });
        this.innerFocusChangeListener = new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (MaterialEditText.this.floatingLabelEnabled && MaterialEditText.this.highlightFloatingLabel) {
                    if (hasFocus) {
                        MaterialEditText.this.getLabelFocusAnimator().start();
                    } else {
                        MaterialEditText.this.getLabelFocusAnimator().reverse();
                    }
                }
                if (MaterialEditText.this.validateOnFocusLost && !hasFocus) {
                    MaterialEditText.this.validate();
                }
                if (MaterialEditText.this.outerFocusChangeListener != null) {
                    MaterialEditText.this.outerFocusChangeListener.onFocusChange(v, hasFocus);
                }
            }
        };
        super.setOnFocusChangeListener(this.innerFocusChangeListener);
    }

    public boolean isValidateOnFocusLost() {
        return this.validateOnFocusLost;
    }

    public MaterialEditText setValidateOnFocusLost(boolean validate) {
        this.validateOnFocusLost = validate;
        return this;
    }

    public MaterialEditText setBaseColor(int color2) {
        if (this.baseColor != color2) {
            this.baseColor = color2;
        }
        this.initText();
        this.postInvalidate();
        return this;
    }

    public MaterialEditText setPrimaryColor(int color2) {
        this.primaryColor = color2;
        this.postInvalidate();
        return this;
    }

    public MaterialEditText setMetTextColor(int color2) {
        this.textColorStateList = ColorStateList.valueOf((int)color2);
        this.resetTextColor();
        return this;
    }

    public MaterialEditText setMetTextColor(ColorStateList colors) {
        this.textColorStateList = colors;
        this.resetTextColor();
        return this;
    }

    private void resetTextColor() {
        if (this.textColorStateList == null) {
            this.textColorStateList = new ColorStateList((int[][])new int[][]{{16842910}, EMPTY_STATE_SET}, new int[]{this.baseColor & 0xFFFFFF | 0xDF000000, this.baseColor & 0xFFFFFF | 0x44000000});
            this.setTextColor(this.textColorStateList);
        } else {
            this.setTextColor(this.textColorStateList);
        }
    }

    public MaterialEditText setMetHintTextColor(int color2) {
        this.textColorHintStateList = ColorStateList.valueOf((int)color2);
        this.resetHintTextColor();
        return this;
    }

    public MaterialEditText setMetHintTextColor(ColorStateList colors) {
        this.textColorHintStateList = colors;
        this.resetHintTextColor();
        return this;
    }

    private void resetHintTextColor() {
        if (this.textColorHintStateList == null) {
            this.setHintTextColor(this.baseColor & 0xFFFFFF | 0x44000000);
        } else {
            this.setHintTextColor(this.textColorHintStateList);
        }
    }

    private void setFloatingLabelInternal(int mode) {
        switch (mode) {
            case 1: {
                this.floatingLabelEnabled = true;
                this.highlightFloatingLabel = false;
                break;
            }
            case 2: {
                this.floatingLabelEnabled = true;
                this.highlightFloatingLabel = true;
                break;
            }
            default: {
                this.floatingLabelEnabled = false;
                this.highlightFloatingLabel = false;
            }
        }
    }

    public MaterialEditText setFloatingLabel(int mode) {
        this.setFloatingLabelInternal(mode);
        this.initPadding();
        return this;
    }

    public int getFloatingLabelPadding() {
        return this.floatingLabelPadding;
    }

    public MaterialEditText setFloatingLabelPadding(int padding) {
        this.floatingLabelPadding = padding;
        this.postInvalidate();
        return this;
    }

    public boolean isFloatingLabelAnimating() {
        return this.floatingLabelAnimating;
    }

    public MaterialEditText setFloatingLabelAnimating(boolean animating) {
        this.floatingLabelAnimating = animating;
        return this;
    }

    public MaterialEditText setSingleLineEllipsis() {
        return this.setSingleLineEllipsis(true);
    }

    public MaterialEditText setSingleLineEllipsis(boolean enabled) {
        this.singleLineEllipsis = enabled;
        this.initMinBottomLines();
        this.initPadding();
        this.postInvalidate();
        return this;
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public MaterialEditText setMaxCharacters(int max) {
        this.maxCharacters = max;
        this.initMinBottomLines();
        this.initPadding();
        this.postInvalidate();
        return this;
    }

    public int getMinCharacters() {
        return this.minCharacters;
    }

    public MaterialEditText setMinCharacters(int min) {
        this.minCharacters = min;
        this.initMinBottomLines();
        this.initPadding();
        this.postInvalidate();
        return this;
    }

    public int getMinBottomTextLines() {
        return this.minBottomTextLines;
    }

    public MaterialEditText setMinBottomTextLines(int lines) {
        this.minBottomTextLines = lines;
        this.initMinBottomLines();
        this.initPadding();
        this.postInvalidate();
        return this;
    }

    public boolean isAutoValidate() {
        return this.autoValidate;
    }

    public MaterialEditText setAutoValidate(boolean autoValidate) {
        this.autoValidate = autoValidate;
        if (autoValidate) {
            this.validate();
        }
        return this;
    }

    public int getErrorColor() {
        return this.errorColor;
    }

    public MaterialEditText setErrorColor(int color2) {
        this.errorColor = color2;
        this.postInvalidate();
        return this;
    }

    public MaterialEditText setHelperText(CharSequence helperText) {
        String string2 = this.helperText = helperText == null ? null : helperText.toString();
        if (this.adjustBottomLines()) {
            this.postInvalidate();
        }
        return this;
    }

    public String getHelperText() {
        return this.helperText;
    }

    public int getHelperTextColor() {
        return this.helperTextColor;
    }

    public MaterialEditText setHelperTextColor(int color2) {
        this.helperTextColor = color2;
        this.postInvalidate();
        return this;
    }

    public MaterialEditText setAllowEmpty(boolean allowEmpty, String errorEmpty) {
        boolean updateError = false;
        Iterator<METValidator> it = this.validators.iterator();
        while (it.hasNext()) {
            METValidator item = it.next();
            if (!(item instanceof NotAllowEmptyValidator)) continue;
            if (allowEmpty) {
                it.remove();
                break;
            }
            if (!TextUtils.isEmpty((CharSequence)errorEmpty)) {
                item.setErrorMessage(errorEmpty);
            } else {
                item.setErrorMessage(ResUtils.getString(this.getContext(), R.string.xui_met_not_allow_empty));
            }
            updateError = true;
            break;
        }
        if (!allowEmpty && !updateError) {
            if (!TextUtils.isEmpty((CharSequence)errorEmpty)) {
                this.validators.add(new NotAllowEmptyValidator(errorEmpty));
            } else {
                this.validators.add(new NotAllowEmptyValidator(ResUtils.getString(this.getContext(), R.string.xui_met_not_allow_empty)));
            }
        }
        return this;
    }

    public void setError(CharSequence errorText) {
        String string2 = this.tempErrorText = errorText == null ? null : errorText.toString();
        if (this.adjustBottomLines()) {
            this.postInvalidate();
        }
    }

    public CharSequence getError() {
        return this.tempErrorText;
    }

    private boolean isInternalValid() {
        return this.tempErrorText == null && this.isCharactersCountValid();
    }

    @Deprecated
    public boolean isValid(String regex) {
        if (regex == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher((CharSequence)this.getText());
        return matcher.matches();
    }

    @Deprecated
    public boolean validate(String regex, CharSequence errorText) {
        boolean isValid = this.isValid(regex);
        if (!isValid) {
            this.setError(errorText);
        }
        this.postInvalidate();
        return isValid;
    }

    public boolean validateWith(@NonNull METValidator validator) {
        Editable text;
        boolean isValid = validator.isValid((CharSequence)text, (text = this.getText()).length() == 0);
        if (!isValid) {
            this.setError(validator.getErrorMessage());
        }
        this.postInvalidate();
        return isValid;
    }

    public boolean validate() {
        if (this.validators == null || this.validators.isEmpty()) {
            return true;
        }
        Editable text = this.getText();
        boolean isEmpty = TextUtils.isEmpty((CharSequence)text);
        boolean isValid = true;
        for (METValidator validator : this.validators) {
            if (isValid = isValid && validator.isValid((CharSequence)text, isEmpty)) continue;
            this.setError(validator.getErrorMessage());
            break;
        }
        if (isValid) {
            this.setError(null);
        }
        this.postInvalidate();
        return isValid;
    }

    public boolean hasValidators() {
        return this.validators != null && !this.validators.isEmpty();
    }

    public MaterialEditText addValidator(METValidator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList<METValidator>();
        }
        this.validators.add(validator);
        return this;
    }

    public MaterialEditText clearValidators() {
        if (this.validators != null) {
            this.validators.clear();
        }
        return this;
    }

    @Nullable
    public List<METValidator> getValidators() {
        return this.validators;
    }

    public MaterialEditText setLengthChecker(METLengthChecker lengthChecker) {
        this.lengthChecker = lengthChecker;
        return this;
    }

    public void clear() {
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            this.setText(null);
        }
    }

    public String getEditValue() {
        return this.getEditableText().toString().trim();
    }

    public void setEnabled(boolean enabled) {
        super.setFocusable(enabled);
        super.setFocusableInTouchMode(enabled);
        super.setEnabled(enabled);
    }

    public boolean isEmpty() {
        return TextUtils.isEmpty((CharSequence)this.getEditValue());
    }

    public boolean isNotEmpty() {
        return !TextUtils.isEmpty((CharSequence)this.getEditValue());
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener listener) {
        if (this.innerFocusChangeListener == null) {
            super.setOnFocusChangeListener(listener);
        } else {
            this.outerFocusChangeListener = listener;
        }
    }

    private ObjectAnimator getLabelAnimator() {
        if (this.labelAnimator == null) {
            this.labelAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"floatingLabelFraction", (float[])new float[]{0.0f, 1.0f});
        }
        this.labelAnimator.setDuration(this.floatingLabelAnimating ? 300L : 0L);
        return this.labelAnimator;
    }

    private ObjectAnimator getLabelFocusAnimator() {
        if (this.labelFocusAnimator == null) {
            this.labelFocusAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"focusFraction", (float[])new float[]{0.0f, 1.0f});
        }
        return this.labelFocusAnimator;
    }

    private ObjectAnimator getBottomLinesAnimator(float destBottomLines) {
        if (this.bottomLinesAnimator == null) {
            this.bottomLinesAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"currentBottomLines", (float[])new float[]{destBottomLines});
        } else {
            this.bottomLinesAnimator.cancel();
            this.bottomLinesAnimator.setFloatValues(new float[]{destBottomLines});
        }
        return this.bottomLinesAnimator;
    }

    protected void onDraw(@NonNull Canvas canvas) {
        int startX = this.getScrollX() + (this.getStartIcon() == null ? 0 : this.iconOuterWidth + this.iconPadding);
        int endX = this.getScrollX() + (this.getEndIcon() == null ? this.getWidth() : this.getWidth() - this.iconOuterWidth - this.iconPadding);
        int lineStartY = this.getScrollY() + this.getHeight() - this.getPaddingBottom();
        this.drawIcons(canvas, startX, endX, lineStartY);
        this.drawActionButton(canvas, startX, endX, lineStartY);
        lineStartY = this.drawUnderline(canvas, startX, endX, lineStartY);
        this.textPaint.setTextSize((float)this.bottomTextSize);
        Paint.FontMetrics textMetrics = this.textPaint.getFontMetrics();
        float relativeHeight = -textMetrics.ascent - textMetrics.descent;
        float bottomTextPadding = (float)this.bottomTextSize + textMetrics.ascent + textMetrics.descent;
        if (this.hasFocus() && this.hasCharactersCounter() || !this.isCharactersCountValid()) {
            this.textPaint.setColor(this.isCharactersCountValid() ? this.baseColor & 0xFFFFFF | 0x44000000 : this.errorColor);
            String charactersCounterText = this.getCharactersCounterText();
            canvas.drawText(charactersCounterText, this.isRTL() ? (float)startX : (float)(endX + this.getPaddingEnd()) - this.textPaint.measureText(charactersCounterText), (float)(lineStartY + this.bottomSpacing) + relativeHeight, (Paint)this.textPaint);
        }
        this.drawBottomText(canvas, startX, endX, lineStartY, bottomTextPadding);
        this.drawFloatingLabel(canvas, startX, endX);
        this.drawBottomEllipsis(canvas, startX, endX, lineStartY);
        super.onDraw(canvas);
    }

    private Bitmap[] getStartIcon() {
        return this.isRTL() ? this.iconRightBitmaps : this.iconLeftBitmaps;
    }

    private Bitmap[] getEndIcon() {
        return this.isRTL() ? this.iconLeftBitmaps : this.iconRightBitmaps;
    }

    private void drawIcons(@NonNull Canvas canvas, int startX, int endX, int lineStartY) {
        int iconTop;
        Bitmap icon;
        this.paint.setAlpha(255);
        if (this.getStartIcon() != null) {
            icon = this.getStartIcon()[!this.isInternalValid() ? 3 : (!this.isEnabled() ? 2 : (this.hasFocus() ? 1 : 0))];
            int iconLeft = startX - this.iconPadding - this.iconOuterWidth + (this.iconOuterWidth - icon.getWidth()) / 2;
            iconTop = lineStartY + this.bottomSpacing - this.iconOuterHeight + (this.iconOuterHeight - icon.getHeight()) / 2;
            canvas.drawBitmap(icon, (float)iconLeft, (float)iconTop, this.paint);
        }
        if (this.getEndIcon() != null) {
            icon = this.getEndIcon()[!this.isInternalValid() ? 3 : (!this.isEnabled() ? 2 : (this.hasFocus() ? 1 : 0))];
            int iconRight = endX + this.iconPadding + (this.iconOuterWidth - icon.getWidth()) / 2;
            iconTop = lineStartY + this.bottomSpacing - this.iconOuterHeight + (this.iconOuterHeight - icon.getHeight()) / 2;
            canvas.drawBitmap(icon, (float)iconRight, (float)iconTop, this.paint);
        }
    }

    private void drawActionButton(@NonNull Canvas canvas, int startX, int endX, int lineStartY) {
        if (this.hasFocus() && this.isEnabled() && !TextUtils.isEmpty((CharSequence)this.getText()) && (this.showClearButton || this.showPasswordButton)) {
            int buttonLeft;
            this.paint.setAlpha(255);
            int n = buttonLeft = this.isRTL() ? startX : endX - this.iconOuterWidth;
            Bitmap actionButtonBitmap = this.showClearButton ? this.clearButtonBitmaps[0] : (this.passwordVisible ? this.showPwIconBitmaps[0] : this.hidePwIconBitmaps[0]);
            int iconTop = lineStartY + this.bottomSpacing - this.iconOuterHeight + (this.iconOuterHeight - actionButtonBitmap.getHeight()) / 2;
            canvas.drawBitmap(actionButtonBitmap, (float)buttonLeft, (float)iconTop, this.paint);
        }
    }

    private int drawUnderline(@NonNull Canvas canvas, int startX, int endX, int lineStartY) {
        if (!this.hideUnderline) {
            lineStartY += this.bottomSpacing;
            if (!this.isInternalValid()) {
                this.paint.setColor(this.errorColor);
                canvas.drawRect((float)startX, (float)lineStartY, (float)endX, (float)(lineStartY + this.underlineHeightFocused), this.paint);
            } else if (!this.isEnabled()) {
                this.paint.setColor(this.underlineColor != -1 ? this.underlineColor : this.baseColor & 0xFFFFFF | 0x44000000);
                float interval = this.getPixel(1);
                for (float xOffset = 0.0f; xOffset < (float)this.getWidth(); xOffset += interval * 3.0f) {
                    canvas.drawRect((float)startX + xOffset, (float)lineStartY, (float)startX + xOffset + interval, (float)(lineStartY + this.underlineHeight), this.paint);
                }
            } else if (this.hasFocus()) {
                this.paint.setColor(this.primaryColor);
                canvas.drawRect((float)startX, (float)lineStartY, (float)endX, (float)(lineStartY + this.underlineHeightFocused), this.paint);
            } else {
                this.paint.setColor(this.underlineColor != -1 ? this.underlineColor : this.baseColor & 0xFFFFFF | 0x1E000000);
                canvas.drawRect((float)startX, (float)lineStartY, (float)endX, (float)(lineStartY + this.underlineHeight), this.paint);
            }
        }
        return lineStartY;
    }

    private void drawBottomText(@NonNull Canvas canvas, int startX, int endX, int lineStartY, float bottomTextPadding) {
        if (this.textLayout != null && (this.tempErrorText != null || (this.helperTextAlwaysShown || this.hasFocus()) && !TextUtils.isEmpty((CharSequence)this.helperText))) {
            this.textPaint.setColor(this.tempErrorText != null ? this.errorColor : (this.helperTextColor != -1 ? this.helperTextColor : this.baseColor & 0xFFFFFF | 0x44000000));
            canvas.save();
            if (this.isRTL()) {
                canvas.translate((float)(endX - this.textLayout.getWidth()), (float)(lineStartY + this.bottomSpacing) - bottomTextPadding);
            } else {
                canvas.translate((float)(startX + this.getBottomTextLeftOffset()), (float)(lineStartY + this.bottomSpacing) - bottomTextPadding);
            }
            this.textLayout.draw(canvas);
            canvas.restore();
        }
    }

    private void drawFloatingLabel(@NonNull Canvas canvas, int startX, int endX) {
        if (this.floatingLabelEnabled && !TextUtils.isEmpty((CharSequence)this.floatingLabelText)) {
            this.textPaint.setTextSize((float)this.floatingLabelTextSize);
            this.textPaint.setColor(((Integer)this.focusEvaluator.evaluate(this.focusFraction * (float)(this.isEnabled() ? 1 : 0), (Object)(this.floatingLabelTextColor != -1 ? this.floatingLabelTextColor : this.baseColor & 0xFFFFFF | 0x44000000), (Object)this.primaryColor)).intValue());
            float floatingLabelWidth = this.textPaint.measureText(this.floatingLabelText.toString());
            int floatingLabelStartX = (this.getGravity() & 5) == 5 || this.isRTL() ? (int)((float)endX - floatingLabelWidth) : ((this.getGravity() & 3) == 3 ? startX : startX + (int)((float)this.getInnerPaddingLeft() + ((float)(this.getWidth() - this.getInnerPaddingLeft() - this.getInnerPaddingRight()) - floatingLabelWidth) / 2.0f));
            int distance = this.floatingLabelPadding;
            int floatingLabelStartY = (int)((float)(this.innerPaddingTop + this.floatingLabelTextSize + this.floatingLabelPadding) - (float)distance * (this.floatingLabelAlwaysShown ? 1.0f : this.floatingLabelFraction) + (float)this.getScrollY());
            int alpha = (int)((this.floatingLabelAlwaysShown ? 1.0f : this.floatingLabelFraction) * 255.0f * (0.74f * this.focusFraction * (float)(this.isEnabled() ? 1 : 0) + 0.26f) * (this.floatingLabelTextColor != -1 ? 1.0f : (float)Color.alpha((int)this.floatingLabelTextColor) / 255.0f));
            this.textPaint.setAlpha(alpha);
            canvas.drawText(this.floatingLabelText.toString(), (float)floatingLabelStartX, (float)floatingLabelStartY, (Paint)this.textPaint);
        }
    }

    private void drawBottomEllipsis(@NonNull Canvas canvas, int startX, int endX, int lineStartY) {
        if (this.hasFocus() && this.singleLineEllipsis && this.getScrollX() != 0) {
            this.paint.setColor(this.isInternalValid() ? this.primaryColor : this.errorColor);
            float startY = lineStartY + this.bottomSpacing;
            int ellipsisStartX = this.isRTL() ? endX : startX;
            int signum = this.isRTL() ? -1 : 1;
            canvas.drawCircle((float)ellipsisStartX + (float)(signum * this.bottomEllipsisSize) / 2.0f, startY + (float)this.bottomEllipsisSize / 2.0f, (float)this.bottomEllipsisSize / 2.0f, this.paint);
            canvas.drawCircle((float)ellipsisStartX + (float)(signum * this.bottomEllipsisSize * 5) / 2.0f, startY + (float)this.bottomEllipsisSize / 2.0f, (float)this.bottomEllipsisSize / 2.0f, this.paint);
            canvas.drawCircle((float)ellipsisStartX + (float)(signum * this.bottomEllipsisSize * 9) / 2.0f, startY + (float)this.bottomEllipsisSize / 2.0f, (float)this.bottomEllipsisSize / 2.0f, this.paint);
        }
    }

    private boolean isRTL() {
        return this.getLayoutDirection() == 1;
    }

    private int getBottomTextLeftOffset() {
        return this.isRTL() ? this.getCharactersCounterWidth() : this.getBottomEllipsisWidth();
    }

    private int getBottomTextRightOffset() {
        return this.isRTL() ? this.getBottomEllipsisWidth() : this.getCharactersCounterWidth();
    }

    private int getCharactersCounterWidth() {
        return this.hasCharactersCounter() ? (int)this.textPaint.measureText(this.getCharactersCounterText()) : 0;
    }

    private int getBottomEllipsisWidth() {
        return this.singleLineEllipsis ? this.bottomEllipsisSize * 5 + this.getPixel(4) : 0;
    }

    private void checkCharactersCount() {
        if (!this.firstShown && !this.checkCharactersCountAtBeginning || !this.hasCharactersCounter()) {
            this.charactersCountValid = true;
        } else {
            Editable text = this.getText();
            int count = text == null ? 0 : this.checkLength((CharSequence)text);
            this.charactersCountValid = count >= this.minCharacters && (this.maxCharacters <= 0 || count <= this.maxCharacters);
        }
    }

    public boolean isCharactersCountValid() {
        return this.charactersCountValid;
    }

    private boolean hasCharactersCounter() {
        return this.minCharacters > 0 || this.maxCharacters > 0;
    }

    private String getCharactersCounterText() {
        String text = this.minCharacters <= 0 ? (this.isRTL() ? this.maxCharacters + " / " + this.checkLength((CharSequence)this.getText()) : this.checkLength((CharSequence)this.getText()) + " / " + this.maxCharacters) : (this.maxCharacters <= 0 ? (this.isRTL() ? "+" + this.minCharacters + " / " + this.checkLength((CharSequence)this.getText()) : this.checkLength((CharSequence)this.getText()) + " / " + this.minCharacters + "+") : (this.isRTL() ? this.maxCharacters + "-" + this.minCharacters + " / " + this.checkLength((CharSequence)this.getText()) : this.checkLength((CharSequence)this.getText()) + " / " + this.minCharacters + "-" + this.maxCharacters));
        return text;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.singleLineEllipsis && this.getScrollX() > 0 && event.getAction() == 0 && event.getX() < (float)this.getPixel(20) && event.getY() > (float)(this.getHeight() - this.extraPaddingBottom - this.innerPaddingBottom) && event.getY() < (float)(this.getHeight() - this.innerPaddingBottom)) {
            this.setSelection(0);
            return false;
        }
        if (this.hasFocus() && (this.showClearButton || this.showPasswordButton) && this.isEnabled()) {
            switch (event.getAction()) {
                case 0: {
                    if (this.insideActionButton(event)) {
                        this.actionButtonTouched = true;
                        this.actionButtonClicking = true;
                        return true;
                    }
                }
                case 2: {
                    if (this.actionButtonClicking && !this.insideActionButton(event)) {
                        this.actionButtonClicking = false;
                    }
                    if (!this.actionButtonTouched) break;
                    return true;
                }
                case 1: {
                    if (this.actionButtonClicking) {
                        if (this.showClearButton) {
                            if (!TextUtils.isEmpty((CharSequence)this.getText())) {
                                this.setText(null);
                            }
                        } else {
                            this.togglePasswordIconVisibility();
                        }
                        this.actionButtonClicking = false;
                    }
                    if (this.actionButtonTouched) {
                        this.actionButtonTouched = false;
                        return true;
                    }
                    this.actionButtonTouched = false;
                    break;
                }
                case 3: {
                    this.actionButtonTouched = false;
                    this.actionButtonClicking = false;
                    break;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    private boolean insideActionButton(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        int startX = this.getStartIcon() == null ? 0 : this.iconOuterWidth + this.iconPadding;
        int endX = this.getEndIcon() == null ? this.getWidth() : this.getWidth() - this.iconOuterWidth - this.iconPadding;
        int buttonLeft = this.isRTL() ? startX : endX - this.iconOuterWidth;
        int buttonTop = this.getScrollY() + this.getHeight() - this.getPaddingBottom() + this.bottomSpacing - this.iconOuterHeight;
        return x >= (float)buttonLeft && x < (float)(buttonLeft + this.iconOuterWidth) && y >= (float)buttonTop && y < (float)(buttonTop + this.iconOuterHeight);
    }

    private void handleSwitchPasswordInputVisibility() {
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        if (this.passwordVisible) {
            this.setTransformationMethod(null);
        } else {
            this.setTransformationMethod((TransformationMethod)this.mTransformationMethod);
        }
        this.setSelection(selectionStart, selectionEnd);
    }

    private void togglePasswordIconVisibility() {
        this.passwordVisible = !this.passwordVisible;
        this.handleSwitchPasswordInputVisibility();
    }

    private int checkLength(CharSequence text) {
        if (this.lengthChecker == null) {
            return text.length();
        }
        return this.lengthChecker.getLength(text);
    }

    public void setTypeface(Typeface typeface) {
        super.setTypeface(typeface);
        if (this.textPaint != null) {
            this.textPaint.setTypeface(typeface);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FloatingLabelType {
    }
}

