/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.edittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.AppCompatEditText;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.edittext.materialedittext.validation.METValidator;
import com.xuexiang.xui.widget.edittext.materialedittext.validation.RegexpValidator;
import com.xuexiang.xui.widget.popupwindow.ViewTooltip;
import java.util.ArrayList;
import java.util.List;

public class ValidatorEditText
extends AppCompatEditText
implements View.OnFocusChangeListener {
    private List<METValidator> mValidators;
    private boolean mIsAutoValidate;
    private OnValidateListener mOnValidateListener;
    private boolean mIsValid = true;
    private Drawable mErrorDrawable;
    private CharSequence mErrorMsg;
    private int mPosition;
    private boolean mIsShowErrorIcon = true;
    private int mExtraClickArea;

    public ValidatorEditText(Context context) {
        this(context, null);
    }

    public ValidatorEditText(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.ValidatorEditTextStyle);
    }

    public ValidatorEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        int iconSize;
        this.mExtraClickArea = DensityUtils.dp2px(context, 20.0f);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ValidatorEditText, defStyleAttr, 0);
        String regexp = typedArray.getString(R.styleable.ValidatorEditText_vet_regexp);
        if (!TextUtils.isEmpty((CharSequence)regexp)) {
            this.mValidators = new ArrayList<METValidator>();
            String errorMessage = typedArray.getString(R.styleable.ValidatorEditText_vet_errorMessage);
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                this.mValidators.add(new RegexpValidator(errorMessage, regexp));
            } else {
                this.mValidators.add(new RegexpValidator(ResUtils.getString(context, R.string.xui_met_input_error), regexp));
            }
        }
        this.mIsAutoValidate = typedArray.getBoolean(R.styleable.ValidatorEditText_vet_autoValidate, true);
        this.mIsShowErrorIcon = typedArray.getBoolean(R.styleable.ValidatorEditText_vet_showErrorIcon, true);
        this.mErrorDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.ValidatorEditText_vet_errorIcon);
        if (this.mErrorDrawable == null) {
            this.mErrorDrawable = this.getCompoundDrawablesRelative()[2];
            if (this.mErrorDrawable == null) {
                this.mErrorDrawable = ResUtils.getDrawable(this.getContext(), R.drawable.xui_ic_default_tip_btn);
            }
        }
        if ((iconSize = typedArray.getDimensionPixelSize(R.styleable.ValidatorEditText_vet_errorIconSize, 0)) != 0) {
            this.mErrorDrawable.setBounds(0, 0, iconSize, iconSize);
        } else {
            this.mErrorDrawable.setBounds(0, 0, this.mErrorDrawable.getIntrinsicWidth(), this.mErrorDrawable.getIntrinsicHeight());
        }
        this.mPosition = typedArray.getInt(R.styleable.ValidatorEditText_vet_tipPosition, 2);
        typedArray.recycle();
    }

    private void initView() {
        this.setErrorIconVisible(false);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.initTextWatcher();
        if (this.mIsAutoValidate) {
            this.updateValid();
        }
    }

    private void initTextWatcher() {
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (ValidatorEditText.this.mIsAutoValidate) {
                    ValidatorEditText.this.updateValid();
                } else {
                    ValidatorEditText.this.setError(null);
                }
                ValidatorEditText.this.postInvalidate();
            }
        });
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.getCompoundDrawablesRelative()[2] != null && event.getAction() == 1 && this.isTouchable(event)) {
            this.showErrorMsg();
        }
        return super.onTouchEvent(event);
    }

    public ValidatorEditText setExtraClickAreaSize(int extraClickArea) {
        this.mExtraClickArea = extraClickArea;
        return this;
    }

    private boolean isTouchable(MotionEvent event) {
        if (this.isRtl()) {
            return event.getX() > (float)(this.getPaddingStart() - this.mExtraClickArea) && event.getX() < (float)(this.getPaddingStart() + this.mErrorDrawable.getIntrinsicWidth() + this.mExtraClickArea);
        }
        return event.getX() > (float)(this.getWidth() - this.getPaddingEnd() - this.mErrorDrawable.getIntrinsicWidth() - this.mExtraClickArea) && event.getX() < (float)(this.getWidth() - this.getPaddingEnd() + this.mExtraClickArea);
    }

    private void showErrorMsg() {
        if (!this.mIsValid) {
            ViewTooltip.on((View)this).color(ThemeUtils.resolveColor(this.getContext(), R.attr.xui_config_color_error_text)).position(ValidatorEditText.parsePosition(this.mPosition)).text(this.mErrorMsg.toString()).show();
        }
    }

    public ValidatorEditText addValidator(METValidator validator) {
        if (validator != null) {
            if (this.mValidators == null) {
                this.mValidators = new ArrayList<METValidator>();
            }
            this.mValidators.add(validator);
        }
        return this;
    }

    public void clearValidators() {
        if (this.mValidators != null) {
            this.mValidators.clear();
        }
    }

    public ValidatorEditText setOnValidateListener(OnValidateListener onValidateListener) {
        this.mOnValidateListener = onValidateListener;
        return this;
    }

    public boolean validate() {
        if (this.mValidators == null || this.mValidators.isEmpty()) {
            return true;
        }
        Editable text = this.getText();
        boolean isEmpty = TextUtils.isEmpty((CharSequence)text);
        boolean isValid = true;
        for (METValidator validator : this.mValidators) {
            isValid = validator.isValid((CharSequence)text, isEmpty);
            if (isValid) continue;
            this.setError(validator.getErrorMessage());
            break;
        }
        if (isValid) {
            this.setError(null);
        }
        this.postInvalidate();
        return isValid;
    }

    public void updateValid() {
        this.mIsValid = this.validate();
    }

    public boolean isInputValid() {
        if (this.mIsAutoValidate) {
            return this.mIsValid;
        }
        return this.validate();
    }

    public void setError(CharSequence error) {
        this.mErrorMsg = error;
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.setErrorIconVisible(false);
            this.setBackground(ResUtils.getDrawable(this.getContext(), R.drawable.xui_config_bg_edittext));
        } else {
            this.onValidateError(error.toString());
            this.setBackground(ResUtils.getDrawable(this.getContext(), R.drawable.xui_config_color_edittext_error));
        }
    }

    public CharSequence getErrorMsg() {
        return this.mErrorMsg;
    }

    public String getInputValue() {
        return this.getEditableText().toString().trim();
    }

    private void onValidateError(String errorMessage) {
        this.setErrorIconVisible(true);
        if (this.mOnValidateListener != null) {
            this.mOnValidateListener.onValidateError(this.getText() != null ? this.getText().toString() : "", errorMessage);
        }
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (this.mIsAutoValidate && !hasFocus) {
            this.updateValid();
        }
    }

    private void setErrorIconVisible(boolean visible) {
        Drawable end = visible && this.mIsShowErrorIcon ? this.mErrorDrawable : null;
        this.setCompoundDrawablesRelative(this.getCompoundDrawablesRelative()[0], this.getCompoundDrawablesRelative()[1], end, this.getCompoundDrawablesRelative()[3]);
    }

    public static ViewTooltip.Position parsePosition(int value) {
        switch (value) {
            case 0: {
                return ViewTooltip.Position.LEFT;
            }
            case 1: {
                return ViewTooltip.Position.RIGHT;
            }
            case 2: {
                return ViewTooltip.Position.TOP;
            }
            case 3: {
                return ViewTooltip.Position.BOTTOM;
            }
        }
        return ViewTooltip.Position.TOP;
    }

    public void setEnabled(boolean enabled) {
        super.setFocusable(enabled);
        super.setFocusableInTouchMode(enabled);
        super.setEnabled(enabled);
    }

    public boolean isEmpty() {
        return TextUtils.isEmpty((CharSequence)this.getInputValue());
    }

    public boolean isNotEmpty() {
        return !TextUtils.isEmpty((CharSequence)this.getInputValue());
    }

    private boolean isRtl() {
        return this.getLayoutDirection() == 1;
    }

    public static interface OnValidateListener {
        public void onValidateError(String var1, String var2);
    }
}

