/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.edittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.AppCompatEditText;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.edittext.AsteriskPasswordTransformationMethod;

public class PasswordEditText
extends AppCompatEditText {
    private int mExtraClickArea;
    private static final int ALPHA_ICON_ENABLED = 137;
    private static final int ALPHA_ICON_DISABLED = 96;
    private Drawable mShowPwDrawable;
    private Drawable mHidePwDrawable;
    private boolean mPasswordVisible;
    private boolean mShowingIcon;
    private boolean mSetErrorCalled;
    private boolean mHoverShowsPw;
    private boolean mHandlingHoverEvent;
    private PasswordTransformationMethod mTransformationMethod;

    public PasswordEditText(Context context) {
        this(context, null);
    }

    public PasswordEditText(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.PasswordEditTextStyle);
    }

    public PasswordEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        boolean enableIconAlpha;
        boolean useNonMonospaceFont;
        this.mExtraClickArea = DensityUtils.dp2px(context, 20.0f);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PasswordEditText, defStyleAttr, 0);
        try {
            this.mShowPwDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.PasswordEditText_pet_iconShow);
            if (this.mShowPwDrawable == null) {
                this.mShowPwDrawable = ResUtils.getVectorDrawable(this.getContext(), R.drawable.pet_icon_visibility_24dp);
            }
            this.mHidePwDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.PasswordEditText_pet_iconHide);
            if (this.mHidePwDrawable == null) {
                this.mHidePwDrawable = ResUtils.getVectorDrawable(this.getContext(), R.drawable.pet_icon_visibility_off_24dp);
            }
            this.mHoverShowsPw = typedArray.getBoolean(R.styleable.PasswordEditText_pet_hoverShowsPw, false);
            useNonMonospaceFont = typedArray.getBoolean(R.styleable.PasswordEditText_pet_nonMonospaceFont, false);
            enableIconAlpha = typedArray.getBoolean(R.styleable.PasswordEditText_pet_enableIconAlpha, true);
            boolean isAsteriskStyle = typedArray.getBoolean(R.styleable.PasswordEditText_pet_isAsteriskStyle, false);
            this.mTransformationMethod = isAsteriskStyle ? AsteriskPasswordTransformationMethod.getInstance() : PasswordTransformationMethod.getInstance();
        }
        finally {
            typedArray.recycle();
        }
        if (enableIconAlpha) {
            this.mHidePwDrawable.setAlpha(137);
            this.mShowPwDrawable.setAlpha(96);
        }
        if (useNonMonospaceFont) {
            this.setTypeface(Typeface.DEFAULT);
        }
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence seq, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s.length() > 0) {
                    if (PasswordEditText.this.mSetErrorCalled) {
                        PasswordEditText.this.setCompoundDrawablesRelative(null, null, null, null);
                        PasswordEditText.this.mSetErrorCalled = false;
                        PasswordEditText.this.showPasswordVisibilityIndicator(true);
                    }
                    if (!PasswordEditText.this.mShowingIcon) {
                        PasswordEditText.this.showPasswordVisibilityIndicator(true);
                    }
                } else {
                    PasswordEditText.this.mPasswordVisible = false;
                    PasswordEditText.this.handlePasswordInputVisibility();
                    PasswordEditText.this.showPasswordVisibilityIndicator(false);
                }
            }
        });
        this.handlePasswordInputVisibility();
    }

    public PasswordEditText setExtraClickAreaSize(int extraClickArea) {
        this.mExtraClickArea = extraClickArea;
        return this;
    }

    public PasswordEditText setPasswordTransformationMethod(PasswordTransformationMethod transformationMethod) {
        this.mTransformationMethod = transformationMethod;
        return this;
    }

    public PasswordEditText setIsAsteriskStyle(boolean isAsteriskStyle) {
        this.mTransformationMethod = isAsteriskStyle ? AsteriskPasswordTransformationMethod.getInstance() : PasswordTransformationMethod.getInstance();
        return this;
    }

    private boolean isRtl() {
        return this.getLayoutDirection() == 1;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mShowingIcon, this.mPasswordVisible);
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mShowingIcon = savedState.isShowingIcon();
        this.mPasswordVisible = savedState.isPasswordVisible();
        this.handlePasswordInputVisibility();
        this.showPasswordVisibilityIndicator(this.mShowingIcon);
    }

    public void setError(CharSequence error) {
        super.setError(error);
        this.mSetErrorCalled = true;
    }

    public void setError(CharSequence error, Drawable icon) {
        super.setError(error, icon);
        this.mSetErrorCalled = true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mShowingIcon) {
            return super.onTouchEvent(event);
        }
        boolean touchable = this.isTouchable(event);
        switch (event.getAction()) {
            case 0: {
                if (!this.mHoverShowsPw || !touchable) break;
                this.togglePasswordIconVisibility();
                event.setAction(3);
                this.mHandlingHoverEvent = true;
                break;
            }
            case 1: {
                if (!this.mHandlingHoverEvent && !touchable) break;
                this.togglePasswordIconVisibility();
                event.setAction(3);
                this.mHandlingHoverEvent = false;
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    private boolean isTouchable(MotionEvent event) {
        boolean touchable = this.isRtl() ? event.getX() > (float)(this.getPaddingLeft() - this.mExtraClickArea) && event.getX() < (float)(this.getPaddingLeft() + this.mShowPwDrawable.getIntrinsicWidth() + this.mExtraClickArea) : event.getX() > (float)(this.getWidth() - this.getPaddingRight() - this.mShowPwDrawable.getIntrinsicWidth() - this.mExtraClickArea) && event.getX() < (float)(this.getWidth() - this.getPaddingRight() + this.mExtraClickArea);
        return touchable;
    }

    private void showPasswordVisibilityIndicator(boolean shouldShowIcon) {
        if (shouldShowIcon) {
            Drawable drawable2 = this.mPasswordVisible ? this.mShowPwDrawable : this.mHidePwDrawable;
            this.mShowingIcon = true;
            this.setCompoundDrawablesRelativeWithIntrinsicBounds(null, null, drawable2, null);
        } else {
            this.setCompoundDrawablesRelative(null, null, null, null);
            this.mShowingIcon = false;
        }
    }

    private void togglePasswordIconVisibility() {
        this.mPasswordVisible = !this.mPasswordVisible;
        this.handlePasswordInputVisibility();
        this.showPasswordVisibilityIndicator(true);
    }

    private void handlePasswordInputVisibility() {
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        if (this.mPasswordVisible) {
            this.setTransformationMethod(null);
        } else {
            this.setTransformationMethod((TransformationMethod)this.mTransformationMethod);
        }
        this.setSelection(selectionStart, selectionEnd);
    }

    protected static class SavedState
    extends View.BaseSavedState {
        private final boolean mShowingIcon;
        private final boolean mPasswordVisible;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, boolean sI, boolean pV) {
            super(superState);
            this.mShowingIcon = sI;
            this.mPasswordVisible = pV;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mShowingIcon = in.readByte() != 0;
            this.mPasswordVisible = in.readByte() != 0;
        }

        public boolean isShowingIcon() {
            return this.mShowingIcon;
        }

        public boolean isPasswordVisible() {
            return this.mPasswordVisible;
        }

        public void writeToParcel(Parcel destination, int flags) {
            super.writeToParcel(destination, flags);
            destination.writeByte((byte)(this.mShowingIcon ? 1 : 0));
            destination.writeByte((byte)(this.mPasswordVisible ? 1 : 0));
        }
    }
}

