/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.edittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.CycleInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatEditText;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ResUtils;

public class ClearEditText
extends AppCompatEditText
implements View.OnFocusChangeListener,
TextWatcher {
    private int mExtraClickArea;
    private Drawable mClearDrawable;

    public ClearEditText(Context context) {
        this(context, null);
    }

    public ClearEditText(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.ClearEditTextStyle);
    }

    public ClearEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttrs(context, attrs, defStyle);
    }

    public ClearEditText setExtraClickAreaSize(int extraClickArea) {
        this.mExtraClickArea = extraClickArea;
        return this;
    }

    public static Animation shakeAnimation(int counts) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 10.0f, 0.0f, 0.0f);
        translateAnimation.setInterpolator((Interpolator)new CycleInterpolator((float)counts));
        translateAnimation.setDuration(1000L);
        return translateAnimation;
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mExtraClickArea = DensityUtils.dp2px(context, 20.0f);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ClearEditText, defStyleAttr, 0);
        this.mClearDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.ClearEditText_cet_clearIcon);
        int iconSize = typedArray.getDimensionPixelSize(R.styleable.ClearEditText_cet_clearIconSize, 0);
        typedArray.recycle();
        if (this.mClearDrawable == null) {
            this.mClearDrawable = this.getCompoundDrawablesRelative()[2];
            if (this.mClearDrawable == null) {
                this.mClearDrawable = ResUtils.getVectorDrawable(context, R.drawable.xui_ic_default_clear_btn);
            }
        }
        if (iconSize != 0) {
            this.mClearDrawable.setBounds(0, 0, iconSize, iconSize);
        } else {
            this.mClearDrawable.setBounds(0, 0, this.mClearDrawable.getIntrinsicWidth(), this.mClearDrawable.getIntrinsicHeight());
        }
        this.setClearIconVisible(false);
        this.setOnFocusChangeListener(this);
        this.addTextChangedListener(this);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean touchable;
        if (this.getCompoundDrawablesRelative()[2] != null && event.getAction() == 1 && (touchable = this.isTouchable(event))) {
            this.setText("");
        }
        return super.onTouchEvent(event);
    }

    private boolean isTouchable(MotionEvent event) {
        if (this.isRtl()) {
            return event.getX() > (float)(this.getPaddingLeft() - this.mExtraClickArea) && event.getX() < (float)(this.getPaddingLeft() + this.mClearDrawable.getIntrinsicWidth() + this.mExtraClickArea);
        }
        return event.getX() > (float)(this.getWidth() - this.getPaddingRight() - this.mClearDrawable.getIntrinsicWidth() - this.mExtraClickArea) && event.getX() < (float)(this.getWidth() - this.getPaddingRight() + this.mExtraClickArea);
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            int length = this.getText() != null ? this.getText().length() : 0;
            this.setClearIconVisible(length > 0);
        } else {
            this.setClearIconVisible(false);
        }
    }

    protected void setClearIconVisible(boolean visible) {
        Drawable end = visible ? this.mClearDrawable : null;
        this.setCompoundDrawablesRelative(this.getCompoundDrawablesRelative()[0], this.getCompoundDrawablesRelative()[1], end, this.getCompoundDrawablesRelative()[3]);
    }

    public void onTextChanged(CharSequence s, int start, int count, int after) {
        this.setClearIconVisible(s.length() > 0);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        this.setClearIconVisible(false);
    }

    public void setShakeAnimation() {
        this.setAnimation(ClearEditText.shakeAnimation(5));
    }

    private boolean isRtl() {
        return this.getLayoutDirection() == 1;
    }
}

