/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.dialog.materialdialog.simplelist;

import android.content.Context;
import android.graphics.PorterDuff;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.dialog.materialdialog.MaterialDialog;
import com.xuexiang.xui.widget.dialog.materialdialog.internal.MDAdapter;
import com.xuexiang.xui.widget.dialog.materialdialog.simplelist.MaterialSimpleListItem;
import java.util.ArrayList;
import java.util.List;

public class MaterialSimpleListAdapter
extends RecyclerView.Adapter<SimpleListVH>
implements MDAdapter {
    private MaterialDialog mDialog;
    private List<MaterialSimpleListItem> mItems;
    private OnItemClickListener mOnItemClickListener;

    public MaterialSimpleListAdapter(OnItemClickListener onItemClickListener) {
        this.mItems = new ArrayList<MaterialSimpleListItem>(4);
        this.mOnItemClickListener = onItemClickListener;
    }

    public MaterialSimpleListAdapter(List<MaterialSimpleListItem> lists) {
        this.mItems = lists;
    }

    public MaterialSimpleListAdapter setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
        return this;
    }

    public void add(MaterialSimpleListItem item) {
        this.mItems.add(item);
        this.notifyItemInserted(this.mItems.size() - 1);
    }

    public void add(MaterialSimpleListItem.Builder builder) {
        this.add(builder.build());
    }

    public void clear() {
        this.mItems.clear();
        this.notifyDataSetChanged();
    }

    public MaterialSimpleListItem getItem(int index) {
        return this.mItems.get(index);
    }

    @Override
    public void setDialog(MaterialDialog dialog) {
        this.mDialog = dialog;
    }

    public MaterialDialog getMaterialDialog() {
        return this.mDialog;
    }

    @NonNull
    public SimpleListVH onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.xmd_layout_simplelist_item, parent, false);
        return new SimpleListVH(view, this);
    }

    public void onBindViewHolder(@NonNull SimpleListVH holder, int position) {
        if (this.mDialog != null) {
            MaterialSimpleListItem item = this.mItems.get(position);
            if (item.getIcon() != null) {
                holder.mIcon.setImageDrawable(item.getIcon());
                holder.mIcon.setPadding(item.getIconPadding(), item.getIconPadding(), item.getIconPadding(), item.getIconPadding());
                holder.mIcon.getBackground().setColorFilter(item.getBackgroundColor(), PorterDuff.Mode.SRC_ATOP);
            } else {
                holder.mIcon.setVisibility(8);
            }
            holder.mTitle.setTextColor(this.mDialog.getBuilder().getItemColor());
            holder.mTitle.setText(item.getContent());
            this.mDialog.setTypeface(holder.mTitle, this.mDialog.getBuilder().getRegularFont());
        }
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    static class SimpleListVH
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        final ImageView mIcon;
        final TextView mTitle;
        final MaterialSimpleListAdapter mAdapter;

        SimpleListVH(View itemView, MaterialSimpleListAdapter adapter) {
            super(itemView);
            this.mIcon = (ImageView)itemView.findViewById(16908294);
            this.mTitle = (TextView)itemView.findViewById(16908310);
            this.mAdapter = adapter;
            itemView.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View view) {
            if (this.mAdapter != null && this.mAdapter.mOnItemClickListener != null) {
                this.mAdapter.getMaterialDialog().dismiss();
                this.mAdapter.mOnItemClickListener.onMaterialListItemSelected(this.mAdapter.mDialog, this.getAdapterPosition(), this.mAdapter.getItem(this.getAdapterPosition()));
            }
        }
    }

    public static interface OnItemClickListener {
        public void onMaterialListItemSelected(MaterialDialog var1, int var2, MaterialSimpleListItem var3);
    }
}

