/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.dialog.materialdialog.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.ScrollView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.dialog.materialdialog.GravityEnum;
import com.xuexiang.xui.widget.dialog.materialdialog.StackingBehavior;
import com.xuexiang.xui.widget.dialog.materialdialog.internal.MDButton;

public class MDRootLayout
extends ViewGroup {
    private static final int INDEX_NEUTRAL = 0;
    private static final int INDEX_NEGATIVE = 1;
    private static final int INDEX_POSITIVE = 2;
    private final MDButton[] buttons = new MDButton[3];
    private int maxHeight;
    private View titleBar;
    private View content;
    private boolean drawTopDivider = false;
    private boolean drawBottomDivider = false;
    private StackingBehavior stackBehavior = StackingBehavior.ADAPTIVE;
    private boolean isStacked = false;
    private boolean useFullPadding = true;
    private boolean reducePaddingNoTitleNoButtons;
    private boolean noTitleNoPadding;
    private int noTitlePaddingFull;
    private int buttonPaddingFull;
    private int buttonBarHeight;
    private GravityEnum buttonGravity = GravityEnum.START;
    private int buttonHorizontalEdgeMargin;
    private Paint dividerPaint;
    private ViewTreeObserver.OnScrollChangedListener topOnScrollChangedListener;
    private ViewTreeObserver.OnScrollChangedListener bottomOnScrollChangedListener;
    private int dividerWidth;

    public MDRootLayout(Context context) {
        super(context, null);
        this.init(context, null, 0);
    }

    public MDRootLayout(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.init(context, attrs, 0);
    }

    @TargetApi(value=11)
    public MDRootLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public MDRootLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private static boolean isVisible(View v) {
        boolean visible;
        boolean bl = visible = v != null && v.getVisibility() != 8;
        if (visible && v instanceof MDButton) {
            visible = ((MDButton)v).getText().toString().trim().length() > 0;
        }
        return visible;
    }

    public static boolean canRecyclerViewScroll(RecyclerView view) {
        return view != null && view.getLayoutManager() != null && view.getLayoutManager().canScrollVertically();
    }

    private static boolean canScrollViewScroll(ScrollView sv) {
        if (sv.getChildCount() == 0) {
            return false;
        }
        int childHeight = sv.getChildAt(0).getMeasuredHeight();
        return sv.getMeasuredHeight() - sv.getPaddingTop() - sv.getPaddingBottom() < childHeight;
    }

    private static boolean canWebViewScroll(WebView view) {
        return (float)view.getMeasuredHeight() < (float)view.getContentHeight() * view.getScale();
    }

    private static boolean canAdapterViewScroll(AdapterView lv) {
        boolean lastItemVisible;
        if (lv.getLastVisiblePosition() == -1) {
            return false;
        }
        boolean firstItemVisible = lv.getFirstVisiblePosition() == 0;
        boolean bl = lastItemVisible = lv.getLastVisiblePosition() == lv.getCount() - 1;
        if (firstItemVisible && lastItemVisible && lv.getChildCount() > 0) {
            if (lv.getChildAt(0).getTop() < lv.getPaddingTop()) {
                return true;
            }
            return lv.getChildAt(lv.getChildCount() - 1).getBottom() > lv.getHeight() - lv.getPaddingBottom();
        }
        return true;
    }

    @Nullable
    private static View getBottomView(ViewGroup viewGroup) {
        if (viewGroup == null || viewGroup.getChildCount() == 0) {
            return null;
        }
        View bottomView = null;
        for (int i = viewGroup.getChildCount() - 1; i >= 0; --i) {
            View child = viewGroup.getChildAt(i);
            if (child.getVisibility() != 0 || child.getBottom() != viewGroup.getMeasuredHeight()) continue;
            bottomView = child;
            break;
        }
        return bottomView;
    }

    @Nullable
    private static View getTopView(ViewGroup viewGroup) {
        if (viewGroup == null || viewGroup.getChildCount() == 0) {
            return null;
        }
        View topView = null;
        for (int i = viewGroup.getChildCount() - 1; i >= 0; --i) {
            View child = viewGroup.getChildAt(i);
            if (child.getVisibility() != 0 || child.getTop() != 0) continue;
            topView = child;
            break;
        }
        return topView;
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        Resources r = context.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MDRootLayout, defStyleAttr, 0);
        this.reducePaddingNoTitleNoButtons = a.getBoolean(R.styleable.MDRootLayout_md_reduce_padding_no_title_no_buttons, true);
        a.recycle();
        this.noTitlePaddingFull = r.getDimensionPixelSize(R.dimen.md_notitle_vertical_padding);
        this.buttonPaddingFull = r.getDimensionPixelSize(R.dimen.md_button_frame_vertical_padding);
        this.buttonHorizontalEdgeMargin = r.getDimensionPixelSize(R.dimen.md_button_padding_frame_side);
        this.buttonBarHeight = ThemeUtils.resolveDimension(context, R.attr.md_button_height, r.getDimensionPixelSize(R.dimen.default_md_button_height_phone));
        this.dividerPaint = new Paint();
        this.dividerWidth = r.getDimensionPixelSize(R.dimen.md_divider_height);
        this.dividerPaint.setColor(ThemeUtils.resolveColor(context, R.attr.md_divider_color));
        this.setWillNotDraw(false);
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void noTitleNoPadding() {
        this.noTitleNoPadding = true;
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View v = this.getChildAt(i);
            if (v.getId() == R.id.md_titleFrame) {
                this.titleBar = v;
                continue;
            }
            if (v.getId() == R.id.md_buttonDefaultNeutral) {
                this.buttons[0] = (MDButton)v;
                continue;
            }
            if (v.getId() == R.id.md_buttonDefaultNegative) {
                this.buttons[1] = (MDButton)v;
                continue;
            }
            if (v.getId() == R.id.md_buttonDefaultPositive) {
                this.buttons[2] = (MDButton)v;
                continue;
            }
            this.content = v;
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean stacked;
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (height > this.maxHeight) {
            height = this.maxHeight;
        }
        this.useFullPadding = true;
        boolean hasButtons = false;
        if (this.stackBehavior == StackingBehavior.ALWAYS) {
            stacked = true;
        } else if (this.stackBehavior == StackingBehavior.NEVER) {
            stacked = false;
        } else {
            int buttonsWidth = 0;
            MDButton[] mDButtonArray = this.buttons;
            int n = mDButtonArray.length;
            for (int i = 0; i < n; ++i) {
                MDButton button = mDButtonArray[i];
                if (button == null || !MDRootLayout.isVisible((View)button)) continue;
                button.setStacked(false, false);
                this.measureChild((View)button, widthMeasureSpec, heightMeasureSpec);
                buttonsWidth += button.getMeasuredWidth();
                hasButtons = true;
            }
            int buttonBarPadding = this.getContext().getResources().getDimensionPixelSize(R.dimen.md_neutral_button_margin);
            int buttonFrameWidth = width - 2 * buttonBarPadding;
            stacked = buttonsWidth > buttonFrameWidth;
        }
        int stackedHeight = 0;
        this.isStacked = stacked;
        if (stacked) {
            for (MDButton button : this.buttons) {
                if (button == null || !MDRootLayout.isVisible((View)button)) continue;
                button.setStacked(true, false);
                this.measureChild((View)button, widthMeasureSpec, heightMeasureSpec);
                stackedHeight += button.getMeasuredHeight();
                hasButtons = true;
            }
        }
        int availableHeight = height;
        int fullPadding = 0;
        int minPadding = 0;
        if (hasButtons) {
            if (this.isStacked) {
                availableHeight -= stackedHeight;
                fullPadding += 2 * this.buttonPaddingFull;
                minPadding += 2 * this.buttonPaddingFull;
            } else {
                availableHeight -= this.buttonBarHeight;
                fullPadding += 2 * this.buttonPaddingFull;
            }
        } else {
            fullPadding += 2 * this.buttonPaddingFull;
        }
        if (MDRootLayout.isVisible(this.titleBar)) {
            this.titleBar.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), 0);
            availableHeight -= this.titleBar.getMeasuredHeight();
        } else if (!this.noTitleNoPadding) {
            fullPadding += this.noTitlePaddingFull;
        }
        if (MDRootLayout.isVisible(this.content)) {
            this.content.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(availableHeight - minPadding), (int)Integer.MIN_VALUE));
            if (this.content.getMeasuredHeight() <= availableHeight - fullPadding) {
                if (!this.reducePaddingNoTitleNoButtons || MDRootLayout.isVisible(this.titleBar) || hasButtons) {
                    this.useFullPadding = true;
                    availableHeight -= this.content.getMeasuredHeight() + fullPadding;
                } else {
                    this.useFullPadding = false;
                    availableHeight -= this.content.getMeasuredHeight() + minPadding;
                }
            } else {
                this.useFullPadding = false;
                availableHeight = 0;
            }
        }
        this.setMeasuredDimension(width, height - availableHeight);
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.content != null) {
            int y;
            if (this.drawTopDivider) {
                y = this.content.getTop();
                canvas.drawRect(0.0f, (float)(y - this.dividerWidth), (float)this.getMeasuredWidth(), (float)y, this.dividerPaint);
            }
            if (this.drawBottomDivider) {
                y = this.content.getBottom();
                canvas.drawRect(0.0f, (float)y, (float)this.getMeasuredWidth(), (float)(y + this.dividerWidth), this.dividerPaint);
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (MDRootLayout.isVisible(this.titleBar)) {
            int height = this.titleBar.getMeasuredHeight();
            this.titleBar.layout(l, t, r, t + height);
            t += height;
        } else if (!this.noTitleNoPadding && this.useFullPadding) {
            t += this.noTitlePaddingFull;
        }
        if (MDRootLayout.isVisible(this.content)) {
            this.content.layout(l, t, r, t + this.content.getMeasuredHeight());
        }
        if (this.isStacked) {
            b -= this.buttonPaddingFull;
            for (MDButton mButton : this.buttons) {
                if (!MDRootLayout.isVisible((View)mButton)) continue;
                mButton.layout(l, b - mButton.getMeasuredHeight(), r, b);
                b -= mButton.getMeasuredHeight();
            }
        } else {
            int br;
            int bl;
            int barBottom = b;
            if (this.useFullPadding) {
                barBottom -= this.buttonPaddingFull;
            }
            int barTop = barBottom - this.buttonBarHeight;
            int offset = this.buttonHorizontalEdgeMargin;
            int neutralLeft = -1;
            int neutralRight = -1;
            if (MDRootLayout.isVisible((View)this.buttons[2])) {
                if (this.buttonGravity == GravityEnum.END) {
                    bl = l + offset;
                    br = bl + this.buttons[2].getMeasuredWidth();
                } else {
                    br = r - offset;
                    neutralRight = bl = br - this.buttons[2].getMeasuredWidth();
                }
                this.buttons[2].layout(bl, barTop, br, barBottom);
                offset += this.buttons[2].getMeasuredWidth();
            }
            if (MDRootLayout.isVisible((View)this.buttons[1])) {
                if (this.buttonGravity == GravityEnum.END) {
                    bl = l + offset;
                    br = bl + this.buttons[1].getMeasuredWidth();
                } else if (this.buttonGravity == GravityEnum.START) {
                    br = r - offset;
                    bl = br - this.buttons[1].getMeasuredWidth();
                } else {
                    bl = l + this.buttonHorizontalEdgeMargin;
                    neutralLeft = br = bl + this.buttons[1].getMeasuredWidth();
                }
                this.buttons[1].layout(bl, barTop, br, barBottom);
            }
            if (MDRootLayout.isVisible((View)this.buttons[0])) {
                if (this.buttonGravity == GravityEnum.END) {
                    br = r - this.buttonHorizontalEdgeMargin;
                    bl = br - this.buttons[0].getMeasuredWidth();
                } else if (this.buttonGravity == GravityEnum.START) {
                    bl = l + this.buttonHorizontalEdgeMargin;
                    br = bl + this.buttons[0].getMeasuredWidth();
                } else {
                    if (neutralLeft == -1 && neutralRight != -1) {
                        neutralLeft = neutralRight - this.buttons[0].getMeasuredWidth();
                    } else if (neutralRight == -1 && neutralLeft != -1) {
                        neutralRight = neutralLeft + this.buttons[0].getMeasuredWidth();
                    } else if (neutralRight == -1) {
                        neutralLeft = (r - l) / 2 - this.buttons[0].getMeasuredWidth() / 2;
                        neutralRight = neutralLeft + this.buttons[0].getMeasuredWidth();
                    }
                    bl = neutralLeft;
                    br = neutralRight;
                }
                this.buttons[0].layout(bl, barTop, br, barBottom);
            }
        }
        this.setUpDividersVisibility(this.content, true, true);
    }

    public void setStackingBehavior(StackingBehavior behavior) {
        this.stackBehavior = behavior;
        this.invalidate();
    }

    public void setDividerColor(int color2) {
        this.dividerPaint.setColor(color2);
        this.invalidate();
    }

    public void setButtonGravity(GravityEnum gravity) {
        this.buttonGravity = gravity;
        this.invertGravityIfNecessary();
    }

    private void invertGravityIfNecessary() {
        if (Build.VERSION.SDK_INT < 17) {
            return;
        }
        Configuration config = this.getResources().getConfiguration();
        if (config.getLayoutDirection() == 1) {
            switch (this.buttonGravity) {
                case START: {
                    this.buttonGravity = GravityEnum.END;
                    break;
                }
                case END: {
                    this.buttonGravity = GravityEnum.START;
                    break;
                }
            }
        }
    }

    public void setButtonStackedGravity(GravityEnum gravity) {
        for (MDButton mButton : this.buttons) {
            if (mButton == null) continue;
            mButton.setStackedGravity(gravity);
        }
    }

    private void setUpDividersVisibility(final View view, final boolean setForTop, final boolean setForBottom) {
        if (view == null) {
            return;
        }
        if (view instanceof ScrollView) {
            ScrollView sv = (ScrollView)view;
            if (MDRootLayout.canScrollViewScroll(sv)) {
                this.addScrollListener((ViewGroup)sv, setForTop, setForBottom);
            } else {
                if (setForTop) {
                    this.drawTopDivider = false;
                }
                if (setForBottom) {
                    this.drawBottomDivider = false;
                }
            }
        } else if (view instanceof AdapterView) {
            AdapterView sv = (AdapterView)view;
            if (MDRootLayout.canAdapterViewScroll(sv)) {
                this.addScrollListener((ViewGroup)sv, setForTop, setForBottom);
            } else {
                if (setForTop) {
                    this.drawTopDivider = false;
                }
                if (setForBottom) {
                    this.drawBottomDivider = false;
                }
            }
        } else if (view instanceof WebView) {
            view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    if (view.getMeasuredHeight() != 0) {
                        if (!MDRootLayout.canWebViewScroll((WebView)view)) {
                            if (setForTop) {
                                MDRootLayout.this.drawTopDivider = false;
                            }
                            if (setForBottom) {
                                MDRootLayout.this.drawBottomDivider = false;
                            }
                        } else {
                            MDRootLayout.this.addScrollListener((ViewGroup)view, setForTop, setForBottom);
                        }
                        view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    }
                    return true;
                }
            });
        } else if (view instanceof RecyclerView) {
            boolean canScroll = MDRootLayout.canRecyclerViewScroll((RecyclerView)view);
            if (setForTop) {
                this.drawTopDivider = canScroll;
            }
            if (setForBottom) {
                this.drawBottomDivider = canScroll;
            }
            if (canScroll) {
                this.addScrollListener((ViewGroup)view, setForTop, setForBottom);
            }
        } else if (view instanceof ViewGroup) {
            View topView = MDRootLayout.getTopView((ViewGroup)view);
            this.setUpDividersVisibility(topView, setForTop, setForBottom);
            View bottomView = MDRootLayout.getBottomView((ViewGroup)view);
            if (bottomView != topView) {
                this.setUpDividersVisibility(bottomView, false, true);
            }
        }
    }

    private void addScrollListener(final ViewGroup vg, final boolean setForTop, final boolean setForBottom) {
        if (!setForBottom && this.topOnScrollChangedListener == null || setForBottom && this.bottomOnScrollChangedListener == null) {
            if (vg instanceof RecyclerView) {
                RecyclerView.OnScrollListener scrollListener = new RecyclerView.OnScrollListener(){

                    public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                        super.onScrolled(recyclerView, dx, dy);
                        boolean hasButtons = false;
                        for (MDButton button : MDRootLayout.this.buttons) {
                            if (button == null || button.getVisibility() == 8) continue;
                            hasButtons = true;
                            break;
                        }
                        MDRootLayout.this.invalidateDividersForScrollingView(vg, setForTop, setForBottom, hasButtons);
                        MDRootLayout.this.invalidate();
                    }
                };
                ((RecyclerView)vg).addOnScrollListener(scrollListener);
                scrollListener.onScrolled((RecyclerView)vg, 0, 0);
            } else {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

                    public void onScrollChanged() {
                        boolean hasButtons = false;
                        for (MDButton button : MDRootLayout.this.buttons) {
                            if (button == null || button.getVisibility() == 8) continue;
                            hasButtons = true;
                            break;
                        }
                        if (vg instanceof WebView) {
                            MDRootLayout.this.invalidateDividersForWebView((WebView)vg, setForTop, setForBottom, hasButtons);
                        } else {
                            MDRootLayout.this.invalidateDividersForScrollingView(vg, setForTop, setForBottom, hasButtons);
                        }
                        MDRootLayout.this.invalidate();
                    }
                };
                if (!setForBottom) {
                    this.topOnScrollChangedListener = onScrollChangedListener;
                    vg.getViewTreeObserver().addOnScrollChangedListener(this.topOnScrollChangedListener);
                } else {
                    this.bottomOnScrollChangedListener = onScrollChangedListener;
                    vg.getViewTreeObserver().addOnScrollChangedListener(this.bottomOnScrollChangedListener);
                }
                onScrollChangedListener.onScrollChanged();
            }
        }
    }

    private void invalidateDividersForScrollingView(ViewGroup view, boolean setForTop, boolean setForBottom, boolean hasButtons) {
        if (setForTop && view.getChildCount() > 0) {
            boolean bl = this.drawTopDivider = this.titleBar != null && this.titleBar.getVisibility() != 8 && view.getScrollY() + view.getPaddingTop() > view.getChildAt(0).getTop();
        }
        if (setForBottom && view.getChildCount() > 0) {
            this.drawBottomDivider = hasButtons && view.getScrollY() + view.getHeight() - view.getPaddingBottom() < view.getChildAt(view.getChildCount() - 1).getBottom();
        }
    }

    private void invalidateDividersForWebView(WebView view, boolean setForTop, boolean setForBottom, boolean hasButtons) {
        if (setForTop) {
            boolean bl = this.drawTopDivider = this.titleBar != null && this.titleBar.getVisibility() != 8 && view.getScrollY() + view.getPaddingTop() > 0;
        }
        if (setForBottom) {
            this.drawBottomDivider = hasButtons && (float)(view.getScrollY() + view.getMeasuredHeight() - view.getPaddingBottom()) < (float)view.getContentHeight() * view.getScale();
        }
    }
}

