/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.dialog.materialdialog.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.dialog.materialdialog.GravityEnum;
import com.xuexiang.xui.widget.dialog.materialdialog.internal.AllCapsTransformationMethod;

@SuppressLint(value={"AppCompatCustomView"})
public class MDButton
extends TextView {
    private boolean stacked = false;
    private GravityEnum stackedGravity;
    private int stackedEndPadding;
    private Drawable stackedBackground;
    private Drawable defaultBackground;

    public MDButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public MDButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.stackedEndPadding = ThemeUtils.resolveDimension(context, R.attr.md_dialog_frame_margin, R.dimen.default_md_dialog_frame_margin);
        this.stackedGravity = GravityEnum.END;
    }

    void setStacked(boolean stacked, boolean force) {
        if (this.stacked != stacked || force) {
            this.setGravity(stacked ? 0x10 | this.stackedGravity.getGravityInt() : 17);
            if (Build.VERSION.SDK_INT >= 17) {
                this.setTextAlignment(stacked ? this.stackedGravity.getTextAlignment() : 4);
            }
            ThemeUtils.setBackgroundCompat((View)this, stacked ? this.stackedBackground : this.defaultBackground);
            if (stacked) {
                this.setPadding(this.stackedEndPadding, this.getPaddingTop(), this.stackedEndPadding, this.getPaddingBottom());
            }
            this.stacked = stacked;
        }
    }

    public void setStackedGravity(GravityEnum gravity) {
        this.stackedGravity = gravity;
    }

    public void setStackedSelector(Drawable d) {
        this.stackedBackground = d;
        if (this.stacked) {
            this.setStacked(true, true);
        }
    }

    public void setDefaultSelector(Drawable d) {
        this.defaultBackground = d;
        if (!this.stacked) {
            this.setStacked(false, true);
        }
    }

    public void setAllCapsCompat(boolean allCaps) {
        if (Build.VERSION.SDK_INT >= 14) {
            this.setAllCaps(allCaps);
        } else if (allCaps) {
            this.setTransformationMethod(new AllCapsTransformationMethod(this.getContext()));
        } else {
            this.setTransformationMethod(null);
        }
    }
}

