/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.widget.TextView;
import androidx.annotation.StyleRes;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.dialog.BaseDialog;
import com.xuexiang.xui.widget.progress.loading.IMessageLoader;
import com.xuexiang.xui.widget.progress.loading.LoadingCancelListener;
import com.xuexiang.xui.widget.progress.loading.MiniLoadingView;

public class MiniLoadingDialog
extends BaseDialog
implements IMessageLoader {
    private MiniLoadingView mLoadingView;
    private TextView mTvTipMessage;
    private LoadingCancelListener mLoadingCancelListener;

    public MiniLoadingDialog(Context context) {
        super(context, R.style.XUIDialog_Custom_MiniLoading, R.layout.xui_dialog_loading_mini);
        this.initView(this.getString(R.string.xui_tip_loading_message));
    }

    public MiniLoadingDialog(Context context, String tipMessage) {
        super(context, R.style.XUIDialog_Custom_MiniLoading, R.layout.xui_dialog_loading_mini);
        this.initView(tipMessage);
    }

    public MiniLoadingDialog(Context context, @StyleRes int themeResId) {
        super(context, themeResId, R.layout.xui_dialog_loading_mini);
        this.initView(this.getString(R.string.xui_tip_loading_message));
    }

    public MiniLoadingDialog(Context context, @StyleRes int themeResId, String tipMessage) {
        super(context, themeResId, R.layout.xui_dialog_loading_mini);
        this.initView(tipMessage);
    }

    private void initView(String tipMessage) {
        this.mLoadingView = (MiniLoadingView)((Object)this.findViewById(R.id.mini_loading_view));
        this.mTvTipMessage = (TextView)this.findViewById(R.id.tv_tip_message);
        this.updateMessage(tipMessage);
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
    }

    @Override
    public void updateMessage(String tipMessage) {
        if (this.mTvTipMessage != null) {
            if (!TextUtils.isEmpty((CharSequence)tipMessage)) {
                this.mTvTipMessage.setText((CharSequence)tipMessage);
                this.mTvTipMessage.setVisibility(0);
            } else {
                this.mTvTipMessage.setText((CharSequence)"");
                this.mTvTipMessage.setVisibility(8);
            }
        }
    }

    @Override
    public void updateMessage(int tipMessageId) {
        this.updateMessage(this.getString(tipMessageId));
    }

    @Override
    protected void performShow() {
        super.performShow();
        if (this.mLoadingView != null) {
            this.mLoadingView.start();
        }
    }

    @Override
    public void dismiss() {
        if (this.mLoadingView != null) {
            this.mLoadingView.stop();
        }
        super.dismiss();
    }

    @Override
    public void recycle() {
    }

    @Override
    public boolean isLoading() {
        return this.isShowing();
    }

    @Override
    public void setCancelable(boolean flag) {
        super.setCancelable(flag);
        if (flag) {
            this.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialogInterface) {
                    if (MiniLoadingDialog.this.mLoadingCancelListener != null) {
                        MiniLoadingDialog.this.mLoadingCancelListener.onCancelLoading();
                    }
                }
            });
        }
    }

    @Override
    public void setLoadingCancelListener(LoadingCancelListener listener) {
        this.mLoadingCancelListener = listener;
    }
}

