/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;

public class GuideViewDialog
extends AlertDialog {
    private LinearLayout mGuideViewLayout;
    private ImageView mImageView;
    private int[] mResourceIdList;
    private int mIndex = 0;

    public GuideViewDialog(Context context) {
        super(context);
    }

    public GuideViewDialog(Context context, int theme) {
        super(context, theme);
    }

    public GuideViewDialog(Context context, int theme, int[] resourseIdList) {
        super(context, theme);
        this.mResourceIdList = resourseIdList;
    }

    public GuideViewDialog(Context context, int[] resourseIdList) {
        super(context);
        this.mResourceIdList = resourseIdList;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initView();
        this.setContentView((View)this.mGuideViewLayout);
    }

    private void initView() {
        this.mImageView = new ImageView(this.getContext());
        this.mImageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        if (this.mResourceIdList != null && this.mResourceIdList.length > 0) {
            this.mImageView.setImageResource(this.mResourceIdList[this.mIndex]);
            this.mImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (GuideViewDialog.this.mIndex == GuideViewDialog.this.mResourceIdList.length - 1) {
                        GuideViewDialog.this.dismiss();
                    } else {
                        GuideViewDialog.this.mIndex++;
                        GuideViewDialog.this.mImageView.setImageResource(GuideViewDialog.this.mResourceIdList[GuideViewDialog.this.mIndex]);
                    }
                }
            });
        }
        this.mGuideViewLayout = new LinearLayout(this.getContext());
        this.mGuideViewLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mGuideViewLayout.setOrientation(1);
        this.mGuideViewLayout.setGravity(17);
        this.mGuideViewLayout.addView((View)this.mImageView);
        this.setCanceledOnTouchOutside(true);
    }

    public void setResourseId(int[] resourseId) {
        this.mResourceIdList = resourseId;
    }

    public void dismiss() {
        if (this.mIndex == this.mResourceIdList.length - 1) {
            super.dismiss();
        } else {
            ++this.mIndex;
            this.mImageView.setImageResource(this.mResourceIdList[this.mIndex]);
        }
    }

    public void show(int pointX, int pointY) {
        Window win = this.getWindow();
        WindowManager.LayoutParams params = win.getAttributes();
        params.x = pointX;
        params.y = pointY;
        win.setAttributes(params);
        this.show();
    }

    public GuideViewDialog setDialogSize(int width, int height) {
        Window win = this.getWindow();
        if (win != null) {
            WindowManager.LayoutParams params = win.getAttributes();
            params.width = width;
            params.height = height;
            win.setAttributes(params);
        }
        return this;
    }

    public GuideViewDialog setGravity(int gravity) {
        Window win = this.getWindow();
        if (win != null) {
            WindowManager.LayoutParams params = win.getAttributes();
            params.gravity = gravity;
            win.setAttributes(params);
        }
        return this;
    }
}

