/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatDialog;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.KeyboardUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.StatusBarUtils;
import com.xuexiang.xui.utils.WidgetUtils;

public class BaseDialog
extends AppCompatDialog {
    private View mContentView;
    private boolean mIsSyncSystemUiVisibility;

    public BaseDialog(Context context, int layoutId) {
        this(context, R.style.XUIDialog_Custom, layoutId);
    }

    public BaseDialog(Context context, View contentView) {
        this(context, R.style.XUIDialog_Custom, contentView);
    }

    public BaseDialog(Context context) {
        super(context, R.style.XUIDialog_Custom);
    }

    public BaseDialog(Context context, int theme, int layoutId) {
        super(context, theme);
        this.init(layoutId);
    }

    public BaseDialog(Context context, int theme, View contentView) {
        super(context, theme);
        this.init(contentView);
    }

    public void init(int layoutId) {
        View view = this.getLayoutInflater().inflate(layoutId, null);
        this.init(view);
    }

    private void init(View view) {
        this.setContentView(view);
        this.mContentView = view;
        this.setCanceledOnTouchOutside(true);
    }

    public BaseDialog setDialogSize(int width, int height) {
        Window window = this.getWindow();
        if (window != null) {
            WindowManager.LayoutParams p = window.getAttributes();
            p.width = width;
            p.height = height;
            window.setAttributes(p);
        }
        return this;
    }

    public <T extends View> T findViewById(int resId) {
        return (T)this.mContentView.findViewById(resId);
    }

    public String getString(int resId) {
        return this.getContext().getResources().getString(resId);
    }

    public Drawable getDrawable(int resId) {
        return ResUtils.getDrawable(this.getContext(), resId);
    }

    public BaseDialog setIsSyncSystemUiVisibility(boolean isSyncSystemUiVisibility) {
        this.mIsSyncSystemUiVisibility = isSyncSystemUiVisibility;
        return this;
    }

    public void show() {
        this.showIfSync(this.mIsSyncSystemUiVisibility);
    }

    public void showIfSync(boolean isSyncSystemUiVisibility) {
        if (isSyncSystemUiVisibility) {
            boolean isHandled = StatusBarUtils.showWindow(WidgetUtils.findActivity(this.getContext()), this.getWindow(), new StatusBarUtils.IWindowShower(){

                @Override
                public void show(Window window) {
                    BaseDialog.this.performShow();
                }
            });
            if (!isHandled) {
                this.performShow();
            }
        } else {
            this.performShow();
        }
    }

    protected void performShow() {
        super.show();
    }

    public boolean onTouchEvent(@NonNull MotionEvent ev) {
        KeyboardUtils.dispatchTouchEvent(ev, (Dialog)this);
        return super.onTouchEvent(ev);
    }
}

