/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button.switchbutton;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.CompoundButton;
import androidx.core.content.ContextCompat;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.button.switchbutton.ColorUtils;

public class SwitchButton
extends CompoundButton {
    public static final float DEFAULT_THUMB_RANGE_RATIO = 1.8f;
    public static final int DEFAULT_THUMB_SIZE_DP = 20;
    public static final int DEFAULT_THUMB_MARGIN_DP = 2;
    public static final int DEFAULT_ANIMATION_DURATION = 250;
    public static final int DEFAULT_TINT_COLOR = 3309506;
    private static int[] CHECKED_PRESSED_STATE = new int[]{0x10100A0, 16842910, 16842919};
    private static int[] UNCHECKED_PRESSED_STATE = new int[]{-16842912, 16842910, 16842919};
    private Drawable mThumbDrawable;
    private Drawable mBackDrawable;
    private ColorStateList mBackColor;
    private ColorStateList mThumbColor;
    private float mThumbRadius;
    private float mBackRadius;
    private RectF mThumbMargin;
    private float mThumbRangeRatio;
    private long mAnimationDuration;
    private boolean mFadeBack;
    private int mTintColor;
    private int mThumbWidth;
    private int mThumbHeight;
    private int mBackWidth;
    private int mBackHeight;
    private int mCurrThumbColor;
    private int mCurrBackColor;
    private int mNextBackColor;
    private int mOnTextColor;
    private int mOffTextColor;
    private Drawable mCurrentBackDrawable;
    private Drawable mNextBackDrawable;
    private RectF mThumbRectF;
    private RectF mBackRectF;
    private RectF mSafeRectF;
    private RectF mTextOnRectF;
    private RectF mTextOffRectF;
    private Paint mPaint;
    private boolean mIsThumbUseDrawable;
    private boolean mIsBackUseDrawable;
    private boolean mDrawDebugRect = false;
    private ObjectAnimator mProgressAnimator;
    private float mProgress;
    private RectF mPresentThumbRectF;
    private float mStartX;
    private float mStartY;
    private float mLastX;
    private int mTouchSlop;
    private int mClickTimeout;
    private Paint mRectPaint;
    private CharSequence mTextOn;
    private CharSequence mTextOff;
    private TextPaint mTextPaint;
    private Layout mOnLayout;
    private Layout mOffLayout;
    private float mTextWidth;
    private float mTextHeight;
    private int mTextThumbInset;
    private int mTextExtra;
    private int mTextAdjust;
    private boolean mRestoring = false;
    private boolean mReady = false;
    private boolean mCatch = false;
    private CompoundButton.OnCheckedChangeListener mChildOnCheckedChangeListener;

    public SwitchButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    public SwitchButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SwitchButton(Context context) {
        super(context);
        this.init(context, null);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mClickTimeout = ViewConfiguration.getPressedStateDuration() + ViewConfiguration.getTapTimeout();
        this.mPaint = new Paint(1);
        this.mRectPaint = new Paint(1);
        this.mRectPaint.setStyle(Paint.Style.STROKE);
        this.mRectPaint.setStrokeWidth(this.getResources().getDisplayMetrics().density);
        this.mTextPaint = this.getPaint();
        this.mThumbRectF = new RectF();
        this.mBackRectF = new RectF();
        this.mSafeRectF = new RectF();
        this.mThumbMargin = new RectF();
        this.mTextOnRectF = new RectF();
        this.mTextOffRectF = new RectF();
        this.mProgressAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"progress", (float[])new float[]{0.0f, 0.0f}).setDuration(250L);
        this.mProgressAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mPresentThumbRectF = new RectF();
        Resources res = this.getResources();
        float density = res.getDisplayMetrics().density;
        float margin = density * 2.0f;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SwitchButton);
        Drawable thumbDrawable = ResUtils.getDrawableAttrRes(context, typedArray, R.styleable.SwitchButton_swb_thumbDrawable);
        ColorStateList thumbColor = ResUtils.getColorStateListAttrRes(context, typedArray, R.styleable.SwitchButton_swb_thumbColor);
        margin = typedArray.getDimension(R.styleable.SwitchButton_swb_thumbMargin, margin);
        float marginLeft = typedArray.getDimension(R.styleable.SwitchButton_swb_thumbMarginLeft, margin);
        float marginRight = typedArray.getDimension(R.styleable.SwitchButton_swb_thumbMarginRight, margin);
        float marginTop = typedArray.getDimension(R.styleable.SwitchButton_swb_thumbMarginTop, margin);
        float marginBottom = typedArray.getDimension(R.styleable.SwitchButton_swb_thumbMarginBottom, margin);
        float thumbWidth = typedArray.getDimension(R.styleable.SwitchButton_swb_thumbWidth, 0.0f);
        float thumbHeight = typedArray.getDimension(R.styleable.SwitchButton_swb_thumbHeight, 0.0f);
        float thumbRadius = typedArray.getDimension(R.styleable.SwitchButton_swb_thumbRadius, -1.0f);
        float backRadius = typedArray.getDimension(R.styleable.SwitchButton_swb_backRadius, -1.0f);
        Drawable backDrawable = ResUtils.getDrawableAttrRes(context, typedArray, R.styleable.SwitchButton_swb_backDrawable);
        ColorStateList backColor = ResUtils.getColorStateListAttrRes(context, typedArray, R.styleable.SwitchButton_swb_backColor);
        float thumbRangeRatio = typedArray.getFloat(R.styleable.SwitchButton_swb_thumbRangeRatio, 1.8f);
        int animationDuration = typedArray.getInteger(R.styleable.SwitchButton_swb_animationDuration, 250);
        boolean fadeBack = typedArray.getBoolean(R.styleable.SwitchButton_swb_fadeBack, true);
        int tintColor = typedArray.getColor(R.styleable.SwitchButton_swb_tintColor, 0);
        String textOn = typedArray.getString(R.styleable.SwitchButton_swb_textOn);
        String textOff = typedArray.getString(R.styleable.SwitchButton_swb_textOff);
        int textThumbInset = typedArray.getDimensionPixelSize(R.styleable.SwitchButton_swb_textThumbInset, 0);
        int textExtra = typedArray.getDimensionPixelSize(R.styleable.SwitchButton_swb_textExtra, 0);
        int textAdjust = typedArray.getDimensionPixelSize(R.styleable.SwitchButton_swb_textAdjust, 0);
        typedArray.recycle();
        typedArray = context.obtainStyledAttributes(attrs, new int[]{16842970, 16842981});
        boolean focusable = typedArray.getBoolean(0, true);
        boolean clickable = typedArray.getBoolean(1, focusable);
        this.setFocusable(focusable);
        this.setClickable(clickable);
        typedArray.recycle();
        this.mTextOn = textOn;
        this.mTextOff = textOff;
        this.mTextThumbInset = textThumbInset;
        this.mTextExtra = textExtra;
        this.mTextAdjust = textAdjust;
        this.mThumbDrawable = thumbDrawable;
        this.mThumbColor = thumbColor;
        this.mIsThumbUseDrawable = this.mThumbDrawable != null;
        this.mTintColor = tintColor;
        if (this.mTintColor == 0) {
            TypedValue typedValue = new TypedValue();
            boolean found = context.getTheme().resolveAttribute(R.attr.colorAccent, typedValue, true);
            this.mTintColor = found ? typedValue.data : 3309506;
        }
        if (!this.mIsThumbUseDrawable && this.mThumbColor == null) {
            this.mThumbColor = ColorUtils.generateThumbColorWithTintColor(this.mTintColor);
            this.mCurrThumbColor = this.mThumbColor.getDefaultColor();
        }
        this.mThumbWidth = this.ceil(thumbWidth);
        this.mThumbHeight = this.ceil(thumbHeight);
        this.mBackDrawable = backDrawable;
        this.mBackColor = backColor;
        boolean bl = this.mIsBackUseDrawable = this.mBackDrawable != null;
        if (!this.mIsBackUseDrawable && this.mBackColor == null) {
            this.mBackColor = ColorUtils.generateBackColorWithTintColor(this.mTintColor);
            this.mCurrBackColor = this.mBackColor.getDefaultColor();
            this.mNextBackColor = this.mBackColor.getColorForState(CHECKED_PRESSED_STATE, this.mCurrBackColor);
        }
        this.mThumbMargin.set(marginLeft, marginTop, marginRight, marginBottom);
        this.mThumbRangeRatio = this.mThumbMargin.width() >= 0.0f ? Math.max(thumbRangeRatio, 1.0f) : thumbRangeRatio;
        this.mThumbRadius = thumbRadius;
        this.mBackRadius = backRadius;
        this.mAnimationDuration = animationDuration;
        this.mFadeBack = fadeBack;
        this.mProgressAnimator.setDuration(this.mAnimationDuration);
        if (this.isChecked()) {
            this.setProgress(1.0f);
        }
    }

    private Layout makeLayout(CharSequence text) {
        return new StaticLayout(text, this.mTextPaint, (int)Math.ceil(Layout.getDesiredWidth((CharSequence)text, (TextPaint)this.mTextPaint)), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mOnLayout == null && !TextUtils.isEmpty((CharSequence)this.mTextOn)) {
            this.mOnLayout = this.makeLayout(this.mTextOn);
        }
        if (this.mOffLayout == null && !TextUtils.isEmpty((CharSequence)this.mTextOff)) {
            this.mOffLayout = this.makeLayout(this.mTextOff);
        }
        float onWidth = this.mOnLayout != null ? (float)this.mOnLayout.getWidth() : 0.0f;
        float offWidth = this.mOffLayout != null ? (float)this.mOffLayout.getWidth() : 0.0f;
        this.mTextWidth = onWidth != 0.0f || offWidth != 0.0f ? Math.max(onWidth, offWidth) : 0.0f;
        float onHeight = this.mOnLayout != null ? (float)this.mOnLayout.getHeight() : 0.0f;
        float offHeight = this.mOffLayout != null ? (float)this.mOffLayout.getHeight() : 0.0f;
        this.mTextHeight = onHeight != 0.0f || offHeight != 0.0f ? Math.max(onHeight, offHeight) : 0.0f;
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private int measureWidth(int widthMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int measuredWidth = widthSize;
        if (this.mThumbWidth == 0 && this.mIsThumbUseDrawable) {
            this.mThumbWidth = this.mThumbDrawable.getIntrinsicWidth();
        }
        int textWidth = this.ceil(this.mTextWidth);
        if (this.mThumbRangeRatio == 0.0f) {
            this.mThumbRangeRatio = 1.8f;
        }
        if (widthMode == 0x40000000) {
            int textExtraSpace;
            int moveRange;
            int contentSize = widthSize - this.getPaddingLeft() - this.getPaddingRight();
            if (this.mThumbWidth != 0) {
                moveRange = this.ceil((float)this.mThumbWidth * this.mThumbRangeRatio);
                textExtraSpace = textWidth + this.mTextExtra - (moveRange - this.mThumbWidth + this.ceil(Math.max(this.mThumbMargin.left, this.mThumbMargin.right)));
                this.mBackWidth = this.ceil((float)moveRange + this.mThumbMargin.left + this.mThumbMargin.right + (float)Math.max(textExtraSpace, 0));
                if (this.mBackWidth < 0) {
                    this.mThumbWidth = 0;
                }
                if ((float)moveRange + Math.max(this.mThumbMargin.left, 0.0f) + Math.max(this.mThumbMargin.right, 0.0f) + (float)Math.max(textExtraSpace, 0) > (float)contentSize) {
                    this.mThumbWidth = 0;
                }
            }
            if (this.mThumbWidth == 0) {
                contentSize = widthSize - this.getPaddingLeft() - this.getPaddingRight();
                moveRange = this.ceil((float)contentSize - Math.max(this.mThumbMargin.left, 0.0f) - Math.max(this.mThumbMargin.right, 0.0f));
                if (moveRange < 0) {
                    this.mThumbWidth = 0;
                    this.mBackWidth = 0;
                    return measuredWidth;
                }
                this.mThumbWidth = this.ceil((float)moveRange / this.mThumbRangeRatio);
                this.mBackWidth = this.ceil((float)moveRange + this.mThumbMargin.left + this.mThumbMargin.right);
                if (this.mBackWidth < 0) {
                    this.mThumbWidth = 0;
                    this.mBackWidth = 0;
                    return measuredWidth;
                }
                textExtraSpace = textWidth + this.mTextExtra - (moveRange - this.mThumbWidth + this.ceil(Math.max(this.mThumbMargin.left, this.mThumbMargin.right)));
                if (textExtraSpace > 0) {
                    this.mThumbWidth -= textExtraSpace;
                }
                if (this.mThumbWidth < 0) {
                    this.mThumbWidth = 0;
                    this.mBackWidth = 0;
                    return measuredWidth;
                }
            }
        } else {
            if (this.mThumbWidth == 0) {
                this.mThumbWidth = this.ceil(this.getResources().getDisplayMetrics().density * 20.0f);
            }
            if (this.mThumbRangeRatio == 0.0f) {
                this.mThumbRangeRatio = 1.8f;
            }
            int moveRange = this.ceil((float)this.mThumbWidth * this.mThumbRangeRatio);
            int textExtraSpace = this.ceil((float)(textWidth + this.mTextExtra) - ((float)(moveRange - this.mThumbWidth) + Math.max(this.mThumbMargin.left, this.mThumbMargin.right) + (float)this.mTextThumbInset));
            this.mBackWidth = this.ceil((float)moveRange + this.mThumbMargin.left + this.mThumbMargin.right + (float)Math.max(0, textExtraSpace));
            if (this.mBackWidth < 0) {
                this.mThumbWidth = 0;
                this.mBackWidth = 0;
                return measuredWidth;
            }
            int contentSize = this.ceil((float)moveRange + Math.max(0.0f, this.mThumbMargin.left) + Math.max(0.0f, this.mThumbMargin.right) + (float)Math.max(0, textExtraSpace));
            measuredWidth = Math.max(contentSize, contentSize + this.getPaddingLeft() + this.getPaddingRight());
        }
        return measuredWidth;
    }

    private int measureHeight(int heightMeasureSpec) {
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int measuredHeight = heightSize;
        if (this.mThumbHeight == 0 && this.mIsThumbUseDrawable) {
            this.mThumbHeight = this.mThumbDrawable.getIntrinsicHeight();
        }
        if (heightMode == 0x40000000) {
            if (this.mThumbHeight != 0) {
                this.mBackHeight = this.ceil((float)this.mThumbHeight + this.mThumbMargin.top + this.mThumbMargin.bottom);
                this.mBackHeight = this.ceil(Math.max((float)this.mBackHeight, this.mTextHeight));
                if ((float)(this.mBackHeight + this.getPaddingTop() + this.getPaddingBottom()) - Math.min(0.0f, this.mThumbMargin.top) - Math.min(0.0f, this.mThumbMargin.bottom) > (float)heightSize) {
                    this.mThumbHeight = 0;
                }
            }
            if (this.mThumbHeight == 0) {
                this.mBackHeight = this.ceil((float)(heightSize - this.getPaddingTop() - this.getPaddingBottom()) + Math.min(0.0f, this.mThumbMargin.top) + Math.min(0.0f, this.mThumbMargin.bottom));
                if (this.mBackHeight < 0) {
                    this.mBackHeight = 0;
                    this.mThumbHeight = 0;
                    return measuredHeight;
                }
                this.mThumbHeight = this.ceil((float)this.mBackHeight - this.mThumbMargin.top - this.mThumbMargin.bottom);
            }
            if (this.mThumbHeight < 0) {
                this.mBackHeight = 0;
                this.mThumbHeight = 0;
                return measuredHeight;
            }
        } else {
            if (this.mThumbHeight == 0) {
                this.mThumbHeight = this.ceil(this.getResources().getDisplayMetrics().density * 20.0f);
            }
            this.mBackHeight = this.ceil((float)this.mThumbHeight + this.mThumbMargin.top + this.mThumbMargin.bottom);
            if (this.mBackHeight < 0) {
                this.mBackHeight = 0;
                this.mThumbHeight = 0;
                return measuredHeight;
            }
            int textExtraSpace = this.ceil(this.mTextHeight - (float)this.mBackHeight);
            if (textExtraSpace > 0) {
                this.mBackHeight += textExtraSpace;
                this.mThumbHeight += textExtraSpace;
            }
            int contentSize = Math.max(this.mThumbHeight, this.mBackHeight);
            measuredHeight = Math.max(contentSize, contentSize + this.getPaddingTop() + this.getPaddingBottom());
            measuredHeight = Math.max(measuredHeight, this.getSuggestedMinimumHeight());
        }
        return measuredHeight;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw || h != oldh) {
            this.setup();
        }
    }

    private int ceil(double dimen2) {
        return (int)Math.ceil(dimen2);
    }

    private void setup() {
        if (this.mThumbWidth == 0 || this.mThumbHeight == 0 || this.mBackWidth == 0 || this.mBackHeight == 0) {
            return;
        }
        if (this.mThumbRadius == -1.0f) {
            this.mThumbRadius = (float)Math.min(this.mThumbWidth, this.mThumbHeight) / 2.0f;
        }
        if (this.mBackRadius == -1.0f) {
            this.mBackRadius = (float)Math.min(this.mBackWidth, this.mBackHeight) / 2.0f;
        }
        int contentWidth = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int contentHeight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int drawingWidth = this.ceil((float)this.mBackWidth - Math.min(0.0f, this.mThumbMargin.left) - Math.min(0.0f, this.mThumbMargin.right));
        int drawingHeight = this.ceil((float)this.mBackHeight - Math.min(0.0f, this.mThumbMargin.top) - Math.min(0.0f, this.mThumbMargin.bottom));
        float thumbTop = contentHeight <= drawingHeight ? (float)this.getPaddingTop() + Math.max(0.0f, this.mThumbMargin.top) : (float)this.getPaddingTop() + Math.max(0.0f, this.mThumbMargin.top) + (float)(contentHeight - drawingHeight + 1) / 2.0f;
        float thumbLeft = contentWidth <= this.mBackWidth ? (float)this.getPaddingLeft() + Math.max(0.0f, this.mThumbMargin.left) : (float)this.getPaddingLeft() + Math.max(0.0f, this.mThumbMargin.left) + (float)(contentWidth - drawingWidth + 1) / 2.0f;
        this.mThumbRectF.set(thumbLeft, thumbTop, thumbLeft + (float)this.mThumbWidth, thumbTop + (float)this.mThumbHeight);
        float backLeft = this.mThumbRectF.left - this.mThumbMargin.left;
        this.mBackRectF.set(backLeft, this.mThumbRectF.top - this.mThumbMargin.top, backLeft + (float)this.mBackWidth, this.mThumbRectF.top - this.mThumbMargin.top + (float)this.mBackHeight);
        this.mSafeRectF.set(this.mThumbRectF.left, 0.0f, this.mBackRectF.right - this.mThumbMargin.right - this.mThumbRectF.width(), 0.0f);
        float minBackRadius = Math.min(this.mBackRectF.width(), this.mBackRectF.height()) / 2.0f;
        this.mBackRadius = Math.min(minBackRadius, this.mBackRadius);
        if (this.mBackDrawable != null) {
            this.mBackDrawable.setBounds((int)this.mBackRectF.left, (int)this.mBackRectF.top, this.ceil(this.mBackRectF.right), this.ceil(this.mBackRectF.bottom));
        }
        if (this.mOnLayout != null) {
            float onLeft = this.mBackRectF.left + (this.mBackRectF.width() + (float)this.mTextThumbInset - (float)this.mThumbWidth - this.mThumbMargin.right - (float)this.mOnLayout.getWidth()) / 2.0f - (float)this.mTextAdjust;
            float onTop = this.mBackRectF.top + (this.mBackRectF.height() - (float)this.mOnLayout.getHeight()) / 2.0f;
            this.mTextOnRectF.set(onLeft, onTop, onLeft + (float)this.mOnLayout.getWidth(), onTop + (float)this.mOnLayout.getHeight());
        }
        if (this.mOffLayout != null) {
            float offLeft = this.mBackRectF.right - (this.mBackRectF.width() + (float)this.mTextThumbInset - (float)this.mThumbWidth - this.mThumbMargin.left - (float)this.mOffLayout.getWidth()) / 2.0f - (float)this.mOffLayout.getWidth() + (float)this.mTextAdjust;
            float offTop = this.mBackRectF.top + (this.mBackRectF.height() - (float)this.mOffLayout.getHeight()) / 2.0f;
            this.mTextOffRectF.set(offLeft, offTop, offLeft + (float)this.mOffLayout.getWidth(), offTop + (float)this.mOffLayout.getHeight());
        }
        this.mReady = true;
    }

    protected void onDraw(Canvas canvas) {
        RectF textRectF;
        int alpha;
        super.onDraw(canvas);
        if (!this.mReady) {
            this.setup();
        }
        if (!this.mReady) {
            return;
        }
        if (this.mIsBackUseDrawable) {
            if (this.mFadeBack && this.mCurrentBackDrawable != null && this.mNextBackDrawable != null) {
                Drawable below = this.isChecked() ? this.mCurrentBackDrawable : this.mNextBackDrawable;
                Drawable above = this.isChecked() ? this.mNextBackDrawable : this.mCurrentBackDrawable;
                alpha = (int)(255.0f * this.getProgress());
                below.setAlpha(alpha);
                below.draw(canvas);
                alpha = 255 - alpha;
                above.setAlpha(alpha);
                above.draw(canvas);
            } else {
                this.mBackDrawable.setAlpha(255);
                this.mBackDrawable.draw(canvas);
            }
        } else if (this.mFadeBack) {
            int belowColor = this.isChecked() ? this.mCurrBackColor : this.mNextBackColor;
            int aboveColor = this.isChecked() ? this.mNextBackColor : this.mCurrBackColor;
            int alpha2 = (int)(255.0f * this.getProgress());
            int colorAlpha = Color.alpha((int)belowColor);
            colorAlpha = colorAlpha * alpha2 / 255;
            this.mPaint.setARGB(colorAlpha, Color.red((int)belowColor), Color.green((int)belowColor), Color.blue((int)belowColor));
            canvas.drawRoundRect(this.mBackRectF, this.mBackRadius, this.mBackRadius, this.mPaint);
            alpha2 = 255 - alpha2;
            colorAlpha = Color.alpha((int)aboveColor);
            colorAlpha = colorAlpha * alpha2 / 255;
            this.mPaint.setARGB(colorAlpha, Color.red((int)aboveColor), Color.green((int)aboveColor), Color.blue((int)aboveColor));
            canvas.drawRoundRect(this.mBackRectF, this.mBackRadius, this.mBackRadius, this.mPaint);
            this.mPaint.setAlpha(255);
        } else {
            this.mPaint.setColor(this.mCurrBackColor);
            canvas.drawRoundRect(this.mBackRectF, this.mBackRadius, this.mBackRadius, this.mPaint);
        }
        Layout switchText = (double)this.getProgress() > 0.5 ? this.mOnLayout : this.mOffLayout;
        RectF rectF = textRectF = (double)this.getProgress() > 0.5 ? this.mTextOnRectF : this.mTextOffRectF;
        if (switchText != null && textRectF != null) {
            alpha = (int)(255.0f * ((double)this.getProgress() >= 0.75 ? this.getProgress() * 4.0f - 3.0f : ((double)this.getProgress() < 0.25 ? 1.0f - this.getProgress() * 4.0f : 0.0f)));
            int textColor = (double)this.getProgress() > 0.5 ? this.mOnTextColor : this.mOffTextColor;
            int colorAlpha = Color.alpha((int)textColor);
            colorAlpha = colorAlpha * alpha / 255;
            switchText.getPaint().setARGB(colorAlpha, Color.red((int)textColor), Color.green((int)textColor), Color.blue((int)textColor));
            canvas.save();
            canvas.translate(textRectF.left, textRectF.top);
            switchText.draw(canvas);
            canvas.restore();
        }
        this.mPresentThumbRectF.set(this.mThumbRectF);
        this.mPresentThumbRectF.offset(this.mProgress * this.mSafeRectF.width(), 0.0f);
        if (this.mIsThumbUseDrawable) {
            this.mThumbDrawable.setBounds((int)this.mPresentThumbRectF.left, (int)this.mPresentThumbRectF.top, this.ceil(this.mPresentThumbRectF.right), this.ceil(this.mPresentThumbRectF.bottom));
            this.mThumbDrawable.draw(canvas);
        } else {
            this.mPaint.setColor(this.mCurrThumbColor);
            canvas.drawRoundRect(this.mPresentThumbRectF, this.mThumbRadius, this.mThumbRadius, this.mPaint);
        }
        if (this.mDrawDebugRect) {
            this.mRectPaint.setColor(Color.parseColor((String)"#AA0000"));
            canvas.drawRect(this.mBackRectF, this.mRectPaint);
            this.mRectPaint.setColor(Color.parseColor((String)"#0000FF"));
            canvas.drawRect(this.mPresentThumbRectF, this.mRectPaint);
            this.mRectPaint.setColor(Color.parseColor((String)"#000000"));
            canvas.drawLine(this.mSafeRectF.left, this.mThumbRectF.top, this.mSafeRectF.right, this.mThumbRectF.top, this.mRectPaint);
            this.mRectPaint.setColor(Color.parseColor((String)"#00CC00"));
            canvas.drawRect((double)this.getProgress() > 0.5 ? this.mTextOnRectF : this.mTextOffRectF, this.mRectPaint);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (!this.mIsThumbUseDrawable && this.mThumbColor != null) {
            this.mCurrThumbColor = this.mThumbColor.getColorForState(this.getDrawableState(), this.mCurrThumbColor);
        } else {
            this.setDrawableState(this.mThumbDrawable);
        }
        int[] nextState = this.isChecked() ? UNCHECKED_PRESSED_STATE : CHECKED_PRESSED_STATE;
        ColorStateList textColors = this.getTextColors();
        if (textColors != null) {
            int defaultTextColor = textColors.getDefaultColor();
            this.mOnTextColor = textColors.getColorForState(CHECKED_PRESSED_STATE, defaultTextColor);
            this.mOffTextColor = textColors.getColorForState(UNCHECKED_PRESSED_STATE, defaultTextColor);
        }
        if (!this.mIsBackUseDrawable && this.mBackColor != null) {
            this.mCurrBackColor = this.mBackColor.getColorForState(this.getDrawableState(), this.mCurrBackColor);
            this.mNextBackColor = this.mBackColor.getColorForState(nextState, this.mCurrBackColor);
        } else {
            if (this.mBackDrawable instanceof StateListDrawable && this.mFadeBack) {
                this.mBackDrawable.setState(nextState);
                this.mNextBackDrawable = this.mBackDrawable.getCurrent().mutate();
            } else {
                this.mNextBackDrawable = null;
            }
            this.setDrawableState(this.mBackDrawable);
            if (this.mBackDrawable != null) {
                this.mCurrentBackDrawable = this.mBackDrawable.getCurrent().mutate();
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!(this.isEnabled() && this.isClickable() && this.isFocusable() && this.mReady)) {
            return false;
        }
        int action = event.getAction();
        float deltaX = event.getX() - this.mStartX;
        float deltaY = event.getY() - this.mStartY;
        switch (action) {
            case 0: {
                this.mStartX = event.getX();
                this.mStartY = event.getY();
                this.mLastX = this.mStartX;
                this.setPressed(true);
                break;
            }
            case 2: {
                float x = event.getX();
                this.setProgress(this.getProgress() + (x - this.mLastX) / this.mSafeRectF.width());
                if (!this.mCatch && (Math.abs(deltaX) > (float)this.mTouchSlop / 2.0f || Math.abs(deltaY) > (float)this.mTouchSlop / 2.0f)) {
                    if (deltaY == 0.0f || Math.abs(deltaX) > Math.abs(deltaY)) {
                        this.catchView();
                    } else if (Math.abs(deltaY) > Math.abs(deltaX)) {
                        return false;
                    }
                }
                this.mLastX = x;
                break;
            }
            case 1: 
            case 3: {
                this.mCatch = false;
                this.setPressed(false);
                float time = event.getEventTime() - event.getDownTime();
                if (Math.abs(deltaX) < (float)this.mTouchSlop && Math.abs(deltaY) < (float)this.mTouchSlop && time < (float)this.mClickTimeout) {
                    this.performClick();
                    break;
                }
                boolean nextStatus = this.getStatusBasedOnPos();
                if (nextStatus != this.isChecked()) {
                    this.playSoundEffect(0);
                    this.setChecked(nextStatus);
                    break;
                }
                this.animateToState(nextStatus);
                break;
            }
        }
        return true;
    }

    private boolean getStatusBasedOnPos() {
        return this.getProgress() > 0.5f;
    }

    private float getProgress() {
        return this.mProgress;
    }

    private void setProgress(float progress) {
        float tp = progress;
        if (tp > 1.0f) {
            tp = 1.0f;
        } else if (tp < 0.0f) {
            tp = 0.0f;
        }
        this.mProgress = tp;
        this.invalidate();
    }

    public boolean performClick() {
        return super.performClick();
    }

    protected void animateToState(boolean checked) {
        if (this.mProgressAnimator == null) {
            return;
        }
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
        }
        this.mProgressAnimator.setDuration(this.mAnimationDuration);
        if (checked) {
            this.mProgressAnimator.setFloatValues(new float[]{this.mProgress, 1.0f});
        } else {
            this.mProgressAnimator.setFloatValues(new float[]{this.mProgress, 0.0f});
        }
        this.mProgressAnimator.start();
    }

    private void catchView() {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
        this.mCatch = true;
    }

    public void setChecked(boolean checked) {
        if (this.isChecked() != checked) {
            this.animateToState(checked);
        }
        if (this.mRestoring) {
            this.setCheckedImmediatelyNoEvent(checked);
        } else {
            super.setChecked(checked);
        }
    }

    public void setCheckedNoEvent(boolean checked) {
        if (this.mChildOnCheckedChangeListener == null) {
            this.setChecked(checked);
        } else {
            super.setOnCheckedChangeListener(null);
            this.setChecked(checked);
            super.setOnCheckedChangeListener(this.mChildOnCheckedChangeListener);
        }
    }

    public void setCheckedImmediatelyNoEvent(boolean checked) {
        if (this.mChildOnCheckedChangeListener == null) {
            this.setCheckedImmediately(checked);
        } else {
            super.setOnCheckedChangeListener(null);
            this.setCheckedImmediately(checked);
            super.setOnCheckedChangeListener(this.mChildOnCheckedChangeListener);
        }
    }

    public void toggleNoEvent() {
        if (this.mChildOnCheckedChangeListener == null) {
            this.toggle();
        } else {
            super.setOnCheckedChangeListener(null);
            this.toggle();
            super.setOnCheckedChangeListener(this.mChildOnCheckedChangeListener);
        }
    }

    public void toggleImmediatelyNoEvent() {
        if (this.mChildOnCheckedChangeListener == null) {
            this.toggleImmediately();
        } else {
            super.setOnCheckedChangeListener(null);
            this.toggleImmediately();
            super.setOnCheckedChangeListener(this.mChildOnCheckedChangeListener);
        }
    }

    public void setOnCheckedChangeListener(CompoundButton.OnCheckedChangeListener onCheckedChangeListener) {
        super.setOnCheckedChangeListener(onCheckedChangeListener);
        this.mChildOnCheckedChangeListener = onCheckedChangeListener;
    }

    public void setCheckedImmediately(boolean checked) {
        super.setChecked(checked);
        if (this.mProgressAnimator != null && this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
        }
        this.setProgress(checked ? 1.0f : 0.0f);
        this.invalidate();
    }

    public void toggleImmediately() {
        this.setCheckedImmediately(!this.isChecked());
    }

    private void setDrawableState(Drawable drawable2) {
        if (drawable2 != null) {
            int[] myDrawableState = this.getDrawableState();
            drawable2.setState(myDrawableState);
            this.invalidate();
        }
    }

    public boolean isDrawDebugRect() {
        return this.mDrawDebugRect;
    }

    public void setDrawDebugRect(boolean drawDebugRect) {
        this.mDrawDebugRect = drawDebugRect;
        this.invalidate();
    }

    public long getAnimationDuration() {
        return this.mAnimationDuration;
    }

    public void setAnimationDuration(long animationDuration) {
        this.mAnimationDuration = animationDuration;
    }

    public Drawable getThumbDrawable() {
        return this.mThumbDrawable;
    }

    public void setThumbDrawable(Drawable thumbDrawable) {
        this.mThumbDrawable = thumbDrawable;
        this.mIsThumbUseDrawable = this.mThumbDrawable != null;
        this.refreshDrawableState();
        this.mReady = false;
        this.requestLayout();
        this.invalidate();
    }

    public void setThumbDrawableRes(int thumbDrawableRes) {
        this.setThumbDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)thumbDrawableRes));
    }

    public Drawable getBackDrawable() {
        return this.mBackDrawable;
    }

    public void setBackDrawable(Drawable backDrawable) {
        this.mBackDrawable = backDrawable;
        this.mIsBackUseDrawable = this.mBackDrawable != null;
        this.refreshDrawableState();
        this.mReady = false;
        this.requestLayout();
        this.invalidate();
    }

    public void setBackDrawableRes(int backDrawableRes) {
        this.setBackDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)backDrawableRes));
    }

    public ColorStateList getBackColor() {
        return this.mBackColor;
    }

    public void setBackColor(ColorStateList backColor) {
        this.mBackColor = backColor;
        if (this.mBackColor != null) {
            this.setBackDrawable(null);
        }
        this.invalidate();
    }

    public void setBackColorRes(int backColorRes) {
        this.setBackColor(ContextCompat.getColorStateList((Context)this.getContext(), (int)backColorRes));
    }

    public ColorStateList getThumbColor() {
        return this.mThumbColor;
    }

    public void setThumbColor(ColorStateList thumbColor) {
        this.mThumbColor = thumbColor;
        if (this.mThumbColor != null) {
            this.setThumbDrawable(null);
        }
        this.invalidate();
    }

    public void setThumbColorRes(int thumbColorRes) {
        this.setThumbColor(ContextCompat.getColorStateList((Context)this.getContext(), (int)thumbColorRes));
    }

    public float getThumbRangeRatio() {
        return this.mThumbRangeRatio;
    }

    public void setThumbRangeRatio(float thumbRangeRatio) {
        this.mThumbRangeRatio = thumbRangeRatio;
        this.mReady = false;
        this.requestLayout();
    }

    public RectF getThumbMargin() {
        return this.mThumbMargin;
    }

    public void setThumbMargin(RectF thumbMargin) {
        if (thumbMargin == null) {
            this.setThumbMargin(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            this.setThumbMargin(thumbMargin.left, thumbMargin.top, thumbMargin.right, thumbMargin.bottom);
        }
    }

    public void setThumbMargin(float left, float top, float right, float bottom) {
        this.mThumbMargin.set(left, top, right, bottom);
        this.mReady = false;
        this.requestLayout();
    }

    public void setThumbSize(int width, int height) {
        this.mThumbWidth = width;
        this.mThumbHeight = height;
        this.mReady = false;
        this.requestLayout();
    }

    public float getThumbWidth() {
        return this.mThumbWidth;
    }

    public float getThumbHeight() {
        return this.mThumbHeight;
    }

    public float getThumbRadius() {
        return this.mThumbRadius;
    }

    public void setThumbRadius(float thumbRadius) {
        this.mThumbRadius = thumbRadius;
        if (!this.mIsThumbUseDrawable) {
            this.invalidate();
        }
    }

    public PointF getBackSizeF() {
        return new PointF(this.mBackRectF.width(), this.mBackRectF.height());
    }

    public float getBackRadius() {
        return this.mBackRadius;
    }

    public void setBackRadius(float backRadius) {
        this.mBackRadius = backRadius;
        if (!this.mIsBackUseDrawable) {
            this.invalidate();
        }
    }

    public boolean isFadeBack() {
        return this.mFadeBack;
    }

    public void setFadeBack(boolean fadeBack) {
        this.mFadeBack = fadeBack;
    }

    public int getTintColor() {
        return this.mTintColor;
    }

    public void setTintColor(int tintColor) {
        this.mTintColor = tintColor;
        this.mThumbColor = ColorUtils.generateThumbColorWithTintColor(this.mTintColor);
        this.mBackColor = ColorUtils.generateBackColorWithTintColor(this.mTintColor);
        this.mIsBackUseDrawable = false;
        this.mIsThumbUseDrawable = false;
        this.refreshDrawableState();
        this.invalidate();
    }

    public void setText(CharSequence onText, CharSequence offText) {
        this.mTextOn = onText;
        this.mTextOff = offText;
        this.mOnLayout = null;
        this.mOffLayout = null;
        this.mReady = false;
        this.requestLayout();
        this.invalidate();
    }

    public CharSequence getTextOn() {
        return this.mTextOn;
    }

    public CharSequence getTextOff() {
        return this.mTextOff;
    }

    public void setTextThumbInset(int textThumbInset) {
        this.mTextThumbInset = textThumbInset;
        this.mReady = false;
        this.requestLayout();
        this.invalidate();
    }

    public void setTextExtra(int textExtra) {
        this.mTextExtra = textExtra;
        this.mReady = false;
        this.requestLayout();
        this.invalidate();
    }

    public void setTextAdjust(int textAdjust) {
        this.mTextAdjust = textAdjust;
        this.mReady = false;
        this.requestLayout();
        this.invalidate();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.onText = this.mTextOn;
        ss.offText = this.mTextOff;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.setText(ss.onText, ss.offText);
        this.mRestoring = true;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mRestoring = false;
    }

    static class SavedState
    extends View.BaseSavedState {
        CharSequence onText;
        CharSequence offText;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.onText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.offText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            TextUtils.writeToParcel((CharSequence)this.onText, (Parcel)out, (int)flags);
            TextUtils.writeToParcel((CharSequence)this.offText, (Parcel)out, (int)flags);
        }
    }
}

