/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button.shinebutton;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.xuexiang.xui.widget.button.shinebutton.ShineAnimator;
import com.xuexiang.xui.widget.button.shinebutton.ShineButton;
import com.xuexiang.xui.widget.button.shinebutton.interpolator.Ease;
import com.xuexiang.xui.widget.button.shinebutton.interpolator.EasingInterpolator;
import java.lang.ref.WeakReference;
import java.util.Random;

public class ShineView
extends View {
    private static final long FRAME_REFRESH_DELAY = 25L;
    private ShineAnimator mShineAnimator;
    private ValueAnimator mClickAnimator;
    private WeakReference<ShineButton> mShineButton;
    private Paint mPaint;
    private Paint mPaint2;
    private Paint mPaintSmall;
    private int mColorCount = 10;
    private static int[] sColorRandom = new int[10];
    private int mShineCount;
    private float mSmallOffsetAngle;
    private float mTurnAngle;
    private long mAnimDuration;
    private long mClickAnimDuration;
    private float mShineDistanceMultiple;
    private int mSmallShineColor = sColorRandom[0];
    private int mBigShineColor = sColorRandom[1];
    private int mShineSize = 0;
    private boolean mAllowRandomColor = false;
    private boolean mEnableFlashing = false;
    private RectF mRectF = new RectF();
    private RectF mSmallRectF = new RectF();
    private Random mRandom = new Random();
    private int mCenterAnimX;
    private int mCenterAnimY;
    private int mBtnWidth;
    private int mBtnHeight;
    private float mValue;
    private float mClickValue = 0.0f;
    private boolean mIsAnimating = false;
    private float mDistanceOffset = 0.2f;

    public ShineView(Context context) {
        super(context);
    }

    public ShineView(Context context, ShineButton shineButton, ShineParams shineParams) {
        super(context);
        this.initShineParams(shineParams, shineButton);
        this.mShineButton = new WeakReference<ShineButton>(shineButton);
        this.mShineAnimator = new ShineAnimator(this.mAnimDuration, this.mShineDistanceMultiple, this.mClickAnimDuration);
        ValueAnimator.setFrameDelay((long)25L);
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mBigShineColor);
        this.mPaint.setStrokeWidth(20.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint2 = new Paint();
        this.mPaint2.setColor(-1);
        this.mPaint2.setStrokeWidth(20.0f);
        this.mPaint2.setStrokeCap(Paint.Cap.ROUND);
        this.mPaintSmall = new Paint();
        this.mPaintSmall.setColor(this.mSmallShineColor);
        this.mPaintSmall.setStrokeWidth(10.0f);
        this.mPaintSmall.setStyle(Paint.Style.STROKE);
        this.mPaintSmall.setStrokeCap(Paint.Cap.ROUND);
        this.mClickAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.1f});
        ValueAnimator.setFrameDelay((long)25L);
        this.mClickAnimator.setDuration(this.mClickAnimDuration);
        this.mClickAnimator.setInterpolator((TimeInterpolator)new EasingInterpolator(Ease.QUART_OUT));
        this.mClickAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ShineView.this.mClickValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                ShineView.this.invalidate();
            }
        });
        this.mClickAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                ShineView.this.mClickValue = 0.0f;
                ShineView.this.invalidate();
            }
        });
        this.mShineAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                if (ShineView.this.mShineButton != null && ShineView.this.mShineButton.get() != null) {
                    ((ShineButton)((Object)ShineView.this.mShineButton.get())).removeView(ShineView.this);
                }
            }
        });
    }

    public ShineView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ShineView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void showAnimation(ShineButton shineButton) {
        if (shineButton == null) {
            return;
        }
        this.mBtnWidth = shineButton.getWidth();
        this.mBtnHeight = shineButton.getHeight();
        int[] location = new int[2];
        shineButton.getLocationInWindow(location);
        this.mCenterAnimX = location[0] + shineButton.getWidth() / 2;
        this.mCenterAnimY = location[1] + shineButton.getHeight() / 2;
        if (shineButton.getWindow() != null) {
            View decor = shineButton.getWindow().getDecorView();
            this.mCenterAnimX -= decor.getPaddingLeft();
            this.mCenterAnimY -= decor.getPaddingTop();
        }
        this.mShineAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ShineView.this.mValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                if (ShineView.this.mShineSize != 0 && ShineView.this.mShineSize > 0) {
                    ShineView.this.mPaint.setStrokeWidth((float)ShineView.this.mShineSize * (ShineView.this.mShineDistanceMultiple - ShineView.this.mValue));
                    ShineView.this.mPaintSmall.setStrokeWidth((float)ShineView.this.mShineSize / 3.0f * 2.0f * (ShineView.this.mShineDistanceMultiple - ShineView.this.mValue));
                } else {
                    ShineView.this.mPaint.setStrokeWidth((float)ShineView.this.mBtnWidth / 2.0f * (ShineView.this.mShineDistanceMultiple - ShineView.this.mValue));
                    ShineView.this.mPaintSmall.setStrokeWidth((float)ShineView.this.mBtnWidth / 3.0f * (ShineView.this.mShineDistanceMultiple - ShineView.this.mValue));
                }
                ShineView.this.mRectF.set((float)ShineView.this.mCenterAnimX - (float)ShineView.this.mBtnWidth / (3.0f - ShineView.this.mShineDistanceMultiple) * ShineView.this.mValue, (float)ShineView.this.mCenterAnimY - (float)ShineView.this.mBtnHeight / (3.0f - ShineView.this.mShineDistanceMultiple) * ShineView.this.mValue, (float)ShineView.this.mCenterAnimX + (float)ShineView.this.mBtnWidth / (3.0f - ShineView.this.mShineDistanceMultiple) * ShineView.this.mValue, (float)ShineView.this.mCenterAnimY + (float)ShineView.this.mBtnHeight / (3.0f - ShineView.this.mShineDistanceMultiple) * ShineView.this.mValue);
                ShineView.this.mSmallRectF.set((float)ShineView.this.mCenterAnimX - (float)ShineView.this.mBtnWidth / (3.0f - ShineView.this.mShineDistanceMultiple + ShineView.this.mDistanceOffset) * ShineView.this.mValue, (float)ShineView.this.mCenterAnimY - (float)ShineView.this.mBtnHeight / (3.0f - ShineView.this.mShineDistanceMultiple + ShineView.this.mDistanceOffset) * ShineView.this.mValue, (float)ShineView.this.mCenterAnimX + (float)ShineView.this.mBtnWidth / (3.0f - ShineView.this.mShineDistanceMultiple + ShineView.this.mDistanceOffset) * ShineView.this.mValue, (float)ShineView.this.mCenterAnimY + (float)ShineView.this.mBtnHeight / (3.0f - ShineView.this.mShineDistanceMultiple + ShineView.this.mDistanceOffset) * ShineView.this.mValue);
                ShineView.this.invalidate();
            }
        });
        this.mShineAnimator.start();
        this.mClickAnimator.start();
    }

    protected void onDraw(Canvas canvas) {
        int i;
        super.onDraw(canvas);
        for (i = 0; i < this.mShineCount; ++i) {
            if (this.mAllowRandomColor) {
                this.mPaint.setColor(sColorRandom[Math.abs(this.mColorCount / 2 - i) >= this.mColorCount ? this.mColorCount - 1 : Math.abs(this.mColorCount / 2 - i)]);
            }
            canvas.drawArc(this.mRectF, 360.0f / (float)this.mShineCount * (float)i + 1.0f + (this.mValue - 1.0f) * this.mTurnAngle, 0.1f, false, this.getConfigPaint(this.mPaint));
        }
        for (i = 0; i < this.mShineCount; ++i) {
            if (this.mAllowRandomColor) {
                this.mPaint.setColor(sColorRandom[Math.abs(this.mColorCount / 2 - i) >= this.mColorCount ? this.mColorCount - 1 : Math.abs(this.mColorCount / 2 - i)]);
            }
            canvas.drawArc(this.mSmallRectF, 360.0f / (float)this.mShineCount * (float)i + 1.0f - this.mSmallOffsetAngle + (this.mValue - 1.0f) * this.mTurnAngle, 0.1f, false, this.getConfigPaint(this.mPaintSmall));
        }
        this.mPaint.setStrokeWidth((float)this.mBtnWidth * this.mClickValue * (this.mShineDistanceMultiple - this.mDistanceOffset));
        if (this.mClickValue != 0.0f) {
            this.mPaint2.setStrokeWidth((float)this.mBtnWidth * this.mClickValue * (this.mShineDistanceMultiple - this.mDistanceOffset) - 8.0f);
        } else {
            this.mPaint2.setStrokeWidth(0.0f);
        }
        canvas.drawPoint((float)this.mCenterAnimX, (float)this.mCenterAnimY, this.mPaint);
        canvas.drawPoint((float)this.mCenterAnimX, (float)this.mCenterAnimY, this.mPaint2);
        if (this.mShineAnimator != null && !this.mIsAnimating) {
            this.mIsAnimating = true;
            this.showAnimation((ShineButton)((Object)this.mShineButton.get()));
        }
    }

    private Paint getConfigPaint(Paint paint) {
        if (this.mEnableFlashing) {
            paint.setColor(sColorRandom[this.mRandom.nextInt(this.mColorCount - 1)]);
        }
        return paint;
    }

    private void initShineParams(ShineParams shineParams, ShineButton shineButton) {
        this.mShineCount = shineParams.shineCount;
        this.mTurnAngle = shineParams.shineTurnAngle;
        this.mSmallOffsetAngle = shineParams.smallShineOffsetAngle;
        this.mEnableFlashing = shineParams.enableFlashing;
        this.mAllowRandomColor = shineParams.allowRandomColor;
        this.mShineDistanceMultiple = shineParams.shineDistanceMultiple;
        this.mAnimDuration = shineParams.animDuration;
        this.mClickAnimDuration = shineParams.clickAnimDuration;
        this.mSmallShineColor = shineParams.smallShineColor;
        this.mBigShineColor = shineParams.bigShineColor;
        this.mShineSize = shineParams.shineSize;
        if (this.mSmallShineColor == 0) {
            this.mSmallShineColor = sColorRandom[6];
        }
        if (this.mBigShineColor == 0) {
            this.mBigShineColor = shineButton.getColor();
        }
    }

    public static class ShineParams {
        public boolean allowRandomColor = false;
        public long animDuration = 1500L;
        public int bigShineColor = 0;
        public long clickAnimDuration = 200L;
        public boolean enableFlashing = false;
        public int shineCount = 7;
        public float shineTurnAngle = 20.0f;
        public float shineDistanceMultiple = 1.5f;
        public float smallShineOffsetAngle = 20.0f;
        public int smallShineColor = 0;
        public int shineSize = 0;

        ShineParams() {
            sColorRandom[0] = Color.parseColor((String)"#FFFF99");
            sColorRandom[1] = Color.parseColor((String)"#FFCCCC");
            sColorRandom[2] = Color.parseColor((String)"#996699");
            sColorRandom[3] = Color.parseColor((String)"#FF6666");
            sColorRandom[4] = Color.parseColor((String)"#FFFF66");
            sColorRandom[5] = Color.parseColor((String)"#F44336");
            sColorRandom[6] = Color.parseColor((String)"#666666");
            sColorRandom[7] = Color.parseColor((String)"#CCCC00");
            sColorRandom[8] = Color.parseColor((String)"#666666");
            sColorRandom[9] = Color.parseColor((String)"#999933");
        }
    }
}

