/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button.shinebutton;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.animation.LinearInterpolator;
import android.widget.Checkable;
import androidx.fragment.app.Fragment;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.button.shinebutton.PorterShapeImageView;
import com.xuexiang.xui.widget.button.shinebutton.ShineView;
import java.lang.ref.WeakReference;

public class ShineButton
extends PorterShapeImageView
implements Checkable {
    private boolean mIsChecked = false;
    private int mNormalColor;
    private int mCheckedColor;
    private ValueAnimator mShakeAnimator;
    private ShineView.ShineParams mShineParams = new ShineView.ShineParams();
    private OnCheckedChangeListener mOnCheckedChangeListener;
    WeakReference<Window> mWindow;
    private boolean mIsDialog;
    private OnClickListenWrapper mOnClickListenWrapper;

    public ShineButton(Context context) {
        this(context, null);
    }

    public ShineButton(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.ShineButtonStyle);
    }

    public ShineButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initButton(context, attrs, defStyleAttr);
    }

    private void initButton(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ShineButton, defStyleAttr, 0);
        this.mNormalColor = a.getColor(R.styleable.ShineButton_sb_normal_color, ResUtils.getColor(context, R.color.default_sb_normal_color));
        this.mCheckedColor = a.getColor(R.styleable.ShineButton_sb_checked_color, ThemeUtils.getMainThemeColor(context));
        this.mShineParams.allowRandomColor = a.getBoolean(R.styleable.ShineButton_sb_allow_random_color, false);
        this.mShineParams.animDuration = a.getInteger(R.styleable.ShineButton_sb_shine_animation_duration, (int)this.mShineParams.animDuration);
        this.mShineParams.clickAnimDuration = a.getInteger(R.styleable.ShineButton_sb_click_animation_duration, (int)this.mShineParams.clickAnimDuration);
        this.mShineParams.enableFlashing = a.getBoolean(R.styleable.ShineButton_sb_enable_flashing, false);
        this.mShineParams.shineDistanceMultiple = a.getFloat(R.styleable.ShineButton_sb_shine_distance_multiple, this.mShineParams.shineDistanceMultiple);
        this.mShineParams.shineCount = a.getInteger(R.styleable.ShineButton_sb_shine_count, this.mShineParams.shineCount);
        this.mShineParams.shineSize = a.getDimensionPixelSize(R.styleable.ShineButton_sb_shine_size, this.mShineParams.shineSize);
        this.mShineParams.shineTurnAngle = a.getFloat(R.styleable.ShineButton_sb_shine_turn_angle, this.mShineParams.shineTurnAngle);
        this.mShineParams.smallShineOffsetAngle = a.getFloat(R.styleable.ShineButton_sb_small_shine_offset_angle, this.mShineParams.smallShineOffsetAngle);
        this.mShineParams.smallShineColor = a.getColor(R.styleable.ShineButton_sb_small_shine_color, this.mShineParams.smallShineColor);
        this.mShineParams.bigShineColor = a.getColor(R.styleable.ShineButton_sb_big_shine_color, this.mShineParams.bigShineColor);
        a.recycle();
        this.setTintColor(this.mNormalColor);
        if (context instanceof Activity) {
            this.initWindow((Activity)context);
        }
    }

    public void fitDialog(Dialog dialog) {
        this.mWindow = new WeakReference<Window>(dialog.getWindow());
        this.mIsDialog = true;
    }

    public void fitFragment(Fragment fragment) {
        this.initWindow((Activity)fragment.getActivity());
    }

    public int getColor() {
        return this.mCheckedColor;
    }

    public boolean isChecked() {
        return this.mIsChecked;
    }

    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    public ShineButton setNormalColor(int normalColor) {
        this.mNormalColor = normalColor;
        this.setTintColor(this.mNormalColor);
        return this;
    }

    public ShineButton setCheckedColor(int checkedColor) {
        this.mCheckedColor = checkedColor;
        return this;
    }

    public void setChecked(boolean checked, boolean anim2) {
        this.setChecked(checked, anim2, true);
    }

    private void setChecked(boolean checked, boolean anim2, boolean callBack) {
        this.mIsChecked = checked;
        if (checked) {
            this.setTintColor(this.mCheckedColor);
            this.mIsChecked = true;
            if (anim2) {
                this.showAnim();
            }
        } else {
            this.setTintColor(this.mNormalColor);
            this.mIsChecked = false;
            if (anim2) {
                this.setCancel();
            }
        }
        if (callBack) {
            this.onCheckedChanged(checked);
        }
    }

    public void setChecked(boolean checked) {
        this.setChecked(checked, false, false);
    }

    private void onCheckedChanged(boolean checked) {
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, checked);
        }
    }

    public void setCancel() {
        this.setTintColor(this.mNormalColor);
        if (this.mShakeAnimator != null) {
            this.mShakeAnimator.end();
            this.mShakeAnimator.cancel();
        }
    }

    public ShineButton setAllowRandomColor(boolean allowRandomColor) {
        this.mShineParams.allowRandomColor = allowRandomColor;
        return this;
    }

    public ShineButton setAnimDuration(int durationMs) {
        this.mShineParams.animDuration = durationMs;
        return this;
    }

    public ShineButton setBigShineColor(int color2) {
        this.mShineParams.bigShineColor = color2;
        return this;
    }

    public ShineButton setClickAnimDuration(int durationMs) {
        this.mShineParams.clickAnimDuration = durationMs;
        return this;
    }

    public ShineButton enableFlashing(boolean enable) {
        this.mShineParams.enableFlashing = enable;
        return this;
    }

    public ShineButton setShineCount(int count) {
        this.mShineParams.shineCount = count;
        return this;
    }

    public ShineButton setShineDistanceMultiple(float multiple) {
        this.mShineParams.shineDistanceMultiple = multiple;
        return this;
    }

    public ShineButton setShineTurnAngle(float angle) {
        this.mShineParams.shineTurnAngle = angle;
        return this;
    }

    public ShineButton setSmallShineColor(int color2) {
        this.mShineParams.smallShineColor = color2;
        return this;
    }

    public ShineButton setSmallShineOffAngle(float angle) {
        this.mShineParams.smallShineOffsetAngle = angle;
        return this;
    }

    public ShineButton setShineSize(int size) {
        this.mShineParams.shineSize = size;
        return this;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        if (listener instanceof OnClickListenWrapper) {
            super.setOnClickListener(listener);
        } else if (this.mOnClickListenWrapper != null) {
            this.mOnClickListenWrapper.wrapListener(listener);
        }
    }

    public void initWindow(Activity activity) {
        this.initWindow(activity.getWindow());
        this.mIsDialog = false;
    }

    public void initWindow(Window window) {
        this.mWindow = new WeakReference<Window>(window);
        this.mOnClickListenWrapper = new OnClickListenWrapper();
        this.setOnClickListener(this.mOnClickListenWrapper);
    }

    public void showAnim() {
        if (this.getWindow() != null) {
            ShineView shineView = new ShineView(this.getContext(), this, this.mShineParams);
            ViewGroup rootView = (ViewGroup)this.getWindow().getDecorView();
            if (this.mIsDialog) {
                View innerView = rootView.findViewById(0x1020002);
                rootView.addView((View)shineView, new ViewGroup.LayoutParams(innerView.getWidth(), innerView.getHeight()));
            } else {
                rootView.addView((View)shineView, new ViewGroup.LayoutParams(rootView.getWidth(), rootView.getHeight()));
            }
            this.doShareAnim();
        }
    }

    public void removeView(View view) {
        if (this.getWindow() != null) {
            ViewGroup rootView = (ViewGroup)this.getWindow().findViewById(0x1020002);
            rootView.removeView(view);
        }
    }

    public Window getWindow() {
        if (this.mWindow != null) {
            return (Window)this.mWindow.get();
        }
        return null;
    }

    public ShineButton setIconResource(int resId) {
        this.setIconDrawable(ResUtils.getDrawable(this.getContext(), resId));
        return this;
    }

    private void doShareAnim() {
        this.mShakeAnimator = ValueAnimator.ofFloat((float[])new float[]{0.4f, 1.0f, 0.9f, 1.0f});
        this.mShakeAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mShakeAnimator.setDuration(500L);
        this.mShakeAnimator.setStartDelay(180L);
        this.invalidate();
        this.mShakeAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ShineButton.this.setScaleX(((Float)valueAnimator.getAnimatedValue()).floatValue());
                ShineButton.this.setScaleY(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        this.mShakeAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                ShineButton.this.setTintColor(ShineButton.this.mCheckedColor);
            }

            public void onAnimationEnd(Animator animator) {
                ShineButton.this.setTintColor(ShineButton.this.mIsChecked ? ShineButton.this.mCheckedColor : ShineButton.this.mNormalColor);
            }

            public void onAnimationCancel(Animator animator) {
                ShineButton.this.setTintColor(ShineButton.this.mNormalColor);
            }
        });
        this.mShakeAnimator.start();
    }

    public ShineButton setOnCheckStateChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
        return this;
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(ShineButton var1, boolean var2);
    }

    public class OnClickListenWrapper
    implements View.OnClickListener {
        private View.OnClickListener mListener;

        public void wrapListener(View.OnClickListener listener) {
            this.mListener = listener;
        }

        OnClickListenWrapper() {
        }

        public OnClickListenWrapper(View.OnClickListener listener) {
            this.mListener = listener;
        }

        public void onClick(View view) {
            if (!ShineButton.this.mIsChecked) {
                ShineButton.this.mIsChecked = true;
                ShineButton.this.showAnim();
            } else {
                ShineButton.this.mIsChecked = false;
                ShineButton.this.setCancel();
            }
            ShineButton.this.onCheckedChanged(ShineButton.this.mIsChecked);
            if (this.mListener != null) {
                this.mListener.onClick(view);
            }
        }
    }
}

