/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button.shinebutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.button.shinebutton.PorterImageView;

public class PorterShapeImageView
extends PorterImageView {
    private Drawable mIconDrawable;
    private Matrix mMatrix;
    private Matrix mDrawMatrix;

    public PorterShapeImageView(Context context) {
        this(context, null);
    }

    public PorterShapeImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PorterShapeImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        if (attrs != null) {
            TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.PorterShapeImageView, defStyleAttr, 0);
            this.mIconDrawable = ResUtils.getDrawableAttrRes(this.getContext(), array, R.styleable.PorterShapeImageView_sb_icon_image);
            array.recycle();
        }
        this.mMatrix = new Matrix();
    }

    public void setIconDrawable(Drawable drawable2) {
        this.mIconDrawable = drawable2;
        this.invalidate();
    }

    @Override
    protected void paintMaskCanvas(Canvas maskCanvas, Paint maskPaint, int width, int height) {
        if (this.mIconDrawable != null) {
            if (this.mIconDrawable instanceof BitmapDrawable) {
                this.configureBitmapBounds(this.getWidth(), this.getHeight());
                if (this.mDrawMatrix != null) {
                    int drawableSaveCount = maskCanvas.getSaveCount();
                    maskCanvas.save();
                    maskCanvas.concat(this.mMatrix);
                    this.mIconDrawable.draw(maskCanvas);
                    maskCanvas.restoreToCount(drawableSaveCount);
                    return;
                }
            }
            this.mIconDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.mIconDrawable.draw(maskCanvas);
        }
    }

    private void configureBitmapBounds(int viewWidth, int viewHeight) {
        boolean fits;
        this.mDrawMatrix = null;
        int drawableWidth = this.mIconDrawable.getIntrinsicWidth();
        int drawableHeight = this.mIconDrawable.getIntrinsicHeight();
        boolean bl = fits = viewWidth == drawableWidth && viewHeight == drawableHeight;
        if (drawableWidth > 0 && drawableHeight > 0 && !fits) {
            this.mIconDrawable.setBounds(0, 0, drawableWidth, drawableHeight);
            float widthRatio = (float)viewWidth / (float)drawableWidth;
            float heightRatio = (float)viewHeight / (float)drawableHeight;
            float scale = Math.min(widthRatio, heightRatio);
            float dx = (int)(((float)viewWidth - (float)drawableWidth * scale) * 0.5f + 0.5f);
            float dy = (int)(((float)viewHeight - (float)drawableHeight * scale) * 0.5f + 0.5f);
            this.mMatrix.setScale(scale, scale);
            this.mMatrix.postTranslate(dx, dy);
        }
    }
}

