/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button.shinebutton;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;

public abstract class PorterImageView
extends AppCompatImageView {
    private static final PorterDuffXfermode PORTER_DUFF_XFERMODE = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
    private Canvas mMaskCanvas;
    private Bitmap mMaskBitmap;
    private Paint mMaskPaint;
    private Canvas mDrawableCanvas;
    private Bitmap mDrawableBitmap;
    private Paint mDrawablePaint;
    private int mPaintColor = -7829368;
    private boolean mInvalidated = true;

    public PorterImageView(Context context) {
        super(context);
        this.init();
    }

    public PorterImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PorterImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        if (this.getScaleType() == ImageView.ScaleType.FIT_CENTER) {
            this.setScaleType(ImageView.ScaleType.CENTER_CROP);
        }
        this.mMaskPaint = new Paint(1);
        this.mMaskPaint.setColor(-16777216);
    }

    public void setTintColor(int color2) {
        this.mPaintColor = color2;
        this.setImageDrawable((Drawable)new ColorDrawable(color2));
        if (this.mDrawablePaint != null) {
            this.mDrawablePaint.setColor(color2);
            this.invalidate();
        }
    }

    public void invalidate() {
        this.mInvalidated = true;
        super.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.createMaskCanvas(w, h, oldw, oldh);
    }

    private void createMaskCanvas(int width, int height, int oldw, int oldh) {
        boolean sizeChanged;
        boolean bl = sizeChanged = width != oldw || height != oldh;
        if (width > 0 && height > 0 && (this.mMaskCanvas == null || sizeChanged)) {
            this.mMaskCanvas = new Canvas();
            this.mMaskBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mMaskCanvas.setBitmap(this.mMaskBitmap);
            this.mMaskPaint.reset();
            this.paintMaskCanvas(this.mMaskCanvas, this.mMaskPaint, width, height);
            this.mDrawableCanvas = new Canvas();
            this.mDrawableBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mDrawableCanvas.setBitmap(this.mDrawableBitmap);
            this.mDrawablePaint = new Paint(1);
            this.mDrawablePaint.setColor(this.mPaintColor);
            this.mInvalidated = true;
        }
    }

    protected abstract void paintMaskCanvas(Canvas var1, Paint var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas canvas) {
        int saveCount = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
        try {
            Drawable drawable2;
            if (this.mInvalidated && (drawable2 = this.getDrawable()) != null) {
                this.mInvalidated = false;
                Matrix imageMatrix = this.getImageMatrix();
                if (imageMatrix == null) {
                    drawable2.draw(this.mDrawableCanvas);
                } else {
                    int drawableSaveCount = this.mDrawableCanvas.getSaveCount();
                    this.mDrawableCanvas.save();
                    this.mDrawableCanvas.concat(imageMatrix);
                    drawable2.draw(this.mDrawableCanvas);
                    this.mDrawableCanvas.restoreToCount(drawableSaveCount);
                }
                this.mDrawablePaint.reset();
                this.mDrawablePaint.setFilterBitmap(false);
                this.mDrawablePaint.setXfermode((Xfermode)PORTER_DUFF_XFERMODE);
                this.mDrawableCanvas.drawBitmap(this.mMaskBitmap, 0.0f, 0.0f, this.mDrawablePaint);
            }
            if (!this.mInvalidated) {
                this.mDrawablePaint.setXfermode(null);
                canvas.drawBitmap(this.mDrawableBitmap, 0.0f, 0.0f, this.mDrawablePaint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            canvas.restoreToCount(saveCount);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (widthMeasureSpec == 0) {
            widthMeasureSpec = 50;
        }
        if (heightMeasureSpec == 0) {
            heightMeasureSpec = 50;
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

