/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button.shadowbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.button.shadowbutton.BaseShadowButton;
import java.util.Timer;
import java.util.TimerTask;

public class RippleShadowShadowButton
extends BaseShadowButton {
    private int mRoundRadius;
    private int mRippleColor;
    private int mRippleDuration;
    private int mRippleRadius;
    private float pointX;
    private float pointY;
    private Paint mRipplePaint;
    private RectF mRectF;
    private Path mPath;
    private Timer mTimer;
    private TimerTask mTask;
    private int mRippleAlpha;
    private static final int RIPPLE_ALPHA = 47;

    public RippleShadowShadowButton(Context context) {
        super(context);
    }

    public RippleShadowShadowButton(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
    }

    public RippleShadowShadowButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init(Context context, AttributeSet attrs) {
        super.init(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShadowButton);
        this.mRippleColor = typedArray.getColor(R.styleable.ShadowButton_sb_ripple_color, this.getResources().getColor(R.color.default_shadow_button_ripple_color));
        this.mRippleAlpha = typedArray.getInteger(R.styleable.ShadowButton_sb_ripple_alpha, 47);
        this.mRippleDuration = typedArray.getInteger(R.styleable.ShadowButton_sb_ripple_duration, 1000);
        this.mShapeType = typedArray.getInt(R.styleable.ShadowButton_sb_shape_type, 1);
        this.mRoundRadius = typedArray.getDimensionPixelSize(R.styleable.ShadowButton_sb_radius, this.getResources().getDimensionPixelSize(R.dimen.default_shadow_button_radius));
        typedArray.recycle();
        this.mRipplePaint = new Paint();
        this.mRipplePaint.setColor(this.mRippleColor);
        this.mRipplePaint.setAlpha(this.mRippleAlpha);
        this.mRipplePaint.setStyle(Paint.Style.FILL);
        this.mRipplePaint.setAntiAlias(true);
        this.mPath = new Path();
        this.mRectF = new RectF();
        this.pointX = -1.0f;
        this.pointY = -1.0f;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mRipplePaint == null) {
            return;
        }
        this.drawFillCircle(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.pointX = event.getX();
            this.pointY = event.getY();
            this.onStartDrawRipple();
        }
        return super.onTouchEvent(event);
    }

    private void drawFillCircle(Canvas canvas) {
        if (canvas != null && this.pointX >= 0.0f && this.pointY >= 0.0f) {
            float yMax;
            int rbX = canvas.getWidth();
            int rbY = canvas.getHeight();
            float xMax = Math.max(this.pointX, Math.abs((float)rbX - this.pointX));
            float longDis = (float)Math.sqrt(xMax * xMax + (yMax = Math.max(this.pointY, Math.abs((float)rbY - this.pointY))) * yMax);
            if ((float)this.mRippleRadius > longDis) {
                this.onCompleteDrawRipple();
                return;
            }
            float drawSpeed = longDis / (float)this.mRippleDuration * 35.0f;
            this.mRippleRadius = (int)((float)this.mRippleRadius + drawSpeed);
            canvas.save();
            this.mPath.reset();
            canvas.clipPath(this.mPath);
            if (this.mShapeType == 0) {
                this.mPath.addCircle((float)(rbX >> 1), (float)(rbY >> 1), (float)(this.mWidth >> 1), Path.Direction.CCW);
            } else {
                this.mRectF.set(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
                this.mPath.addRoundRect(this.mRectF, (float)this.mRoundRadius, (float)this.mRoundRadius, Path.Direction.CCW);
            }
            if (Build.VERSION.SDK_INT >= 26) {
                canvas.clipPath(this.mPath);
            } else {
                canvas.clipPath(this.mPath, Region.Op.REPLACE);
            }
            canvas.drawCircle(this.pointX, this.pointY, (float)this.mRippleRadius, this.mRipplePaint);
            canvas.restore();
        }
    }

    private void onStartDrawRipple() {
        this.onCompleteDrawRipple();
        this.mTask = new TimerTask(){

            @Override
            public void run() {
                RippleShadowShadowButton.this.postInvalidate();
            }
        };
        this.mTimer = new Timer();
        this.mTimer.schedule(this.mTask, 0L, 30L);
    }

    private void onCompleteDrawRipple() {
        if (this.mTimer != null) {
            if (this.mTask != null) {
                this.mTask.cancel();
            }
            this.mTimer.cancel();
        }
        this.mRippleRadius = 0;
    }

    protected void onDetachedFromWindow() {
        this.onCompleteDrawRipple();
        super.onDetachedFromWindow();
    }

    public int getRoundRadius() {
        return this.mRoundRadius;
    }

    public void setRoundRadius(int roundRadius) {
        this.mRoundRadius = roundRadius;
        this.invalidate();
    }

    public int getRippleColor() {
        return this.mRippleColor;
    }

    public void setRippleColor(int rippleColor) {
        this.mRippleColor = rippleColor;
    }

    public int getRippleDuration() {
        return this.mRippleDuration;
    }

    public void setRippleDuration(int rippleDuration) {
        this.mRippleDuration = rippleDuration;
    }

    public int getRippleRadius() {
        return this.mRippleRadius;
    }

    public void setRippleRadius(int rippleRadius) {
        this.mRippleRadius = rippleRadius;
    }

    public int getRippleAlpha() {
        return this.mRippleAlpha;
    }

    public void setRippleAlpha(int rippleAlpha) {
        this.mRippleAlpha = rippleAlpha;
    }
}

