/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button.roundbutton;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;

public class RoundDrawable
extends GradientDrawable {
    private boolean mRadiusAdjustBounds = true;
    private ColorStateList mFillColors;
    private int mStrokeWidth = 0;
    private ColorStateList mStrokeColors;

    public void setBgData(@Nullable ColorStateList colors) {
        if (this.hasNativeStateListAPI()) {
            super.setColor(colors);
        } else {
            this.mFillColors = colors;
            int currentColor = colors == null ? 0 : colors.getColorForState(this.getState(), 0);
            this.setColor(currentColor);
        }
    }

    public void setStrokeData(int width, @Nullable ColorStateList colors) {
        if (this.hasNativeStateListAPI()) {
            super.setStroke(width, colors);
        } else {
            this.mStrokeWidth = width;
            this.mStrokeColors = colors;
            int currentColor = colors == null ? 0 : colors.getColorForState(this.getState(), 0);
            this.setStroke(width, currentColor);
        }
    }

    private boolean hasNativeStateListAPI() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public void setIsRadiusAdjustBounds(boolean isRadiusAdjustBounds) {
        this.mRadiusAdjustBounds = isRadiusAdjustBounds;
    }

    protected boolean onStateChange(int[] stateSet) {
        int color2;
        boolean superRet = super.onStateChange(stateSet);
        if (this.mFillColors != null) {
            color2 = this.mFillColors.getColorForState(stateSet, 0);
            this.setColor(color2);
            superRet = true;
        }
        if (this.mStrokeColors != null) {
            color2 = this.mStrokeColors.getColorForState(stateSet, 0);
            this.setStroke(this.mStrokeWidth, color2);
            superRet = true;
        }
        return superRet;
    }

    public boolean isStateful() {
        return this.mFillColors != null && this.mFillColors.isStateful() || this.mStrokeColors != null && this.mStrokeColors.isStateful() || super.isStateful();
    }

    protected void onBoundsChange(Rect r) {
        super.onBoundsChange(r);
        if (this.mRadiusAdjustBounds) {
            this.setCornerRadius((float)Math.min(r.width(), r.height()) / 2.0f);
        }
    }

    public static RoundDrawable fromAttributeSet(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RoundButton);
        ColorStateList colorBg = ResUtils.getColorStateListAttrRes(context, typedArray, R.styleable.RoundButton_rb_backgroundColor);
        ColorStateList colorBorder = ResUtils.getColorStateListAttrRes(context, typedArray, R.styleable.RoundButton_rb_borderColor);
        int borderWidth = typedArray.getDimensionPixelSize(R.styleable.RoundButton_rb_borderWidth, ResUtils.getDimensionPixelSize(context, R.dimen.default_rb_border_width));
        boolean isRadiusAdjustBounds = typedArray.getBoolean(R.styleable.RoundButton_rb_isRadiusAdjustBounds, false);
        int mRadius = typedArray.getDimensionPixelSize(R.styleable.RoundButton_rb_radius, ResUtils.getDimensionPixelSize(context, R.dimen.default_rb_radius));
        int mRadiusTopLeft = typedArray.getDimensionPixelSize(R.styleable.RoundButton_rb_radiusTopLeft, 0);
        int mRadiusTopRight = typedArray.getDimensionPixelSize(R.styleable.RoundButton_rb_radiusTopRight, 0);
        int mRadiusBottomLeft = typedArray.getDimensionPixelSize(R.styleable.RoundButton_rb_radiusBottomLeft, 0);
        int mRadiusBottomRight = typedArray.getDimensionPixelSize(R.styleable.RoundButton_rb_radiusBottomRight, 0);
        typedArray.recycle();
        RoundDrawable bg = new RoundDrawable();
        bg.setBgData(colorBg);
        bg.setStrokeData(borderWidth, colorBorder);
        bg.setIsRadiusAdjustBounds(isRadiusAdjustBounds);
        if (mRadiusTopLeft > 0 || mRadiusTopRight > 0 || mRadiusBottomLeft > 0 || mRadiusBottomRight > 0) {
            float[] radii = new float[]{mRadiusTopLeft, mRadiusTopLeft, mRadiusTopRight, mRadiusTopRight, mRadiusBottomRight, mRadiusBottomRight, mRadiusBottomLeft, mRadiusBottomLeft};
            bg.setCornerRadii(radii);
        } else {
            bg.setCornerRadius(mRadius);
        }
        return bg;
    }
}

