/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button;

import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Region;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ThemeUtils;

public class SwitchIconView
extends AppCompatImageView {
    private static final int DEFAULT_ANIMATION_DURATION = 300;
    private static final float DASH_THICKNESS_PART = 0.083333336f;
    private static final float DEFAULT_DISABLED_ALPHA = 0.5f;
    private static final float SIN_45 = (float)Math.sin(Math.toRadians(45.0));
    private final long mAnimationDuration;
    @FloatRange(from=0.0, to=1.0)
    private final float mDisabledStateAlpha;
    private final int mDashXStart;
    private final int mDashYStart;
    private final Path mClipPath;
    private final int mIconTintColor;
    private final int mDisabledStateColor;
    private final boolean mNoDash;
    private int mDashThickness;
    private int mDashLengthXProjection;
    private int mDashLengthYProjection;
    private PorterDuffColorFilter mColorFilter;
    private final ArgbEvaluator mColorEvaluator = new ArgbEvaluator();
    @FloatRange(from=0.0, to=1.0)
    private float mFraction = 0.0f;
    private boolean mEnabled;
    @NonNull
    private final Paint mDashPaint;
    @NonNull
    private final Point mDashStart = new Point();
    @NonNull
    private final Point mDashEnd = new Point();

    public SwitchIconView(@NonNull Context context) {
        this(context, null);
    }

    public SwitchIconView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.SwitchIconViewStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwitchIconView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayerType(1, null);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.SwitchIconView, defStyleAttr, 0);
        try {
            this.mIconTintColor = array.getColor(R.styleable.SwitchIconView_siv_tint_color, ThemeUtils.getMainThemeColor(context));
            this.mAnimationDuration = array.getInteger(R.styleable.SwitchIconView_siv_animation_duration, 300);
            this.mDisabledStateAlpha = array.getFloat(R.styleable.SwitchIconView_siv_disabled_alpha, 0.5f);
            this.mDisabledStateColor = array.getColor(R.styleable.SwitchIconView_siv_disabled_color, this.mIconTintColor);
            this.mEnabled = array.getBoolean(R.styleable.SwitchIconView_siv_enabled, true);
            this.mNoDash = array.getBoolean(R.styleable.SwitchIconView_siv_no_dash, false);
        }
        finally {
            array.recycle();
        }
        if (this.mDisabledStateAlpha < 0.0f || this.mDisabledStateAlpha > 1.0f) {
            throw new IllegalArgumentException("Wrong value for si_disabled_alpha [" + this.mDisabledStateAlpha + "]. Must be value from range [0, 1]");
        }
        this.mColorFilter = new PorterDuffColorFilter(this.mIconTintColor, PorterDuff.Mode.SRC_IN);
        this.setColorFilter((ColorFilter)this.mColorFilter);
        this.mDashXStart = this.getPaddingLeft();
        this.mDashYStart = this.getPaddingTop();
        this.mDashPaint = new Paint(1);
        this.mDashPaint.setStyle(Paint.Style.STROKE);
        this.mDashPaint.setColor(this.mIconTintColor);
        this.mClipPath = new Path();
        this.initDashCoordinates();
        this.setFraction(this.mEnabled ? 0.0f : 1.0f);
    }

    public void setIconEnabled(boolean enabled) {
        this.setIconEnabled(enabled, true);
    }

    public void setIconEnabled(boolean enabled, boolean animate) {
        if (this.mEnabled == enabled) {
            return;
        }
        this.switchState(animate);
    }

    public boolean isIconEnabled() {
        return this.mEnabled;
    }

    public void switchState() {
        this.switchState(true);
    }

    public void switchState(boolean animate) {
        float newFraction = this.mEnabled ? 1.0f : 0.0f;
        boolean bl = this.mEnabled = !this.mEnabled;
        if (animate) {
            this.animateToFraction(newFraction);
        } else {
            this.setFraction(newFraction);
            this.invalidate();
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SwitchIconSavedState savedState = new SwitchIconSavedState(superState);
        savedState.iconEnabled = this.mEnabled;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SwitchIconSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SwitchIconSavedState savedState = (SwitchIconSavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mEnabled = savedState.iconEnabled;
        this.setFraction(this.mEnabled ? 0.0f : 1.0f);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.mDashLengthXProjection = width - this.getPaddingLeft() - this.getPaddingRight();
        this.mDashLengthYProjection = height - this.getPaddingTop() - this.getPaddingBottom();
        this.mDashThickness = (int)(0.083333336f * (float)(this.mDashLengthXProjection + this.mDashLengthYProjection) / 2.0f);
        this.mDashPaint.setStrokeWidth((float)this.mDashThickness);
        this.initDashCoordinates();
        this.updateClipPath();
    }

    protected void onDraw(Canvas canvas) {
        if (!this.mNoDash) {
            this.drawDash(canvas);
            if (Build.VERSION.SDK_INT >= 26) {
                canvas.clipOutPath(this.mClipPath);
            } else {
                canvas.clipPath(this.mClipPath, Region.Op.XOR);
            }
        }
        super.onDraw(canvas);
    }

    private void animateToFraction(float toFraction) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.mFraction, toFraction});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SwitchIconView.this.setFraction(((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.setDuration(this.mAnimationDuration);
        animator.start();
    }

    private void setFraction(float fraction) {
        this.mFraction = fraction;
        this.updateColor(fraction);
        this.updateAlpha(fraction);
        this.updateClipPath();
        this.postInvalidateOnAnimationCompat();
    }

    private void initDashCoordinates() {
        float delta1 = 1.5f * SIN_45 * (float)this.mDashThickness;
        float delta2 = 0.5f * SIN_45 * (float)this.mDashThickness;
        this.mDashStart.x = (int)((float)this.mDashXStart + delta2);
        this.mDashStart.y = this.mDashYStart + (int)delta1;
        this.mDashEnd.x = (int)((float)(this.mDashXStart + this.mDashLengthXProjection) - delta1);
        this.mDashEnd.y = (int)((float)(this.mDashYStart + this.mDashLengthYProjection) - delta2);
    }

    private void updateClipPath() {
        float delta = (float)this.mDashThickness / SIN_45;
        this.mClipPath.reset();
        this.mClipPath.moveTo((float)this.mDashXStart, (float)this.mDashYStart + delta);
        this.mClipPath.lineTo((float)this.mDashXStart + delta, (float)this.mDashYStart);
        this.mClipPath.lineTo((float)this.mDashXStart + (float)this.mDashLengthXProjection * this.mFraction, (float)this.mDashYStart + (float)this.mDashLengthYProjection * this.mFraction - delta);
        this.mClipPath.lineTo((float)this.mDashXStart + (float)this.mDashLengthXProjection * this.mFraction - delta, (float)this.mDashYStart + (float)this.mDashLengthYProjection * this.mFraction);
    }

    private void drawDash(Canvas canvas) {
        float x = this.mFraction * (float)(this.mDashEnd.x - this.mDashStart.x) + (float)this.mDashStart.x;
        float y = this.mFraction * (float)(this.mDashEnd.y - this.mDashStart.y) + (float)this.mDashStart.y;
        canvas.drawLine((float)this.mDashStart.x, (float)this.mDashStart.y, x, y, this.mDashPaint);
    }

    private void updateColor(float fraction) {
        if (this.mIconTintColor != this.mDisabledStateColor) {
            int color2 = (Integer)this.mColorEvaluator.evaluate(fraction, (Object)this.mIconTintColor, (Object)this.mDisabledStateColor);
            this.updateImageColor(color2);
            this.mDashPaint.setColor(color2);
        }
    }

    private void updateAlpha(float fraction) {
        int alpha = (int)((this.mDisabledStateAlpha + (1.0f - fraction) * (1.0f - this.mDisabledStateAlpha)) * 255.0f);
        this.updateImageAlpha(alpha);
        this.mDashPaint.setAlpha(alpha);
    }

    private void updateImageColor(int color2) {
        this.mColorFilter = new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_IN);
        this.setColorFilter((ColorFilter)this.mColorFilter);
    }

    private void updateImageAlpha(int alpha) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setImageAlpha(alpha);
        } else {
            this.setAlpha(alpha);
        }
    }

    private void postInvalidateOnAnimationCompat() {
        long fakeFrameTime = 10L;
        if (Build.VERSION.SDK_INT > 15) {
            this.postInvalidateOnAnimation();
        } else {
            this.postInvalidateDelayed(10L);
        }
    }

    static class SwitchIconSavedState
    extends View.BaseSavedState {
        boolean iconEnabled;
        public static final Parcelable.Creator<SwitchIconSavedState> CREATOR = new Parcelable.Creator<SwitchIconSavedState>(){

            public SwitchIconSavedState createFromParcel(Parcel in) {
                return new SwitchIconSavedState(in);
            }

            public SwitchIconSavedState[] newArray(int size) {
                return new SwitchIconSavedState[size];
            }
        };

        SwitchIconSavedState(Parcelable superState) {
            super(superState);
        }

        private SwitchIconSavedState(Parcel in) {
            super(in);
            int enabled = in.readInt();
            this.iconEnabled = enabled == 1;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.iconEnabled ? 1 : 0);
        }
    }
}

