/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.AppCompatButton;
import com.xuexiang.xui.R;
import java.util.Locale;

public class CountDownButton
extends AppCompatButton {
    private static final int DEFAULT_INTERVAL = 1000;
    private static final int DEFAULT_COUNTDOWN_TIME = 60000;
    private static final String DEFAULT_COUNT_FORMAT = "%ds";
    private String mDefaultText;
    private long mCountDownTime;
    private long mInterval;
    private String mCountDownFormat;
    private boolean mEnableCountDown = true;
    private View.OnClickListener mOnClickListener;
    private CountDownTimer mCountDownTimer;
    private boolean isCountDownNow;

    public CountDownButton(Context context) {
        this(context, null);
    }

    public CountDownButton(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.CountDownButtonStyle);
    }

    public CountDownButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.initAttr(context, attrs, defStyleAttr);
        if (this.mCountDownTimer == null) {
            this.mCountDownTimer = new CountDownTimer(this.mCountDownTime, this.mInterval){

                public void onTick(long millisUntilFinished) {
                    CountDownButton.this.setText(String.format(Locale.CHINA, CountDownButton.this.mCountDownFormat, millisUntilFinished / 1000L));
                }

                public void onFinish() {
                    CountDownButton.this.isCountDownNow = false;
                    CountDownButton.this.setEnabled(true);
                    CountDownButton.this.setText(CountDownButton.this.mDefaultText);
                }
            };
        }
    }

    private void initAttr(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CountDownButton, defStyleAttr, 0);
        this.mCountDownFormat = typedArray.getString(R.styleable.CountDownButton_cdbt_countDownFormat);
        if (TextUtils.isEmpty((CharSequence)this.mCountDownFormat)) {
            this.mCountDownFormat = DEFAULT_COUNT_FORMAT;
        }
        this.mCountDownTime = typedArray.getInteger(R.styleable.CountDownButton_cdbt_countDown, 60000);
        this.mInterval = typedArray.getInteger(R.styleable.CountDownButton_cdbt_countDownInterval, 1000);
        this.mEnableCountDown = this.mCountDownTime > this.mInterval && typedArray.getBoolean(R.styleable.CountDownButton_cdbt_enableCountDown, true);
        typedArray.recycle();
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        super.setOnClickListener(onClickListener);
        this.mOnClickListener = onClickListener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 1: {
                Rect rect = new Rect();
                this.getWindowVisibleDisplayFrame(rect);
                if (this.mOnClickListener != null && rect.contains((int)event.getRawX(), (int)event.getRawY())) {
                    this.mOnClickListener.onClick((View)this);
                }
                if (!this.mEnableCountDown || !rect.contains((int)event.getRawX(), (int)event.getRawY())) break;
                this.startCountDown();
                break;
            }
            case 2: {
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    private void startCountDown() {
        this.mDefaultText = this.getText().toString();
        this.setEnabled(false);
        this.mCountDownTimer.start();
        this.isCountDownNow = true;
    }

    public CountDownButton setEnableCountDown(boolean enableCountDown) {
        this.mEnableCountDown = this.mCountDownTime > this.mInterval && enableCountDown;
        return this;
    }

    public CountDownButton setCountDownFormat(String countDownFormat) {
        this.mCountDownFormat = countDownFormat;
        return this;
    }

    public CountDownButton setCountDownTime(long countDownTime) {
        this.mCountDownTime = countDownTime;
        return this;
    }

    public CountDownButton setInterval(long interval) {
        this.mInterval = interval;
        return this;
    }

    public boolean isCountDownNow() {
        return this.isCountDownNow;
    }

    public CountDownButton setCountDown(long count, long interval, String countDownFormat) {
        this.mCountDownTime = count;
        this.mCountDownFormat = countDownFormat;
        this.mInterval = interval;
        this.setEnableCountDown(true);
        return this;
    }

    public void cancelCountDown() {
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
        }
        this.isCountDownNow = false;
        this.setText(this.mDefaultText);
        this.setEnabled(true);
    }

    public void setEnabled(boolean enabled) {
        if (this.isCountDownNow()) {
            return;
        }
        super.setEnabled(enabled);
        this.setClickable(enabled);
    }
}

